/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.login;

import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.login.internal.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.security.cert.X509Certificate;
import org.globus.gsi.OpenSSLKey;

public class LoginInput {
    private static final String ASSERTIONS_PARAMETER_NULL = Messages.assertionsParameterNull;
    private static final String ASSERTIONS_STRING_EMPTY = Messages.assertionsStringEmpty;
    private X509Certificate certificate;
    private OpenSSLKey key;
    private String password;
    private String usernameLDAP;
    private final User.Type type;

    public LoginInput(X509Certificate certificate, OpenSSLKey key, String password) {
        Assertions.isDefined((Object)certificate, (String)StringUtils.format((String)ASSERTIONS_PARAMETER_NULL, (Object[])new Object[]{Messages.certificate}));
        Assertions.isDefined((Object)key, (String)StringUtils.format((String)ASSERTIONS_PARAMETER_NULL, (Object[])new Object[]{Messages.key}));
        this.type = User.Type.certificate;
        this.certificate = certificate;
        this.key = key;
        this.password = password;
    }

    public LoginInput(String usernameLDAP, String password) {
        Assertions.isDefined((Object)usernameLDAP, (String)StringUtils.format((String)ASSERTIONS_PARAMETER_NULL, (Object[])new Object[]{Messages.usernameLDAP}));
        Assertions.isDefined((Object)password, (String)StringUtils.format((String)ASSERTIONS_PARAMETER_NULL, (Object[])new Object[]{Messages.password}));
        Assertions.isTrue((usernameLDAP.length() > 0 ? 1 : 0) != 0, (String)StringUtils.format((String)ASSERTIONS_STRING_EMPTY, (Object[])new Object[]{Messages.usernameLDAP}));
        this.type = User.Type.ldap;
        this.usernameLDAP = usernameLDAP;
        this.password = password;
    }

    public LoginInput(boolean anonymousLogin) {
        this.type = User.Type.single;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public OpenSSLKey getKey() {
        return this.key;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsernameLDAP() {
        return this.usernameLDAP;
    }

    public User.Type getType() {
        return this.type;
    }
}

