/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.WorkflowNodeLabelConnectionHelper;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowLabelMoveCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeMoveCommand;
import de.rcenvironment.core.gui.workflow.editor.handlers.OvalBorderMoveHandle;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import de.rcenvironment.core.gui.workflow.parts.CustomShortestPathConnectionRouter;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class WorkflowPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
IAdaptable {
    private final List<ConnectionWrapper> connections = new ArrayList<ConnectionWrapper>();

    public final void activate() {
        super.activate();
        ((PropertiesChangeSupport)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        this.updateConnectionWrappers();
        this.propertyChange(new PropertyChangeEvent(this, "e.rcenvironment.wf.cn", null, null));
        this.propertyChange(new PropertyChangeEvent(this, "e.rcenvironment.wf.n", null, null));
        this.propertyChange(new PropertyChangeEvent(this, "e.rcenvironment.wf.l", null, null));
    }

    public final void deactivate() {
        super.deactivate();
        ((PropertiesChangeSupport)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("e.rcenvironment.wf.cn".equals(prop)) {
            this.updateConnectionWrappers();
            for (Object part : this.getChildren()) {
                if (!(part instanceof WorkflowNodePart)) continue;
                ((WorkflowNodePart)part).refreshConnections();
                this.refreshConnectionLabels(part);
            }
        } else if ("e.rcenvironment.wf.n".equals(prop)) {
            ((WorkflowDescription)this.getModel()).sortWorkflowNodesByZIndex();
            this.refreshChildren();
        } else if ("e.rcenvironment.wf.l".equals(prop)) {
            ((WorkflowDescription)this.getModel()).sortWorkflowLabelsByZIndex();
            this.refreshChildren();
        }
    }

    private void refreshConnectionLabels(Object part) {
        boolean labelsShown = Activator.getInstance().getPreferenceStore().getBoolean("showConnections");
        ArrayList sourceAndTargetConnectionParts = new ArrayList();
        sourceAndTargetConnectionParts.addAll(((WorkflowNodePart)part).getTargetConnections());
        sourceAndTargetConnectionParts.addAll(((WorkflowNodePart)part).getSourceConnections());
        for (ConnectionPart connectionPart : sourceAndTargetConnectionParts) {
            if (labelsShown) {
                connectionPart.showLabel();
                continue;
            }
            connectionPart.hideLabel();
        }
    }

    public final List<ConnectionWrapper> getConnections() {
        return this.connections;
    }

    protected List<PropertiesChangeSupport> getModelChildren() {
        ArrayList<PropertiesChangeSupport> combinedChildren = new ArrayList<PropertiesChangeSupport>();
        combinedChildren.addAll(((WorkflowDescription)this.getModel()).getWorkflowLabels());
        combinedChildren.addAll(((WorkflowDescription)this.getModel()).getWorkflowNodes());
        return combinedChildren;
    }

    private void updateConnectionWrappers() {
        this.connections.clear();
        List connectionsInModel = ((WorkflowDescription)this.getModel()).getConnections();
        for (Connection c : connectionsInModel) {
            boolean alreadyPresent = false;
            for (ConnectionWrapper connectionWrapper : this.connections) {
                if (!connectionWrapper.getSource().equals((Object)c.getSourceNode()) || !connectionWrapper.getTarget().equals((Object)c.getTargetNode())) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) continue;
            ConnectionWrapper w = new ConnectionWrapper(c.getSourceNode(), c.getTargetNode());
            w.setTargetArrow(true);
            this.connections.add(w);
        }
        for (ConnectionWrapper wrapper : this.connections) {
            for (Connection c : connectionsInModel) {
                if (!c.getSourceNode().getIdentifier().equals(wrapper.getSource().getIdentifier()) || !c.getTargetNode().getIdentifier().equals(wrapper.getTarget().getIdentifier())) continue;
                wrapper.incrementNumberOfConnections();
            }
        }
    }

    protected final IFigure createFigure() {
        BackgroundLayer f = new BackgroundLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setAntialias(1);
        connLayer.setConnectionRouter((ConnectionRouter)new CustomShortestPathConnectionRouter((IFigure)f));
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new WorkflowXYLayoutEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> helpers = new ArrayList<Object>();
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                helpers.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                helpers.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (helpers.size() == 0) {
                return null;
            }
            return new CompoundSnapToHelper(helpers.toArray(new SnapToHelper[0]));
        }
        return super.getAdapter(key);
    }

    private class BackgroundLayer
    extends FreeformLayer
    implements FigureListener {
        private final Image orgImage = Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.gui.workflow.editor.background");
        private Image image;
        private int x;
        private int y;

        BackgroundLayer() {
            this.resize();
            this.addFigureListener(this);
        }

        private void resize() {
            Rectangle targetRect = this.getBounds().getCopy();
            if (this.orgImage != null && targetRect.height != 0) {
                int sizeY;
                int sizeX;
                float scaleX = (float)targetRect.width / (float)this.orgImage.getBounds().width;
                float scaleY = (float)targetRect.height / (float)this.orgImage.getBounds().height;
                if (scaleX < scaleY) {
                    sizeX = (int)((float)this.orgImage.getBounds().width * scaleX);
                    sizeY = (int)((float)this.orgImage.getBounds().height * scaleX);
                } else {
                    sizeX = (int)((float)this.orgImage.getBounds().width * scaleY);
                    sizeY = (int)((float)this.orgImage.getBounds().height * scaleY);
                }
                this.x = (targetRect.width - sizeX) / 2;
                this.y = (targetRect.height - sizeY) / 2;
                if (this.image != null) {
                    this.image.dispose();
                }
                this.image = new Image((Device)Display.getDefault(), this.orgImage.getImageData().scaledTo(sizeX, sizeY));
            }
        }

        protected void paintFigure(Graphics graphics) {
            if (this.image != null) {
                graphics.drawImage(this.image, this.x, this.y);
            }
            super.paintFigure(graphics);
        }

        public void figureMoved(IFigure arg0) {
            this.resize();
        }
    }

    class WorkflowXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        WorkflowXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof WorkflowNodePart && constraint instanceof Rectangle) {
                ArrayList<Connection> relatedConnections = new ArrayList<Connection>();
                if (WorkflowPart.this.getModel() instanceof WorkflowDescription) {
                    WorkflowDescription workflowDescription = (WorkflowDescription)WorkflowPart.this.getModel();
                    for (Connection connection : workflowDescription.getConnections()) {
                        if (!connection.getTargetNode().getIdentifier().equals(((WorkflowNode)child.getModel()).getIdentifier()) && !connection.getSourceNode().getIdentifier().equals(((WorkflowNode)child.getModel()).getIdentifier()) || !this.checkIfSourceAndTargetAreSelected(connection.getSourceNode(), connection.getTargetNode(), child.getViewer().getSelectedEditParts())) continue;
                        relatedConnections.add(connection);
                    }
                }
                return new WorkflowNodeMoveCommand((WorkflowNode)child.getModel(), request, (Rectangle)constraint, relatedConnections);
            }
            if (child instanceof WorkflowLabelPart && constraint instanceof Rectangle) {
                return new WorkflowLabelMoveCommand((WorkflowLabel)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            if (child instanceof WorkflowNodePart) {
                return new NoBorderEditPolicy(child);
            }
            return super.createChildEditPolicy(child);
        }

        private boolean checkIfSourceAndTargetAreSelected(WorkflowNode sourceNode, WorkflowNode targetNode, List<?> selectedEditParts) {
            boolean sourceContained = false;
            boolean targetContained = false;
            for (Object part : selectedEditParts) {
                if (!(part instanceof WorkflowNodePart)) continue;
                WorkflowNode selectedNode = (WorkflowNode)((WorkflowNodePart)part).getModel();
                if (sourceNode.getIdentifier().equals(selectedNode.getIdentifier())) {
                    sourceContained = true;
                }
                if (!targetNode.getIdentifier().equals(selectedNode.getIdentifier())) continue;
                targetContained = true;
            }
            return sourceContained && targetContained;
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object childClass = request.getNewObjectType();
            if (childClass == WorkflowNode.class) {
                WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper((WorkflowNode)request.getNewObject(), (WorkflowDescription)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
                return helper.createCommand();
            }
            if (childClass == WorkflowLabel.class) {
                WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper((WorkflowLabel)request.getNewObject(), (WorkflowDescription)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
                return helper.createCommand();
            }
            return null;
        }

        private class NoBorderEditPolicy
        extends NonResizableEditPolicy {
            private final EditPart child;

            NoBorderEditPolicy(EditPart child) {
                this.child = child;
            }

            protected List<MoveHandle> createSelectionHandles() {
                ArrayList<MoveHandle> list = new ArrayList<MoveHandle>();
                if (this.isDragAllowed()) {
                    if (this.child instanceof WorkflowNodePart && ((WorkflowNode)((WorkflowNodePart)this.child).getModel()).getComponentDescription().getComponentInstallation().getComponentRevision().getComponentInterface().getShape() == ComponentShape.CIRCLE) {
                        list.add(new OvalBorderMoveHandle((GraphicalEditPart)this.child));
                    } else {
                        list.add(new MoveHandle((GraphicalEditPart)this.child));
                    }
                }
                return list;
            }
        }
    }
}

