/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class GUIWorkflowDescriptionLoaderCallback
implements WorkflowDescriptionLoaderCallback {
    public static final String PREFS_KEY_UPDATEAUTOMATICALLY = "de.rcenvironment.rce.gui.workflow.editor.updateautomatically";
    private static final String WORKFLOW_FILE_ERROR = "Workflow File Error";
    private IFile wfFileFromWorkspace = null;

    public GUIWorkflowDescriptionLoaderCallback() {
    }

    public GUIWorkflowDescriptionLoaderCallback(IFile wfFile) {
        this.wfFileFromWorkspace = wfFile;
    }

    public void onNonSilentWorkflowFileUpdated(String message, final String backupFilename) {
        this.refreshWorkflowIfLoadedFromWorkspace();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IPreferenceStore prefs = Activator.getInstance().getPreferenceStore();
                if (!prefs.getString(GUIWorkflowDescriptionLoaderCallback.PREFS_KEY_UPDATEAUTOMATICALLY).equals(String.valueOf(true))) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.incompatibleVersionTitle, (String)StringUtils.format((String)Messages.incompatibleVersionMessage, (Object[])new Object[]{backupFilename}), (String)Messages.updateIncompatibleVersionSilently, (boolean)false, (IPreferenceStore)prefs, (String)GUIWorkflowDescriptionLoaderCallback.PREFS_KEY_UPDATEAUTOMATICALLY);
                    prefs.putValue(GUIWorkflowDescriptionLoaderCallback.PREFS_KEY_UPDATEAUTOMATICALLY, String.valueOf(dialog.getToggleState()));
                }
            }
        });
    }

    public void onSilentWorkflowFileUpdated(String message) {
        this.refreshWorkflowIfLoadedFromWorkspace();
    }

    public boolean arePartlyParsedWorkflowConsiderValid() {
        return true;
    }

    public void onWorkflowFileParsingPartlyFailed(final String backupFilename) {
        this.refreshWorkflowIfLoadedFromWorkspace();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)GUIWorkflowDescriptionLoaderCallback.WORKFLOW_FILE_ERROR, (String)StringUtils.format((String)"Failed to parse the workflow.  Most likely reasons:\n\na) Workflow file was opened with a newer version of RCE before.\nb) An integrated tool has changed its inputs/outputs.\n\nSome parts of the workflow were skipped. See log for more details.\n\nA backup file was created: %s", (Object[])new Object[]{backupFilename}));
            }
        });
    }

    private void refreshWorkflowIfLoadedFromWorkspace() {
        if (this.wfFileFromWorkspace != null) {
            try {
                this.wfFileFromWorkspace.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Failed to refresh the workspace after workflow file '%s' was updated", (Object[])new Object[]{this.wfFileFromWorkspace.getRawLocation().toOSString()}));
            }
        }
    }
}

