/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class EndpointLabelProvider
extends LabelProvider {
    private static final int INPUT_REQUIRED_DECORATOR_LOCATION = 1;
    private static final int INPUT_CONNECTED_DECORATOR_LOCATION = 0;
    private static final int ICON_SIZE = 16;
    private Log log = LogFactory.getLog(EndpointLabelProvider.class);
    private Image componentImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
    private Image inputImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INPUT_16);
    private Image outputImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.OUTPUT_16);
    private ImageDescriptor inputConnectedDecorationIcon = ImageDescriptor.createFromURL((URL)EndpointLabelProvider.class.getResource("/resources/icons/inputDecorationArrow.gif"));
    private ImageDescriptor inputRequiredDecorationIcon = ImageDescriptor.createFromURL((URL)EndpointLabelProvider.class.getResource("/resources/icons/inputDecorationAsteriks.gif"));
    private Map<String, Image> componentImages = new HashMap<String, Image>();
    private EndpointType type;
    private Map<Image, Image> connectedDecoratorCache = new HashMap<Image, Image>();
    private Map<Image, Image> requiredDecoratorCache = new HashMap<Image, Image>();

    public EndpointLabelProvider(EndpointType type) {
        this.type = type;
    }

    public String getText(Object element) {
        String name = element instanceof WorkflowNode ? ((WorkflowNode)element).getName() : (element instanceof EndpointContentProvider.Endpoint ? ((EndpointContentProvider.Endpoint)element).getName() : "");
        return name;
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof WorkflowNode) {
            ComponentDescription componentDesc = ((WorkflowNode)element).getComponentDescription();
            if (this.componentImages.containsKey(componentDesc.getIdentifier())) {
                image = this.componentImages.get(componentDesc.getIdentifier());
            } else {
                byte[] icon = componentDesc.getIcon16();
                if (icon != null) {
                    image = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(icon));
                    if (!image.isDisposed() && image != null) {
                        this.componentImages.put(componentDesc.getIdentifier(), image);
                    }
                } else {
                    image = this.componentImage;
                }
            }
        } else if (element instanceof EndpointContentProvider.Endpoint) {
            image = this.type == EndpointType.INPUT ? this.inputImage : this.outputImage;
            if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.ShortText) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_SHORTTEXT_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.Boolean) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_BOOLEAN_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.Integer) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_INTEGER_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.Float) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_FLOAT_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.Vector) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_VECTOR_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.Matrix) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_MATRIX_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.SmallTable) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_SMALLTABLE_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.DateTime) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_DATETIME_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.FileReference) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_FILE_16);
            } else if (((EndpointContentProvider.Endpoint)element).getEndpointDescription().getDataType() == DataType.DirectoryReference) {
                image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DATATYPE_DIRECTORY_16);
            }
            image = this.checkForDecorators(((EndpointContentProvider.Endpoint)element).getEndpointDescription(), image);
        }
        if (image == null || image.isDisposed()) {
            this.log.warn((Object)("Image for " + element + " is null or disposed."));
        }
        return image;
    }

    private Image checkForDecorators(EndpointDescription endpointDescription, Image image) {
        boolean inputRequired = false;
        boolean inputConnected = false;
        if (this.type == EndpointType.INPUT & endpointDescription.isConnected()) {
            inputConnected = true;
        }
        if (this.type == EndpointType.INPUT & endpointDescription.isRequired()) {
            inputRequired = true;
        }
        if (inputRequired && !inputConnected) {
            if (this.requiredDecoratorCache.keySet().contains(image)) {
                image = this.requiredDecoratorCache.get(image);
            } else {
                ImageDescriptor[] decorations = new ImageDescriptor[5];
                decorations[1] = this.inputRequiredDecorationIcon;
                Image originalImage = image;
                image = this.createDecoratedImage(originalImage, decorations);
                this.requiredDecoratorCache.put(originalImage, image);
            }
        } else if (inputConnected) {
            if (this.connectedDecoratorCache.keySet().contains(image)) {
                image = this.connectedDecoratorCache.get(image);
            } else {
                ImageDescriptor[] decorations = new ImageDescriptor[5];
                decorations[0] = this.inputConnectedDecorationIcon;
                Image originalImage = image;
                image = this.createDecoratedImage(originalImage, decorations);
                this.connectedDecoratorCache.put(originalImage, image);
            }
        }
        return image;
    }

    private Image createDecoratedImage(Image originalImage, ImageDescriptor[] decorations) {
        DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(originalImage, decorations, new Point(16, 16));
        Image decoratedImage = decorationOverlayIcon.createImage();
        return decoratedImage;
    }

    public void dispose() {
        for (Image image : this.componentImages.values()) {
            image.dispose();
        }
        for (Image image : this.connectedDecoratorCache.values()) {
            image.dispose();
        }
        this.connectedDecoratorCache.clear();
        for (Image image : this.requiredDecoratorCache.values()) {
            image.dispose();
        }
        this.requiredDecoratorCache.clear();
    }
}

