/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.xml.internal;

import de.rcenvironment.core.authorization.AuthorizationStore;
import de.rcenvironment.core.authorization.AuthorizationStoreException;
import de.rcenvironment.core.authorization.rbac.Permission;
import de.rcenvironment.core.authorization.rbac.Role;
import de.rcenvironment.core.authorization.rbac.Subject;
import de.rcenvironment.core.authorization.xml.internal.XMLAuthorizationConfiguration;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import de.rcenvironment.core.utils.incubator.xml.XMLIOSupport;
import de.rcenvironment.core.utils.incubator.xml.XMLSupport;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.osgi.framework.BundleContext;

public class XMLAuthorizationStore
implements AuthorizationStore {
    private static final String ERROR_PARSING_DOCUMENT = "Error while parsing the XML document.";
    private static final String ERROR_ARGUMENT_IS_NULL = "Argument for parameter %s is null.";
    private static final String XPATH_QUERY_SELECT_DESCRIPTION = "./description";
    private static final String XPATH_QUERY_SELECT_ROLES = "child::role";
    private static final String XPATH_QUERY_SELECT_PERMISSIONS = "child::permission";
    private static final String XPATH_QUERY_SELECT_SUBJECT = "//subject[@id='%s']";
    private static final String XPATH_QUERY_SELECT_ROLE = "//role[@id='%s']";
    private static final String XPATH_QUERY_SELECT_ALL_ROLES = "//roles/*";
    private static final String XPATH_QUERY_SELECT_PERMISSION = "//permission[@id='%s']";
    private static final String XPATH_QUERY_SELECT_ALL_PERMISSIONS = "//permissions/*";
    private static final String XPATH_QUERY_SELECT_ID = "attribute::id";
    private static final Log LOGGER = LogFactory.getLog(XMLAuthorizationStore.class);
    private XMLAuthorizationConfiguration myConfiguration;
    private Document myXMLDocument = null;
    private ConfigurationService configurationService;
    private String bundleSymbolicName;

    protected void activate(BundleContext context) {
        this.bundleSymbolicName = context.getBundle().getSymbolicName();
        this.myConfiguration = new XMLAuthorizationConfiguration();
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    public void initialize() throws AuthorizationStoreException {
        try {
            String absPath = this.configurationService.resolveBundleConfigurationPath(this.bundleSymbolicName, this.myConfiguration.getXmlFile());
            if (absPath != null && new File(absPath).exists()) {
                this.myXMLDocument = XMLIOSupport.readXML((String)absPath);
            } else {
                this.myXMLDocument = XMLIOSupport.readXML((InputStream)this.getClass().getResourceAsStream("/placeholder.xml"));
                LOGGER.info((Object)("No authorization store is given under: " + absPath + ". Using an empty one."));
            }
        }
        catch (DocumentException e) {
            throw new AuthorizationStoreException(ERROR_PARSING_DOCUMENT, (Throwable)e);
        }
        LOGGER.info((Object)"XML authorization store initialized.");
    }

    public Permission lookupPermission(String permissionID) {
        Assertions.isDefined((Object)permissionID, (String)StringUtils.format((String)ERROR_ARGUMENT_IS_NULL, (Object[])new Object[]{"permissionID"}));
        try {
            LOGGER.debug((Object)("Retrieving entry for permission: " + permissionID));
            return this.getPermission(permissionID);
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    public Role lookupRole(String roleID) {
        Assertions.isDefined((Object)roleID, (String)StringUtils.format((String)ERROR_ARGUMENT_IS_NULL, (Object[])new Object[]{"roleID"}));
        try {
            LOGGER.debug((Object)("Retrieving entry for role: " + roleID));
            return this.getRole(roleID);
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    public Subject lookupSubject(String subjectID) {
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_ARGUMENT_IS_NULL, (Object[])new Object[]{"subjectID"}));
        try {
            LOGGER.debug((Object)("Retrieving entry for subject: " + subjectID));
            return this.getSubject(subjectID);
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    private Subject getSubject(String subjectID) throws DocumentException {
        Node subjectNode = XMLSupport.selectNode((Node)this.myXMLDocument, (String)StringUtils.format((String)XPATH_QUERY_SELECT_SUBJECT, (Object[])new Object[]{subjectID}));
        return this.getSubject(subjectNode);
    }

    private Role getRole(String roleID) throws DocumentException {
        Node roleNode = XMLSupport.selectNode((Node)this.myXMLDocument, (String)StringUtils.format((String)XPATH_QUERY_SELECT_ROLE, (Object[])new Object[]{roleID}));
        return this.getRole(roleNode);
    }

    private Permission getPermission(String permissionID) throws DocumentException {
        Node permissionNode = XMLSupport.selectNode((Node)this.myXMLDocument, (String)StringUtils.format((String)XPATH_QUERY_SELECT_PERMISSION, (Object[])new Object[]{permissionID}));
        return this.getPermission(permissionNode);
    }

    private Subject getSubject(Node subjectNode) throws DocumentException {
        String id = this.getID(subjectNode);
        String description = this.getDescription(subjectNode);
        List roleNodes = XMLSupport.selectNodes((Node)subjectNode, (String)XPATH_QUERY_SELECT_ROLES);
        HashSet<Role> roles = new HashSet<Role>();
        for (Node roleNode : roleNodes) {
            Set<String> roleIDs = this.getMatchingRoleIDs(roleNode.getText());
            for (String roleID : roleIDs) {
                roles.add(this.getRole(roleID));
            }
        }
        if (description.isEmpty()) {
            return new Subject(id, roles);
        }
        return new Subject(id, description, roles);
    }

    private Role getRole(Node roleNode) throws DocumentException {
        String id = this.getID(roleNode);
        String description = this.getDescription(roleNode);
        List permissionNodes = XMLSupport.selectNodes((Node)roleNode, (String)XPATH_QUERY_SELECT_PERMISSIONS);
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (Node permissionNode : permissionNodes) {
            Set<String> permissionIDs = this.getMatchingPermissionIDs(permissionNode.getText());
            for (String permissionID : permissionIDs) {
                permissions.add(this.getPermission(permissionID));
            }
        }
        if (description.isEmpty()) {
            return new Role(id, permissions);
        }
        return new Role(id, description, permissions);
    }

    private Permission getPermission(Node permissionNode) throws DocumentException {
        String id = this.getID(permissionNode);
        String description = this.getDescription(permissionNode);
        if (description.isEmpty()) {
            return new Permission(id);
        }
        return new Permission(id, description);
    }

    private String getDescription(Node node) throws DocumentException {
        Node descriptionNode = XMLSupport.selectNode((Node)node, (String)XPATH_QUERY_SELECT_DESCRIPTION);
        if (descriptionNode != null) {
            return descriptionNode.getText();
        }
        return "";
    }

    private String getID(Node node) throws DocumentException {
        Node idNode = XMLSupport.selectNode((Node)node, (String)XPATH_QUERY_SELECT_ID);
        if (idNode != null) {
            return idNode.getText();
        }
        throw new DocumentException(ERROR_PARSING_DOCUMENT);
    }

    private Set<String> getMatchingRoleIDs(String regExpressedRoleID) throws DocumentException {
        HashSet<String> permissionIDs = new HashSet<String>();
        List roleNodes = XMLSupport.selectNodes((Node)this.myXMLDocument, (String)XPATH_QUERY_SELECT_ALL_ROLES);
        for (Node roleNode : roleNodes) {
            String id = this.getID(roleNode);
            if (!id.matches(regExpressedRoleID)) continue;
            permissionIDs.add(id);
        }
        return permissionIDs;
    }

    private Set<String> getMatchingPermissionIDs(String regExpressedPermissionID) throws DocumentException {
        HashSet<String> permissionIDs = new HashSet<String>();
        List permissionNodes = XMLSupport.selectNodes((Node)this.myXMLDocument, (String)XPATH_QUERY_SELECT_ALL_PERMISSIONS);
        for (Node permissionNode : permissionNodes) {
            String id = this.getID(permissionNode);
            if (!id.matches(regExpressedPermissionID)) continue;
            permissionIDs.add(id);
        }
        return permissionIDs;
    }
}

