/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution.internal;

import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryAccess;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class EvaluationMemoryFileAccessImpl
implements EvaluationMemoryAccess {
    private static final String VERSION_NUMBER = "1";
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private static final String OUTPUTS = "outputs";
    private static final String INPUTS = "inputs";
    private static final List<DataType> ALWAYS_VALID_OUTPUT_DATATYPES = new ArrayList<DataType>();
    private final File evalMemoryFile;
    private TypedDatumSerializer typedDatumSerializer;

    static {
        ALWAYS_VALID_OUTPUT_DATATYPES.add(DataType.NotAValue);
    }

    public EvaluationMemoryFileAccessImpl(String memoryFilePath) {
        this.evalMemoryFile = new File(memoryFilePath);
    }

    @Override
    public synchronized void setInputsOutputsDefinition(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs) throws IOException {
        Properties evalMemory = this.loadEvaluationMemory();
        this.addInputsDefinition(inputs, evalMemory);
        this.addOutputsDefinition(outputs, evalMemory);
        this.storeEvaluationMemory(evalMemory);
    }

    @Override
    public synchronized void addEvaluationValues(SortedMap<String, TypedDatum> inputValues, SortedMap<String, TypedDatum> outputValues) throws IOException {
        Properties evalMemory = this.loadEvaluationMemory();
        this.validateInputs(evalMemory, this.getEndpoints(inputValues));
        this.validateOutputs(evalMemory, this.getEndpoints(outputValues));
        String evalMemoryKey = this.createEvaluationMemoryKeyForInputValues(inputValues);
        ArrayList<String> evalMemoryValues = new ArrayList<String>();
        for (TypedDatum value : outputValues.values()) {
            evalMemoryValues.add(this.typedDatumSerializer.serialize(value));
        }
        evalMemory.put(evalMemoryKey, StringUtils.escapeAndConcat(evalMemoryValues));
        this.storeEvaluationMemory(evalMemory);
    }

    private void storeEvaluationMemory(Properties evalMemory) throws IOException {
        evalMemory.put(VERSION, VERSION_NUMBER);
        evalMemory.put(TYPE, "de.rcenvironment.evaluationmemory");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream memoryFileOutputStream = new FileOutputStream(this.evalMemoryFile);){
            evalMemory.store(memoryFileOutputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SortedMap<String, TypedDatum> getEvaluationResult(SortedMap<String, TypedDatum> inputValues, SortedMap<String, DataType> outputs) throws IOException {
        Properties evalMemory = this.loadEvaluationMemory();
        this.validateInputs(evalMemory, this.getEndpoints(inputValues));
        this.validateOutputs(evalMemory, outputs);
        TreeMap<String, TypedDatum> outputValues = null;
        String evalMemoryKey = this.createEvaluationMemoryKeyForInputValues(inputValues);
        if (evalMemory.containsKey(evalMemoryKey)) {
            String[] serializedEvaluationResult = StringUtils.splitAndUnescape((String)evalMemory.getProperty(evalMemoryKey));
            outputValues = new TreeMap<String, TypedDatum>();
            int i = 0;
            for (String output : outputs.keySet()) {
                outputValues.put(output, this.typedDatumSerializer.deserialize(serializedEvaluationResult[i++]));
            }
        }
        return outputValues;
    }

    @Override
    public synchronized void validateEvaluationMemory(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs) throws IOException {
        Properties evalMemory = this.loadEvaluationMemory();
        this.validateVersionAndType(evalMemory);
        this.validateInputs(evalMemory, inputs);
        this.validateOutputs(evalMemory, outputs);
        this.validateEvaluationMemoryEntries(inputs, outputs, evalMemory);
    }

    private void addInputsDefinition(SortedMap<String, DataType> inputs, Properties evalMemory) {
        evalMemory.put(INPUTS, this.createEndpointDefinitionEntry(inputs));
    }

    private void addOutputsDefinition(SortedMap<String, DataType> outputs, Properties evalMemory) {
        evalMemory.put(OUTPUTS, this.createEndpointDefinitionEntry(outputs));
    }

    private String createEndpointDefinitionEntry(Map<String, DataType> endpoints) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<String, DataType> outputEntry : endpoints.entrySet()) {
            parts.add(outputEntry.getKey());
            parts.add(outputEntry.getValue().name());
        }
        return StringUtils.escapeAndConcat(parts);
    }

    private void validateEvaluationMemoryEntries(SortedMap<String, DataType> inputs, SortedMap<String, DataType> outputs, Properties evalMemory) throws IOException {
        for (Object key : evalMemory.keySet()) {
            if (key.equals(INPUTS) || key.equals(OUTPUTS) || key.equals(VERSION) || key.equals(TYPE)) continue;
            this.validateEvaluationMemoryEntry(inputs, (String)key);
            this.validateEvaluationMemoryEntry(outputs, evalMemory.getProperty((String)key));
        }
    }

    private void validateEvaluationMemoryEntry(SortedMap<String, DataType> endpoints, String evalMemoryEntry) throws IOException {
        String[] typedDatumParts = StringUtils.splitAndUnescape((String)evalMemoryEntry);
        ArrayList<TypedDatum> typedDatums = new ArrayList<TypedDatum>();
        String[] stringArray = typedDatumParts;
        int n = typedDatumParts.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            try {
                typedDatums.add(this.typedDatumSerializer.deserialize(value));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Failed to read values from evaluation memory file", e);
            }
            ++n2;
        }
        if (typedDatums.size() != endpoints.size()) {
            this.throwIOException(endpoints, typedDatums);
        }
        int i = 0;
        for (DataType dataType : endpoints.values()) {
            if (ALWAYS_VALID_OUTPUT_DATATYPES.contains(((TypedDatum)typedDatums.get(i)).getDataType())) continue;
            if (dataType != ((TypedDatum)typedDatums.get(i)).getDataType()) {
                this.throwIOException(endpoints, typedDatums);
            }
            ++i;
        }
    }

    private void throwIOException(SortedMap<String, DataType> endpoints, List<TypedDatum> tuple) throws IOException {
        throw new IOException(StringUtils.format((String)"Input/output data type(s) don't match input/output data type(s) in evaluation memory file - expected: %s actual: %s", (Object[])new Object[]{endpoints, tuple}));
    }

    private void validateVersionAndType(Properties evalMemory) throws IOException {
        if (evalMemory.getProperty(VERSION) == null) {
            throw new IOException("Version information is missing");
        }
        if (!evalMemory.getProperty(VERSION).equals(VERSION_NUMBER)) {
            throw new IOException(StringUtils.format((String)"Version '%s' not supported; expected version: %s", (Object[])new Object[]{evalMemory.getProperty(VERSION), VERSION_NUMBER}));
        }
        if (evalMemory.getProperty(TYPE) == null) {
            throw new IOException("Type information is missing");
        }
        if (!evalMemory.getProperty(TYPE).equals("de.rcenvironment.evaluationmemory")) {
            throw new IOException(StringUtils.format((String)"Type '%s' not supported; expected type: %s", (Object[])new Object[]{evalMemory.getProperty(TYPE), "de.rcenvironment.evaluationmemory"}));
        }
    }

    private void validateInputs(Properties evalMemory, Map<String, DataType> inputs) throws IOException {
        this.validateEndoints(this.getEndpoints(evalMemory, INPUTS), inputs, true);
    }

    private void validateOutputs(Properties evalMemory, Map<String, DataType> outputs) throws IOException {
        this.validateEndoints(this.getEndpoints(evalMemory, OUTPUTS), outputs, false);
    }

    private void validateEndoints(Map<String, DataType> endpointsExpected, Map<String, DataType> actualEndpoints, boolean inputs) throws IOException {
        if (!this.areEndpointsEqual(endpointsExpected, actualEndpoints, inputs)) {
            throw new IOException(StringUtils.format((String)"Input(s)/output(s) don't match input(s)/output(s) in evaluation memory file - expected: %s actual: %s", (Object[])new Object[]{endpointsExpected, actualEndpoints}));
        }
    }

    private boolean areEndpointsEqual(Map<String, DataType> endpointsExpected, Map<String, DataType> actualEndpoints, boolean inputs) {
        boolean equals;
        boolean bl = equals = endpointsExpected.size() == actualEndpoints.size();
        if (equals) {
            for (Map.Entry<String, DataType> endpointEntry : actualEndpoints.entrySet()) {
                if (!inputs && ALWAYS_VALID_OUTPUT_DATATYPES.contains(endpointEntry.getValue()) || endpointsExpected.containsKey(endpointEntry.getKey()) && endpointsExpected.get(endpointEntry.getKey()).equals((Object)endpointEntry.getValue())) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    private Properties loadEvaluationMemory() throws IOException {
        Properties evalMemory = new Properties();
        if (!this.evalMemoryFile.exists()) {
            throw new FileNotFoundException("Evaluation memory file not found; either deleted or not created due to invalid file name");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream memFileInputStream = new FileInputStream(this.evalMemoryFile);){
            evalMemory.load(memFileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return evalMemory;
    }

    private Map<String, DataType> getEndpoints(Properties evalMemory, String key) throws IOException {
        String endpointsEntry = evalMemory.getProperty(key);
        if (endpointsEntry == null) {
            throw new IOException(StringUtils.format((String)"'%s' definition is missing in evaluation memory file: %s (it is required to ensure correct evaluation memory handling, is written by the component, and must not be removed)", (Object[])new Object[]{key, this.evalMemoryFile}));
        }
        String[] parts = StringUtils.splitAndUnescape((String)endpointsEntry);
        HashMap<String, DataType> endpoints = new HashMap<String, DataType>();
        int i = 0;
        while (i < parts.length) {
            endpoints.put(parts[i], DataType.valueOf((String)parts[i + 1]));
            i += 2;
        }
        return endpoints;
    }

    private SortedMap<String, DataType> getEndpoints(SortedMap<String, TypedDatum> endpoints) {
        TreeMap<String, DataType> endpointsWithDataType = new TreeMap<String, DataType>();
        for (Map.Entry<String, TypedDatum> endpointEntry : endpoints.entrySet()) {
            endpointsWithDataType.put(endpointEntry.getKey(), endpointEntry.getValue().getDataType());
        }
        return endpointsWithDataType;
    }

    private String createEvaluationMemoryKeyForInputValues(SortedMap<String, TypedDatum> valuesToEvaluate) {
        ArrayList<String> serializedValues = new ArrayList<String>();
        Iterator<TypedDatum> valuesIterator = valuesToEvaluate.values().iterator();
        while (valuesIterator.hasNext()) {
            serializedValues.add(this.typedDatumSerializer.serialize(valuesIterator.next()));
        }
        return StringUtils.escapeAndConcat(serializedValues);
    }

    protected void setTypedDatumSerializer(TypedDatumSerializer serializer) {
        this.typedDatumSerializer = serializer;
    }
}

