/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.rbac;

import de.rcenvironment.core.authorization.rbac.RBACObject;
import de.rcenvironment.core.authorization.rbac.Role;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Subject
extends RBACObject {
    private static final long serialVersionUID = 6584554867139383429L;
    private final Set<Role> myRoles;

    public Subject(String id, Set<Role> roles) {
        this(id, "", roles);
    }

    public Subject(String id, String description, Set<Role> roles) {
        super(id, description);
        this.myRoles = roles == null ? new HashSet<Role>() : new HashSet<Role>(roles);
    }

    public boolean hasRole(Role role) {
        return this.myRoles.contains(role);
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.myRoles);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Subject && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        String representation = String.valueOf(super.toString()) + " - " + this.myRoles.toString();
        return representation;
    }
}

