/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class RemoveToolIntegrationDialog
extends Dialog {
    private static final String SEPARATOR = ".";
    private static final int LIST_HEIGHT = 200;
    private static final int LIST_WIDTH = 300;
    private final Set<String> integratedConfigs;
    private String[] selectedTools = null;
    private List toolList;
    private Button keepOnDiskButton;
    private boolean keepOnDisk;
    private final Map<String, String> integrationMapping;

    public RemoveToolIntegrationDialog(Shell parent, Set<String> integratedConfigurations, Collection<ToolIntegrationContext> contexts) {
        super(parent);
        this.integratedConfigs = integratedConfigurations;
        this.integrationMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        block0: for (String config : this.integratedConfigs) {
            String type = "";
            for (ToolIntegrationContext c : contexts) {
                if (!config.contains(c.getPrefixForComponentId())) continue;
                type = c.getContextType();
                this.integrationMapping.put(String.valueOf(config.substring(c.getPrefixForComponentId().length())) + " (Type: " + type.substring(type.lastIndexOf(SEPARATOR) + 1) + ")", config);
                continue block0;
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Deactivate Tool");
        shell.setImage(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        new Label(container, 0).setText("Choose tool configuration to deactivate: ");
        this.toolList = new List(container, 2050);
        GridData toolListData = new GridData(1808);
        toolListData.widthHint = 300;
        toolListData.heightHint = 200;
        this.toolList.setLayoutData((Object)toolListData);
        for (String key : this.integrationMapping.keySet()) {
            this.toolList.add(key);
        }
        this.toolList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (RemoveToolIntegrationDialog.this.toolList.getSelectionCount() > 0) {
                    RemoveToolIntegrationDialog.this.selectedTools = RemoveToolIntegrationDialog.this.toolList.getSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.keepOnDiskButton = new Button(container, 32);
        this.keepOnDiskButton.setText("Keep tool configuration on disk");
        this.keepOnDiskButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RemoveToolIntegrationDialog.this.keepOnDisk = RemoveToolIntegrationDialog.this.keepOnDiskButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.keepOnDiskButton.setSelection(true);
        this.keepOnDisk = true;
        return container;
    }

    public boolean getKeepOnDisk() {
        return this.keepOnDisk;
    }

    public String[] getSelectedTools() {
        if (this.selectedTools != null && this.selectedTools.length > 0) {
            String[] selectedIDs = new String[this.selectedTools.length];
            int i = 0;
            while (i < this.selectedTools.length) {
                selectedIDs[i] = this.integrationMapping.get(this.selectedTools[i]);
                ++i;
            }
            return selectedIDs;
        }
        return new String[0];
    }

    public void setSelectedTools(String[] selectedTools) {
        this.selectedTools = selectedTools;
    }
}

