/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallback;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEvent;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEventType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowExecutionControllerBridgeDelegator
implements WorkflowExecutionControllerCallback {
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionControllerBridgeDelegator.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled(WorkflowExecutionControllerBridgeDelegator.class);
    private static final int MAX_CALLBACK_FAILURES = 5;
    private final ComponentExecutionRelatedInstances compExeRelatedInstances;
    private final String wfExeId;
    private AtomicInteger wfExeCtrlCallbackFailureCount = new AtomicInteger(0);

    protected WorkflowExecutionControllerBridgeDelegator(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        this.compExeRelatedInstances = compExeRelatedInstances;
        this.wfExeId = compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier();
    }

    protected boolean isWorkflowControllerReachable() {
        return this.wfExeCtrlCallbackFailureCount.get() < 5;
    }

    @Override
    public synchronized void processConsoleRows(final ConsoleRow[] consoleRows) {
        new WorkflowExecutionControllerCallbackCheckingReachability(this){

            @Override
            protected void call() throws ExecutionControllerException, RemoteOperationException {
                ((WorkflowExecutionControllerBridgeDelegator)this).compExeRelatedInstances.wfExeCtrlBridge.onConsoleRowsProcessed(wfExeId, consoleRows);
            }
        }.callback();
    }

    @Override
    public synchronized void onComponentStateChanged(String compExeId, ComponentState newState, Integer count, String countOnResets) {
        this.onComponentStateChanged(compExeId, newState, count, countOnResets, null);
    }

    @Override
    public synchronized void onComponentStateChanged(String compExeId, ComponentState newState, Integer count, String countOnResets, String errId) {
        this.onComponentStateChanged(compExeId, newState, count, countOnResets, errId, null);
    }

    @Override
    public synchronized void onComponentStateChanged(final String compExeId, final ComponentState newState, final Integer count, final String countOnResets, final String errId, final String errMessage) {
        new WorkflowExecutionControllerCallbackCheckingReachability(this){

            @Override
            protected void call() throws ExecutionControllerException, RemoteOperationException {
                if (errId == null) {
                    ((WorkflowExecutionControllerBridgeDelegator)this).compExeRelatedInstances.wfExeCtrlBridge.onComponentStateChanged(wfExeId, compExeId, newState, count, countOnResets);
                } else if (errMessage == null) {
                    ((WorkflowExecutionControllerBridgeDelegator)this).compExeRelatedInstances.wfExeCtrlBridge.onComponentStateChanged(wfExeId, compExeId, newState, count, countOnResets, errId);
                } else {
                    ((WorkflowExecutionControllerBridgeDelegator)this).compExeRelatedInstances.wfExeCtrlBridge.onComponentStateChanged(wfExeId, compExeId, newState, count, countOnResets, errId, errMessage);
                }
            }
        }.callback();
    }

    @Override
    public synchronized void onInputProcessed(String serializedEndpointDatum) {
        if (this.isWorkflowControllerReachable()) {
            try {
                this.compExeRelatedInstances.wfExeCtrlBridge.onInputProcessed(this.wfExeId, serializedEndpointDatum);
                this.handleWorkflowControllerCallbackSuccess();
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.handleWorkflowControllerCallbackFailure(e);
            }
        }
    }

    @Override
    public synchronized void onComponentHeartbeatReceived(String compExeId) {
        if (this.isWorkflowControllerReachable()) {
            try {
                if (VERBOSE_LOGGING) {
                    LOG.debug((Object)StringUtils.format((String)"Component '%s' (%s) is sending heartbeat to workflow controller '%s' (%s)", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()}));
                }
                this.compExeRelatedInstances.wfExeCtrlBridge.onComponentHeartbeatReceived(this.wfExeId, compExeId);
                this.handleWorkflowControllerCallbackSuccess();
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.handleWorkflowControllerCallbackFailure(e);
            }
        }
    }

    private void handleWorkflowControllerCallbackSuccess() {
        if (this.wfExeCtrlCallbackFailureCount.get() > 0) {
            LOG.debug((Object)StringUtils.format((String)"Callback from local component '%s' (%s) to workflow controller '%s' (%s) succeeded again", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()}));
        }
        this.wfExeCtrlCallbackFailureCount.set(0);
    }

    private void handleWorkflowControllerCallbackFailure(Throwable e) {
        int failureCount = this.wfExeCtrlCallbackFailureCount.incrementAndGet();
        String message = StringUtils.format((String)"Callback from local component '%s' (%s) to workflow controller '%s' (%s) failed", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()});
        this.registerCallbackFailureEvent(message, failureCount, e);
    }

    private void registerCallbackFailureEvent(String message, int failureCount, Throwable cause) {
        if (failureCount >= 5) {
            LOG.error((Object)(String.valueOf(message) + "; maximum number of workflow controller callback failures (" + 5 + ") exceeded, considering the workflow controller unreachable; last cause: " + cause.toString()));
            this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.WF_CRTL_CALLBACK_FAILED, cause));
        } else {
            LOG.warn((Object)(String.valueOf(message) + "; failure count is " + failureCount + " (threshold: " + 5 + "); cause: " + cause.toString()));
        }
    }

    private abstract class WorkflowExecutionControllerCallbackCheckingReachability {
        private WorkflowExecutionControllerCallbackCheckingReachability() {
        }

        protected void callback() {
            if (WorkflowExecutionControllerBridgeDelegator.this.isWorkflowControllerReachable()) {
                try {
                    this.call();
                }
                catch (ExecutionControllerException | RemoteOperationException e) {
                    WorkflowExecutionControllerBridgeDelegator.this.wfExeCtrlCallbackFailureCount.set(5);
                    ((WorkflowExecutionControllerBridgeDelegator)WorkflowExecutionControllerBridgeDelegator.this).compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.WF_CRTL_CALLBACK_FAILED, e));
                }
            }
        }

        protected abstract void call() throws ExecutionControllerException, RemoteOperationException;
    }
}

