/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionController;
import de.rcenvironment.core.component.execution.api.ComponentExecutionControllerService;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.EndpointDatumSerializer;
import de.rcenvironment.core.component.execution.api.ExecutionContext;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallbackService;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionInformationImpl;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionControllerImpl;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceRegistration;

public class ComponentExecutionControllerServiceImpl
implements ComponentExecutionControllerService {
    private static final Log LOG = LogFactory.getLog(ComponentExecutionControllerServiceImpl.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled(ComponentExecutionControllerImpl.class);
    private static final int CANCEL_TIMEOUT_MSEC = 60000;
    private static final int COMPONENT_CONTROLLER_GARBAGE_COLLECTION_INTERVAL_MSEC = 90000;
    private BundleContext bundleContext;
    private CommunicationService communicationService;
    private LocalExecutionControllerUtilsService exeCtrlUtilsService;
    private DistributedComponentKnowledgeService compKnowledgeService;
    private EndpointDatumSerializer endpointDatumSerializer;
    private final Set<String> executionAuthTokens = Collections.synchronizedSet(new HashSet());
    private Map<String, ServiceRegistration<?>> componentServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private Map<String, ComponentExecutionInformation> componentExecutionInformations = Collections.synchronizedMap(new HashMap());
    private ScheduledFuture<?> componentControllerGarbargeCollectionFuture;

    protected void activate(BundleContext context) {
        this.bundleContext = context;
        this.componentControllerGarbargeCollectionFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedRate(new Runnable(){

            @Override
            @TaskDescription(value="Garbage collection: Component controllers")
            public void run() {
                HashSet compExeIds = new HashSet(ComponentExecutionControllerServiceImpl.this.componentExecutionInformations.keySet());
                if (VERBOSE_LOGGING) {
                    LOG.debug((Object)("Running garbage collection for component controllers: " + compExeIds));
                }
                for (String executionId : compExeIds) {
                    ComponentExecutionController componentController = null;
                    try {
                        componentController = ComponentExecutionControllerServiceImpl.this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, ComponentExecutionControllerServiceImpl.this.bundleContext);
                    }
                    catch (ExecutionControllerException e) {
                        LOG.debug((Object)StringUtils.format((String)"Component controller garbage collection: Skip component controller: %s; cause: %s", (Object[])new Object[]{executionId, e.getMessage()}));
                        continue;
                    }
                    if (componentController.isWorkflowControllerReachable()) continue;
                    LOG.debug((Object)("Found component controller with unreachable workflow controller: " + executionId));
                    if (!ComponentConstants.FINAL_COMPONENT_STATES_WITH_DISPOSED.contains((Object)componentController.getState())) {
                        try {
                            LOG.debug((Object)("Cancel component controller: " + executionId));
                            componentController.cancelSync(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                        catch (RuntimeException e) {
                            LOG.error((Object)("Cancelling component during garbage collecting failed: " + executionId), (Throwable)e);
                        }
                    }
                    if (!ComponentConstants.FINAL_COMPONENT_STATES.contains((Object)componentController.getState())) continue;
                    try {
                        LOG.debug((Object)("Dispose component controller: " + executionId));
                        ComponentExecutionControllerServiceImpl.this.performDispose(executionId);
                    }
                    catch (ExecutionControllerException | RemoteOperationException e) {
                        LOG.error((Object)StringUtils.format((String)"Failed to dispose component during garbage collecting: %s; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
                    }
                }
            }
        }, 90000L);
    }

    protected void deactivate() {
        if (this.componentControllerGarbargeCollectionFuture != null) {
            this.componentControllerGarbargeCollectionFuture.cancel(true);
        }
    }

    @Override
    @AllowRemoteAccess
    public void addComponentExecutionAuthToken(String authToken) throws RemoteOperationException {
        this.executionAuthTokens.add(authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public String createExecutionController(ComponentExecutionContext compExeCtx, String authToken, Long currentTimestampOnWorkflowNode) throws ComponentExecutionException, RemoteOperationException {
        if (!this.isAllowed(compExeCtx, authToken)) {
            throw new ComponentExecutionException("No valid auth token given.");
        }
        HashMap<String, String> searchProperties = new HashMap<String, String>();
        searchProperties.put("rce.component.execution.id", compExeCtx.getWorkflowExecutionIdentifier());
        WorkflowExecutionControllerCallbackService wfExeCtrlCallbackService = (WorkflowExecutionControllerCallbackService)this.communicationService.getRemotableService(WorkflowExecutionControllerCallbackService.class, (ResolvableNodeId)compExeCtx.getWorkflowNodeId());
        ComponentExecutionControllerImpl componentController = new ComponentExecutionControllerImpl(compExeCtx, wfExeCtrlCallbackService, currentTimestampOnWorkflowNode);
        Hashtable<String, String> registerProperties = new Hashtable<String, String>();
        ((Dictionary)registerProperties).put("rce.component.execution.id", compExeCtx.getExecutionIdentifier());
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ComponentExecutionController.class.getName(), (Object)componentController, registerProperties);
        ComponentExecutionInformationImpl componentExecutionInformation = new ComponentExecutionInformationImpl(compExeCtx);
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            this.componentExecutionInformations.put(compExeCtx.getExecutionIdentifier(), componentExecutionInformation);
            this.componentServiceRegistrations.put(compExeCtx.getExecutionIdentifier(), serviceRegistration);
        }
        return compExeCtx.getExecutionIdentifier();
    }

    private boolean isAllowed(ExecutionContext executionContext, String authToken) {
        Collection<ComponentInstallation> allPublishedInstallations = this.compKnowledgeService.getCurrentComponentKnowledge().getAllPublishedInstallations();
        boolean published = false;
        for (ComponentInstallation compInst : allPublishedInstallations) {
            if (!compInst.getInstallationId().equals(((ComponentExecutionContext)executionContext).getComponentDescription().getComponentInstallation().getInstallationId())) continue;
            published = true;
        }
        boolean authTokenExists = this.executionAuthTokens.remove(authToken);
        return published || authTokenExists;
    }

    @Override
    @AllowRemoteAccess
    public void performPrepare(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).prepare();
    }

    @Override
    @AllowRemoteAccess
    public void performStart(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).start();
    }

    @Override
    @AllowRemoteAccess
    public void performCancel(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).cancel();
    }

    @Override
    @AllowRemoteAccess
    public void performPause(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).pause();
    }

    @Override
    @AllowRemoteAccess
    public void performResume(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).resume();
    }

    @Override
    @AllowRemoteAccess
    public ComponentExecutionInformation getComponentExecutionInformation(String verificationToken) throws RemoteOperationException {
        for (Map.Entry<String, ComponentExecutionController> entry : this.exeCtrlUtilsService.getExecutionControllers(ComponentExecutionController.class, this.bundleContext).entrySet()) {
            if (entry.getValue().getVerificationToken() == null || !entry.getValue().getVerificationToken().equals(verificationToken)) continue;
            return this.componentExecutionInformations.get(entry.getKey());
        }
        return null;
    }

    @Override
    @AllowRemoteAccess
    public Boolean performVerifyResults(String executionId, String verificationToken, Boolean verified) throws ExecutionControllerException, RemoteOperationException {
        return this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).verifyResults(verificationToken, verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void performDispose(String executionId) throws ExecutionControllerException, RemoteOperationException {
        try {
            this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).dispose();
        }
        catch (ServiceException e) {
            LOG.warn((Object)("Ignored component disposal request as there is no component controller registered (anymore); most likely disposal was requested more than once: " + e.toString()));
        }
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            this.componentExecutionInformations.remove(executionId);
            if (this.componentServiceRegistrations.containsKey(executionId)) {
                this.componentServiceRegistrations.get(executionId).unregister();
                this.componentServiceRegistrations.remove(executionId);
            }
        }
    }

    @Override
    @AllowRemoteAccess
    public ComponentState getComponentState(String executionId) throws ExecutionControllerException, RemoteOperationException {
        return this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComponentExecutionInformation> getComponentExecutionInformations() {
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            return new HashSet<ComponentExecutionInformation>(this.componentExecutionInformations.values());
        }
    }

    @Override
    public void onSendingEndointDatumFailed(String executionId, String serializedEndpointDatum, RemoteOperationException e) throws ExecutionControllerException {
        this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext).onSendingEndointDatumFailed(this.endpointDatumSerializer.deserializeEndpointDatum(serializedEndpointDatum), e);
    }

    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeCtrlUtilsService = newService;
    }

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService componentKnowledgeService) {
        this.compKnowledgeService = componentKnowledgeService;
    }

    protected void bindEndpointDatumSerializer(EndpointDatumSerializer newService) {
        this.endpointDatumSerializer = newService;
    }
}

