/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.notification.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationHeader;
import de.rcenvironment.core.notification.NotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.notification.internal.NotificationTopic;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationServiceImpl
implements NotificationService {
    private static final boolean TOPIC_STATISTICS_ENABLED = false;
    private static final boolean FEATURE_FLAG_USE_ASYNCHRONOUS_SENDING = false;
    private static final int MAX_NOTIFICATION_BATCH_SIZE = 50;
    private static final long MAX_NOTIFICATION_LATENCY = 100L;
    private static final Log LOGGER = LogFactory.getLog(NotificationServiceImpl.class);
    private Map<String, NotificationTopic> topics = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> currentNumbers = Collections.synchronizedMap(new HashMap());
    private Map<String, Integer> bufferSizes = Collections.synchronizedMap(new HashMap());
    private Map<String, SortedMap<NotificationHeader, Notification>> allNotifications = Collections.synchronizedMap(new HashMap());
    private WeakHashMap<NotificationSubscriber, LocalSubscriberMetaData> subscriberMap = new WeakHashMap();
    private PlatformService platformService;
    private final AsyncOrderedExecutionQueue deferredPublishingQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);

    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferSize(String notificationId, int bufferSize) {
        if (bufferSize != 0) {
            this.bufferSizes.put(notificationId, new Integer(bufferSize));
            Map<String, SortedMap<NotificationHeader, Notification>> map = this.allNotifications;
            synchronized (map) {
                if (!this.allNotifications.containsKey(notificationId)) {
                    this.allNotifications.put(notificationId, new TreeMap());
                }
            }
        }
    }

    @Override
    public void removePublisher(String notificationId) {
        this.deleteTopicInternal(notificationId);
    }

    @Override
    public <T extends Serializable> void send(String notificationId, T notificationBody) {
        this.sendInternal(notificationId, notificationBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTopicInternal(String notificationId) {
        Map<String, NotificationTopic> map = this.topics;
        synchronized (map) {
            NotificationTopic topic = this.getNotificationTopic(notificationId);
            if (topic != null) {
                this.topics.remove(topic.getName());
                this.currentNumbers.remove(notificationId);
                this.bufferSizes.remove(notificationId);
                this.allNotifications.remove(notificationId);
            }
        }
    }

    private synchronized <T extends Serializable> void sendInternal(String notificationId, T notificationBody) {
        if (this.getNotificationTopic(notificationId) == null) {
            this.registerNotificationTopic(notificationId);
        }
        Long currentEdition = this.currentNumbers.get(notificationId);
        Notification notification = new Notification(notificationId, currentEdition + 1L, this.platformService.getLocalInstanceNodeSessionId(), notificationBody);
        SortedMap<NotificationHeader, Notification> notifications = this.allNotifications.get(notificationId);
        if (notifications != null) {
            Integer bufferSize = this.bufferSizes.get(notificationId);
            if (bufferSize > 0 && notifications.size() >= bufferSize) {
                if (notifications.remove(notifications.firstKey()) != null) {
                    notifications.put(notification.getHeader(), notification);
                }
            } else {
                notifications.put(notification.getHeader(), notification);
            }
        }
        for (NotificationTopic matchingTopic : this.getMatchingNotificationTopics(notificationId)) {
            for (NotificationSubscriber subscriber : matchingTopic.getSubscribers()) {
                this.sendNotificationToSubscriber(notification, subscriber);
            }
        }
        this.currentNumbers.put(notificationId, notification.getHeader().getNumber());
    }

    private void sendNotificationToSubscriber(Notification notification, NotificationSubscriber subscriber) {
        this.getLocalSubscriberMetaData(subscriber).getBatchAggregator().enqueue((Object)notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public Map<String, Long> subscribe(String notificationId, NotificationSubscriber subscriber) {
        NotificationTopic topic;
        HashMap<String, Long> lastNumbers = new HashMap<String, Long>();
        Map<String, Object> map = this.topics;
        synchronized (map) {
            topic = this.getNotificationTopic(notificationId);
            if (topic == null) {
                topic = this.registerNotificationTopic(notificationId);
            }
        }
        topic.add(subscriber);
        this.getLocalSubscriberMetaData(subscriber).addSubscribedTopic(topic);
        map = this.currentNumbers;
        synchronized (map) {
            for (String tmpId : this.currentNumbers.keySet()) {
                if (!tmpId.matches(notificationId)) continue;
                lastNumbers.put(tmpId, this.currentNumbers.get(tmpId));
            }
        }
        return lastNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void unsubscribe(String notificationId, NotificationSubscriber subscriber) {
        Map<String, NotificationTopic> map = this.topics;
        synchronized (map) {
            NotificationTopic topic = this.getNotificationTopic(notificationId);
            if (topic != null) {
                topic.remove(subscriber);
                this.getLocalSubscriberMetaData(subscriber).removeSubscribedTopic(topic);
            }
        }
    }

    @Override
    public Notification getNotification(NotificationHeader header) {
        Notification notification = null;
        Map notifications = this.allNotifications.get(header.getNotificationIdentifier());
        if (notifications != null) {
            notification = (Notification)notifications.get(header);
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, SortedSet<NotificationHeader>> getNotificationHeaders(String notificationId) {
        HashMap<String, SortedSet<NotificationHeader>> allHeaders = new HashMap<String, SortedSet<NotificationHeader>>();
        Map<String, SortedMap<NotificationHeader, Notification>> map = this.allNotifications;
        synchronized (map) {
            for (String tmpId : this.allNotifications.keySet()) {
                if (!tmpId.matches(notificationId)) continue;
                Map notifications = this.allNotifications.get(tmpId);
                TreeSet headers = new TreeSet(notifications.keySet());
                allHeaders.put(tmpId, headers);
            }
        }
        return allHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public Map<String, List<Notification>> getNotifications(String notificationId) {
        HashMap<String, List<Notification>> allNotificationsToGet = new HashMap<String, List<Notification>>();
        Map<String, SortedMap<NotificationHeader, Notification>> map = this.allNotifications;
        synchronized (map) {
            for (String tmpId : this.allNotifications.keySet()) {
                if (!tmpId.matches(notificationId)) continue;
                Map notifications = this.allNotifications.get(tmpId);
                ArrayList notificationsToGet = new ArrayList(notifications.values());
                allNotificationsToGet.put(tmpId, notificationsToGet);
            }
        }
        return allNotificationsToGet;
    }

    /*
     * Unable to fully structure code
     */
    private void sendNotificationsToSubscriber(NotificationSubscriber subscriber, List<Notification> notifications) {
        block6: {
            try {
                try {
                    subscriber.receiveBatchedNotifications(notifications);
                    break block6;
                }
                catch (RuntimeException e) {
                    NotificationServiceImpl.LOGGER.error((Object)"Unexpected RTE thrown from receiveBatchedNotifications()", (Throwable)e);
                    throw new RemoteOperationException(e.toString());
                }
            }
            catch (RemoteOperationException e) {
                subscriberIdentity = System.identityHashCode(subscriber);
                subscribedTopics = this.getLocalSubscriberMetaData(subscriber).getSubscribedTopics();
                if (subscribedTopics.isEmpty()) {
                    NotificationServiceImpl.LOGGER.debug((Object)("Tried to remove subscriber " + subscriberIdentity + " after a callback failure but it had no (or no more) topics to unsubscribe from; triggering error: " + e.toString()));
                    break block6;
                }
                ** for (topic : subscribedTopics)
            }
lbl-1000:
            // 1 sources

            {
                this.unsubscribe(topic.getName(), subscriber);
                NotificationServiceImpl.LOGGER.debug((Object)("Removed subscriber " + subscriberIdentity + " from topic " + topic.getName() + " after a callback failure: " + e.toString()));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationTopic registerNotificationTopic(String notificationId) {
        NotificationTopic topic = new NotificationTopic(notificationId);
        Map<String, NotificationTopic> map = this.topics;
        synchronized (map) {
            this.topics.put(topic.getName(), topic);
        }
        this.currentNumbers.put(notificationId, new Long(-1L));
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationTopic getNotificationTopic(String notificationId) {
        Map<String, NotificationTopic> map = this.topics;
        synchronized (map) {
            return this.topics.get(notificationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalSubscriberMetaData getLocalSubscriberMetaData(NotificationSubscriber subscriber) {
        WeakHashMap<NotificationSubscriber, LocalSubscriberMetaData> weakHashMap = this.subscriberMap;
        synchronized (weakHashMap) {
            LocalSubscriberMetaData metaData = this.subscriberMap.get(subscriber);
            if (metaData == null) {
                NotificationBatchSender batchProcessor = new NotificationBatchSender(subscriber);
                BatchAggregator batchAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(50, 100L, (BatchProcessor)batchProcessor);
                metaData = new LocalSubscriberMetaData((BatchAggregator<Notification>)batchAggregator);
                this.subscriberMap.put(subscriber, metaData);
            }
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NotificationTopic> getMatchingNotificationTopics(String currentNotificationId) {
        HashSet<NotificationTopic> matchingTopics = new HashSet<NotificationTopic>();
        Map<String, NotificationTopic> map = this.topics;
        synchronized (map) {
            for (NotificationTopic topic : this.topics.values()) {
                if (!topic.getNotificationIdFilter().matcher(currentNotificationId).matches()) continue;
                matchingTopics.add(topic);
            }
            return matchingTopics;
        }
    }

    protected void awaitAsyncTaskCompletion() {
    }

    private static final class LocalSubscriberMetaData {
        private final Set<NotificationTopic> subscribedTopics;
        private final BatchAggregator<Notification> batchAggregator;

        LocalSubscriberMetaData(BatchAggregator<Notification> batchAggregator) {
            this.batchAggregator = batchAggregator;
            this.subscribedTopics = new HashSet<NotificationTopic>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscribedTopic(NotificationTopic topic) {
            Set<NotificationTopic> set = this.subscribedTopics;
            synchronized (set) {
                this.subscribedTopics.add(topic);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSubscribedTopic(NotificationTopic topic) {
            Set<NotificationTopic> set = this.subscribedTopics;
            synchronized (set) {
                return this.subscribedTopics.remove(topic);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<NotificationTopic> getSubscribedTopics() {
            Set<NotificationTopic> set = this.subscribedTopics;
            synchronized (set) {
                return new ArrayList<NotificationTopic>(this.subscribedTopics);
            }
        }

        public BatchAggregator<Notification> getBatchAggregator() {
            return this.batchAggregator;
        }
    }

    private final class NotificationBatchSender
    implements BatchProcessor<Notification> {
        private NotificationSubscriber subscriber;

        NotificationBatchSender(NotificationSubscriber subscriber) {
            this.subscriber = subscriber;
        }

        public void processBatch(List<Notification> batch) {
            NotificationServiceImpl.this.sendNotificationsToSubscriber(this.subscriber, batch);
        }
    }
}

