/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.notification.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.notification.api.RemotableNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class DistributedNotificationServiceImpl
implements DistributedNotificationService {
    private static final Log LOGGER = LogFactory.getLog(DistributedNotificationServiceImpl.class);
    private static NotificationService notificationService;
    private static CommunicationService nullCommunicationService;
    private static CommunicationService communicationService;
    private static PlatformService platformService;

    static {
        communicationService = nullCommunicationService = (CommunicationService)ServiceUtils.createFailingServiceProxy(CommunicationService.class);
        platformService = (PlatformService)ServiceUtils.createFailingServiceProxy(PlatformService.class);
    }

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindNotificationService(NotificationService newNotificationService) {
        notificationService = newNotificationService;
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        communicationService = newCommunicationService;
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        platformService = newPlatformService;
    }

    @Override
    public void setBufferSize(String notificationId, int bufferSize) {
        notificationService.setBufferSize(notificationId, bufferSize);
    }

    @Override
    public void removePublisher(String notificationId) {
        notificationService.removePublisher(notificationId);
    }

    @Override
    public <T extends Serializable> void send(String notificationId, T notificationBody) {
        notificationService.send(notificationId, notificationBody);
    }

    @Override
    public Map<String, Long> subscribe(String notificationId, NotificationSubscriber subscriber, ResolvableNodeId publishPlatform) throws RemoteOperationException {
        try {
            Pattern.compile(notificationId);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Notification Id is not a valid RegExp: " + notificationId), (Throwable)e);
            throw e;
        }
        if (publishPlatform == null) {
            publishPlatform = platformService.getLocalInstanceNodeSessionId();
        }
        try {
            RemotableNotificationService remoteService = (RemotableNotificationService)communicationService.getRemotableService(RemotableNotificationService.class, publishPlatform);
            return remoteService.subscribe(notificationId, subscriber);
        }
        catch (RemoteOperationException e) {
            String message = StringUtils.format((String)"Failed to subscribe to publisher @%s: ", (Object[])new Object[]{publishPlatform});
            throw new RemoteOperationException(String.valueOf(message) + e.toString());
        }
    }

    @Override
    public Map<InstanceNodeSessionId, Map<String, Long>> subscribeToAllReachableNodes(final String notificationId, final NotificationSubscriber subscriber) {
        final Map<InstanceNodeSessionId, Map<String, Long>> missedNumbersMap = Collections.synchronizedMap(new HashMap());
        Set nodesToSubscribeTo = communicationService.getReachableInstanceNodes();
        CallablesGroup callables = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
        for (final InstanceNodeSessionId nodeId : nodesToSubscribeTo) {
            callables.add((Callable)new Callable<Void>(){

                @Override
                @TaskDescription(value="Distributed notification subscription")
                public Void call() throws Exception {
                    Map<String, Long> missedNumbers = DistributedNotificationServiceImpl.this.subscribe(notificationId, subscriber, (ResolvableNodeId)nodeId);
                    missedNumbersMap.put(nodeId, missedNumbers);
                    return null;
                }
            });
        }
        callables.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                LOGGER.error((Object)("Asynchronous exception while subscribing for notification " + notificationId));
            }
        });
        return missedNumbersMap;
    }

    @Override
    public void unsubscribe(String notificationId, NotificationSubscriber subscriber, ResolvableNodeId publishPlatform) throws RemoteOperationException {
        try {
            this.getRemoteNotificationService(publishPlatform).unsubscribe(notificationId, subscriber);
        }
        catch (RemoteOperationException | RuntimeException e) {
            throw new RemoteOperationException(String.valueOf(StringUtils.format((String)"Failed to unsubscribe from publisher %s: ", (Object[])new Object[]{publishPlatform})) + e.getMessage());
        }
    }

    @Override
    public Map<String, List<Notification>> getNotifications(String notificationId, ResolvableNodeId publishPlatform) throws RemoteOperationException {
        return this.getRemoteNotificationService(publishPlatform).getNotifications(notificationId);
    }

    private RemotableNotificationService getRemoteNotificationService(ResolvableNodeId publishPlatform) throws RemoteOperationException {
        return (RemotableNotificationService)communicationService.getRemotableService(RemotableNotificationService.class, publishPlatform);
    }
}

