/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.InternalImage;

public final class Image
extends Resource {
    public final InternalImage internalImage;

    private Image(Device device, InternalImage internalImage) {
        super(device);
        this.internalImage = internalImage;
    }

    public Image(Device device, InputStream stream) {
        super(Image.checkDevice(device));
        if (stream == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(stream);
    }

    public Image(Device device, String fileName) {
        super(Image.checkDevice(device));
        if (fileName == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(fileName);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(Image.checkDevice(device));
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: {
                this.internalImage = srcImage.internalImage;
                break;
            }
            default: {
                this.internalImage = null;
                SWT.error(5);
            }
        }
    }

    public Image(Device device, ImageData imageData) {
        super(Image.checkDevice(device));
        if (imageData == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Image(Device device, int width, int height) {
        super(Image.checkDevice(device));
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        Color white = device.getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{white.getRGB()});
        ImageData imageData = new ImageData(width, height, 8, palette);
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.internalImage.getBounds();
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.internalImage.getImageData();
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return null;
    }

    private static InternalImage findInternalImage(ImageData imageData) {
        return RWTFactory.getInternalImageFactory().findInternalImage(imageData);
    }

    private static InternalImage findInternalImage(InputStream stream) {
        return RWTFactory.getInternalImageFactory().findInternalImage(stream);
    }

    private static InternalImage findInternalImage(String fileName) {
        return RWTFactory.getInternalImageFactory().findInternalImage(fileName);
    }
}

