/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;

abstract class AbstractCreateResourcesOperation
extends AbstractResourcesOperation {
    AbstractCreateResourcesOperation(ResourceDescription[] resourceDescriptions, String label) {
        super(resourceDescriptions, label);
    }

    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.recreate(monitor, uiInfo);
    }

    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.delete(monitor, uiInfo, false);
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean modified = false;
        if (operation == UNDO) {
            int i = 0;
            while (i < this.resources.length) {
                IResource resource = this.resources[i];
                factory.delete(resource);
                modified = true;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[i] != null) {
                    IResource resource = this.resourceDescriptions[i].createResourceHandle();
                    factory.create(resource);
                    modified = true;
                }
                ++i;
            }
        }
        return modified;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        return super.computeCreateSchedulingRule();
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return super.computeDeleteSchedulingRule();
    }

    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeRedoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }
}

