/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AbstractOTReferenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.IRoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.RoleSplitter;

public class RoleTypeBinding
extends DependentTypeBinding
implements IRoleTypeBinding,
IOTConstants,
ProblemReasons {
    public static final VariableBinding NoAnchor = new LocalVariableBinding("<no valid anchor>".toCharArray(), (TypeBinding)TypeBinding.NULL, 16, false);
    public ReferenceBinding _declaredRoleType;
    private ReferenceBinding _staticallyKnownRoleType;
    private ReferenceBinding _staticallyKnownRoleClass;
    public ReferenceBinding _staticallyKnownTeam;
    private ReferenceBinding _superClass;
    HashMap<ReferenceBinding, DependentTypeBinding> weakenedTypes;

    public RoleTypeBinding(ReferenceBinding genericType, TypeBinding[] typeArguments, ITeamAnchor teamAnchor, ReferenceBinding enclosingType, LookupEnvironment lookupEnvironment) {
        super(genericType.getRealType(), typeArguments, enclosingType, lookupEnvironment);
        this.initialize(genericType, teamAnchor);
    }

    private void initialize(ReferenceBinding roleType, ITeamAnchor teamAnchor) {
        if (teamAnchor instanceof ParameterizedFieldBinding) {
            teamAnchor = ((ParameterizedFieldBinding)teamAnchor).original();
        }
        this.initializeDependentType(teamAnchor, -1);
        this.tagBits |= 0x200000000000000L;
        ITeamAnchor firstAnchorSegment = teamAnchor.getBestNamePath()[0];
        if (firstAnchorSegment instanceof LocalVariableBinding && (((LocalVariableBinding)firstAnchorSegment).tagBits & 0x400L) != 0L) {
            LocalVariableBinding argumentBinding = (LocalVariableBinding)firstAnchorSegment;
            this._argumentPosition = argumentBinding.resolvedPosition;
            final MethodScope methodScope = argumentBinding.declaringScope.methodScope();
            if (methodScope != null) {
                this._declaringMethod = new DependentTypeBinding.IMethodProvider(){
                    private MethodBinding binding;

                    public MethodBinding getMethod() {
                        if (this.binding == null) {
                            this.binding = methodScope.referenceMethodBinding();
                        }
                        return this.binding;
                    }
                };
            }
        }
        if (CharOperation.equals(roleType.compoundName, IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED)) {
            this._staticallyKnownTeam = roleType.enclosingType();
        } else if (teamAnchor == NoAnchor) {
            this._staticallyKnownTeam = roleType.enclosingType();
        } else {
            teamAnchor.setStaticallyKnownTeam(this);
        }
        assert (this._staticallyKnownTeam.isTeam());
        if (RoleSplitter.isClassPartName(roleType.sourceName)) {
            this._staticallyKnownRoleClass = roleType.getRealClass();
            char[] typeName = RoleSplitter.getInterfacePartName(roleType.sourceName);
            this._staticallyKnownRoleType = this._staticallyKnownTeam.getMemberType(typeName);
        } else {
            this._staticallyKnownRoleType = roleType.getRealType();
            char[] className = CharOperation.concat(OT_DELIM_NAME, this._staticallyKnownRoleType.sourceName);
            this._staticallyKnownRoleClass = this._staticallyKnownTeam.getMemberType(className);
            this._staticallyKnownRoleClass = this.transferTypeArguments(this._staticallyKnownRoleClass);
        }
        this._declaredRoleType = this._staticallyKnownRoleType = this.transferTypeArguments(this._staticallyKnownRoleType);
        this.roleModel = this._declaredRoleType.roleModel;
        this._teamModel = this._declaredRoleType.getTeamModel();
        assert (this._staticallyKnownTeam.getRealClass() == roleType.enclosingType()) : "weakening not using WeakenedTypeBinding";
        if (this._staticallyKnownTeam != roleType.enclosingType()) {
            this._staticallyKnownRoleType = this._staticallyKnownTeam.getMemberType(roleType.sourceName);
        }
        if (this._staticallyKnownRoleClass != null) {
            this.modifiers = this._staticallyKnownRoleClass.modifiers;
        }
        if (this.arguments != null) {
            this.modifiers |= 0x40000000;
        } else if (this.enclosingType() != null) {
            this.modifiers |= this.enclosingType().modifiers & 0x40000000;
            this.tagBits |= this.enclosingType().tagBits & 0x20000080L;
        }
        this.registerAnchor();
    }

    TypeBinding forAnchor(ITeamAnchor anchor, int dimensions) {
        return anchor.getRoleTypeBinding(this._staticallyKnownRoleType, dimensions);
    }

    public ReferenceBinding weakenFrom(ReferenceBinding other) {
        if (other instanceof RoleTypeBinding) {
            ReferenceBinding knownWeakened;
            if (this.weakenedTypes == null) {
                this.weakenedTypes = new HashMap();
            }
            if ((knownWeakened = (ReferenceBinding)this.weakenedTypes.get(other)) != null) {
                return knownWeakened;
            }
            RoleTypeBinding otherRTB = (RoleTypeBinding)other;
            WeakenedTypeBinding newWeakened = new WeakenedTypeBinding(this, otherRTB._declaredRoleType, this.environment);
            this.weakenedTypes.put(other, newWeakened);
            return newWeakened;
        }
        return other;
    }

    public static RoleTypeBinding getRoleTypeBinding(TypeBinding binding) {
        if (binding instanceof WeakenedTypeBinding) {
            return RoleTypeBinding.getRoleTypeBinding(((WeakenedTypeBinding)binding).type);
        }
        return (RoleTypeBinding)binding;
    }

    public static boolean type_eq(ReferenceBinding left, ReferenceBinding right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.erasure() == right.erasure()) {
            return true;
        }
        if (left instanceof RoleTypeBinding) {
            RoleTypeBinding leftRole = (RoleTypeBinding)left;
            if (right instanceof RoleTypeBinding) {
                return left.getRealType() == ((RoleTypeBinding)right).getRealType();
            }
            if (leftRole.getRealType() == right) {
                return true;
            }
            if (leftRole.getRealClass() == right) {
                return true;
            }
        } else if (right instanceof RoleTypeBinding) {
            RoleTypeBinding rightRole = (RoleTypeBinding)right;
            if (rightRole.getRealType() == left) {
                return true;
            }
            if (rightRole.getRealClass() == left) {
                return true;
            }
        }
        return false;
    }

    public static boolean eq(TypeBinding left, TypeBinding right) {
        if (left == right) {
            return true;
        }
        DependentTypeBinding leftDep = null;
        DependentTypeBinding rightDep = null;
        while (DependentTypeBinding.isDependentType(left)) {
            leftDep = (DependentTypeBinding)left;
            left = leftDep.type;
        }
        while (DependentTypeBinding.isDependentType(right)) {
            rightDep = (DependentTypeBinding)right;
            right = rightDep.type;
        }
        return leftDep != null && rightDep != null && leftDep._teamAnchor.hasSameBestNameAs(rightDep._teamAnchor) && CharOperation.equals(left.internalName(), right.internalName());
    }

    public static boolean isRoleType(TypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return (binding.tagBits & 0x200000000000000L) != 0L;
    }

    public static boolean isRoleTypeOrArrayOfRole(TypeBinding binding) {
        if ((binding.tagBits & 2L) != 0L) {
            return false;
        }
        return (binding.leafComponentType().tagBits & 0x200000000000000L) != 0L;
    }

    public static boolean isRoleWithExplicitAnchor(TypeBinding type) {
        if (type == null) {
            return false;
        }
        if ((type.tagBits & 0x200000000000000L) == 0L) {
            return false;
        }
        return ((DependentTypeBinding)type).hasExplicitAnchor();
    }

    public static boolean isRoleWithoutExplicitAnchor(TypeBinding type) {
        if (type == null) {
            return false;
        }
        if ((type.tagBits & 0x200000000000000L) == 0L) {
            return false;
        }
        return !((DependentTypeBinding)type).hasExplicitAnchor();
    }

    public static boolean hasNonExternalizedRoleParameter(MethodBinding method) {
        ReferenceBinding declaringClass = method.declaringClass;
        TypeBinding[] parameters = method.parameters;
        int j = 0;
        while (j < parameters.length) {
            if (RoleTypeBinding.isRoleWithoutExplicitAnchor(parameters[j]) && ((ReferenceBinding)parameters[j]).enclosingType() == declaringClass) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public ITeamAnchor[] getAnchorBestName() {
        return this._teamAnchor.getBestNamePath();
    }

    public ReferenceBinding getRealClass() {
        if (this._staticallyKnownRoleClass != null) {
            return this._staticallyKnownRoleClass;
        }
        return this._staticallyKnownRoleType.getRealClass();
    }

    public ReferenceBinding getRealType() {
        return this._staticallyKnownRoleType;
    }

    public TypeBinding erasure() {
        return this.type.erasure();
    }

    public ReferenceBinding genericType() {
        if (this.arguments == null) {
            return this;
        }
        return super.genericType();
    }

    public boolean isSiblingRole(SourceTypeBinding other) {
        return this.enclosingType() == other.enclosingType();
    }

    public boolean isSameType(RoleTypeBinding role, ITeamAnchor anchor) {
        return role._staticallyKnownRoleType == this._staticallyKnownRoleType && role._staticallyKnownTeam == this._staticallyKnownTeam && this._teamAnchor.hasSameBestNameAs(anchor);
    }

    public FieldBinding[] availableFields() {
        if (this._staticallyKnownRoleClass == null) {
            return Binding.NO_FIELDS;
        }
        return this._staticallyKnownRoleClass.availableFields();
    }

    public int fieldCount() {
        if (this._staticallyKnownRoleClass == null) {
            return 0;
        }
        return this._staticallyKnownRoleClass.fieldCount();
    }

    public FieldBinding[] fields() {
        if (this._staticallyKnownRoleClass == null) {
            return Binding.NO_FIELDS;
        }
        return this._staticallyKnownRoleClass.fields();
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        FieldBinding result = null;
        if (this._staticallyKnownRoleClass != null && (result = this._staticallyKnownRoleClass.getField(fieldName, needResolve)) != null) {
            return result;
        }
        return this._staticallyKnownRoleType.getField(fieldName, needResolve);
    }

    public MethodBinding[] getMethods(char[] selector) {
        if (this.methods == null && !this.isParameterizedType()) {
            return this.type.getMethods(selector);
        }
        return super.getMethods(selector);
    }

    public MethodBinding[] availableMethods() {
        return this._staticallyKnownRoleType.availableMethods();
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        if (this._staticallyKnownRoleClass == null) {
            this._staticallyKnownRoleClass = this.roleModel.getClassPartBinding();
            if (this._staticallyKnownRoleClass == null) {
                throw new InternalCompilerError("Searching for constructor in pure interface role " + new String(this._staticallyKnownRoleType.sourceName()));
            }
        }
        return this._staticallyKnownRoleClass.getExactConstructor(argumentTypes);
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        return this._staticallyKnownRoleType.getExactMethod(selector, argumentTypes, refScope);
    }

    public void addMethod(MethodBinding method) {
        if (this._staticallyKnownRoleClass != null) {
            this._staticallyKnownRoleClass.addMethod(method);
        }
        MethodBinding ifcPart = new MethodBinding(method, this._staticallyKnownRoleType);
        ifcPart.modifiers |= 0x400;
        this._staticallyKnownRoleType.addMethod(ifcPart);
    }

    public boolean canBeInstantiated() {
        return this._staticallyKnownRoleType.canBeInstantiated();
    }

    public TeamModel getTeamModel() {
        if (this._teamModel != null) {
            return this._teamModel;
        }
        if (this._staticallyKnownRoleClass != null) {
            this._teamModel = this._staticallyKnownRoleClass.getTeamModel();
        }
        if (this._teamModel != null) {
            return this._teamModel;
        }
        this._teamModel = this._staticallyKnownRoleType.getTeamModel();
        return this._teamModel;
    }

    public final boolean isClass() {
        return this._staticallyKnownRoleClass != null;
    }

    public boolean isRole() {
        return true;
    }

    public boolean isSourceRole() {
        return true;
    }

    public boolean isDirectRole() {
        return true;
    }

    public void computeId() {
        this._staticallyKnownRoleType.computeId();
    }

    public char[] getFileName() {
        return this._staticallyKnownRoleType.getFileName();
    }

    public ReferenceBinding[] memberTypes() {
        return this._staticallyKnownRoleType.memberTypes();
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding result = this._staticallyKnownRoleType.getMemberType(typeName);
        if (result != null) {
            return result;
        }
        if (this._staticallyKnownRoleClass == null) {
            return null;
        }
        return this._staticallyKnownRoleClass.getMemberType(typeName);
    }

    public SyntheticArgumentBinding[] valueParamSynthArgs() {
        if (this._staticallyKnownRoleClass != null) {
            return this._staticallyKnownRoleClass.valueParamSynthArgs();
        }
        return NO_SYNTH_ARGUMENTS;
    }

    public PackageBinding getPackage() {
        return this._staticallyKnownRoleType.getPackage();
    }

    public ReferenceBinding superclass() {
        ReferenceBinding superClass;
        if (this._superClass != null) {
            return this._superClass;
        }
        if (this._staticallyKnownRoleClass != null && (superClass = this._staticallyKnownRoleClass.superclass()) != null && superClass.isDirectRole()) {
            if (OTNameUtils.isPredefinedConfined(superClass.compoundName) || CharOperation.equals(IOTConstants.OTCONFINED, superClass.sourceName)) {
                this._superClass = superClass;
                return this._superClass;
            }
            superClass = (ReferenceBinding)this._teamAnchor.getRoleTypeBinding(superClass.roleModel.getInterfacePartBinding(), 0);
            if (superClass instanceof WeakenedTypeBinding) {
                if (superClass.depth() >= this.depth()) {
                    return null;
                }
                superClass = ((WeakenedTypeBinding)superClass).type;
            }
            this._superClass = superClass;
            return this._superClass;
        }
        if (this._staticallyKnownRoleType != null) {
            this._superClass = this._staticallyKnownRoleType.superclass();
            return this._superClass;
        }
        return null;
    }

    public boolean isHierarchyConnected() {
        return this.type.isHierarchyConnected();
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        return this._staticallyKnownRoleType.syntheticEnclosingInstanceTypes();
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this._staticallyKnownRoleType.syntheticOuterLocalVariables();
    }

    public boolean implementsInterface(ReferenceBinding anInterface, boolean searchHierarchy) {
        if (anInterface instanceof RoleTypeBinding) {
            anInterface = ((RoleTypeBinding)anInterface)._staticallyKnownRoleType;
        }
        return this._staticallyKnownRoleType.implementsInterface(anInterface, searchHierarchy);
    }

    public boolean implementsMethod(MethodBinding method) {
        return ((AbstractOTReferenceBinding)this._staticallyKnownRoleType).implementsMethod(method);
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        if (otherType instanceof RoleTypeBinding) {
            otherType = ((RoleTypeBinding)otherType)._staticallyKnownRoleType;
        }
        return this._staticallyKnownRoleType.isSuperclassOf(otherType);
    }

    public TypeBinding findSuperTypeOriginatingFrom(TypeBinding otherType) {
        if (otherType instanceof ReferenceBinding) {
            ReferenceBinding classBinding;
            ReferenceBinding otherRef = (ReferenceBinding)otherType;
            ReferenceBinding ifcBinding = this.transferTypeArguments(this._staticallyKnownRoleType);
            TypeBinding superRef = ifcBinding.findSuperTypeOriginatingFrom(otherRef.getRealType());
            if (superRef == null && this._staticallyKnownRoleClass != null && (superRef = (classBinding = this.transferTypeArguments(this._staticallyKnownRoleClass)).findSuperTypeOriginatingFrom(otherRef.getRealClass())) != null && Config.getCastRequired() == null) {
                Config.setCastRequired((ReferenceBinding)otherType);
            }
            if (superRef != null) {
                if (superRef.isRole()) {
                    return this._teamAnchor.getRoleTypeBinding((ReferenceBinding)superRef, 0);
                }
                return superRef;
            }
        }
        return null;
    }

    public ReferenceBinding findSuperTypeOriginatingFrom(int wellKnownOriginalID, boolean originalIsClass) {
        ReferenceBinding ifcBinding = this.transferTypeArguments(this._staticallyKnownRoleType);
        ReferenceBinding superRef = ifcBinding.findSuperTypeOriginatingFrom(wellKnownOriginalID, originalIsClass);
        if (superRef == null && this._staticallyKnownRoleClass != null) {
            ReferenceBinding classBinding = this.transferTypeArguments(this._staticallyKnownRoleClass);
            superRef = classBinding.findSuperTypeOriginatingFrom(wellKnownOriginalID, originalIsClass);
        }
        if (superRef != null) {
            if (superRef.isRole()) {
                return (ReferenceBinding)this._teamAnchor.getRoleTypeBinding(superRef, 0);
            }
            return superRef;
        }
        return null;
    }

    public boolean isProvablyDistinct(TypeBinding otherType) {
        if (this._staticallyKnownRoleType != null && !this._staticallyKnownRoleType.isProvablyDistinct(otherType)) {
            return false;
        }
        return this._staticallyKnownRoleClass == null || this._staticallyKnownRoleClass.isProvablyDistinct(otherType);
    }

    public void setIsBoundBase(ReferenceBinding roleType) {
        if (this._staticallyKnownRoleClass != null) {
            this._staticallyKnownRoleClass.setIsBoundBase(roleType);
        }
        if (this._staticallyKnownRoleType != null) {
            this._staticallyKnownRoleType.setIsBoundBase(roleType);
        }
    }

    public boolean isCompatibleWith(TypeBinding right) {
        if (right == this) {
            return true;
        }
        if (!(right instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)right;
        if (RoleTypeBinding.isRoleType(referenceBinding)) {
            RoleTypeBinding rightRole = RoleTypeBinding.getRoleTypeBinding(referenceBinding);
            ReferenceBinding rightTeam = referenceBinding.enclosingType();
            if (!this._teamAnchor.hasSameBestNameAs(rightRole._teamAnchor)) {
                return this.isCompatibleViaLowering(rightRole);
            }
            if (rightRole._staticallyKnownTeam != this._staticallyKnownTeam) {
                if (TeamModel.areTypesCompatible(rightTeam, this._staticallyKnownTeam)) {
                    ReferenceBinding leftStrengthened = this._teamAnchor.getMemberTypeOfType(this.internalName());
                    if (leftStrengthened != this) {
                        return leftStrengthened.isCompatibleWith(right);
                    }
                } else if (TeamModel.areTypesCompatible(this._staticallyKnownTeam, rightTeam)) {
                    rightRole = (RoleTypeBinding)this._teamAnchor.getMemberTypeOfType(rightRole.internalName());
                } else {
                    return false;
                }
            }
            if (this._staticallyKnownRoleType.isCompatibleWith(rightRole._staticallyKnownRoleType)) {
                return true;
            }
        }
        if (referenceBinding.isInterface() && this.implementsInterface(referenceBinding, true)) {
            return true;
        }
        if (this._staticallyKnownRoleClass == null && this._staticallyKnownRoleType.isCompatibleWith(referenceBinding, false)) {
            this.checkAmbiguousObjectLower(referenceBinding);
            return true;
        }
        if (this._staticallyKnownRoleClass != null && this._staticallyKnownRoleClass.isStrictlyCompatibleWith(referenceBinding) && !TeamModel.isTeamContainingRole(this._staticallyKnownTeam, referenceBinding)) {
            Config.setCastRequired(referenceBinding);
            this.checkAmbiguousObjectLower(referenceBinding);
            return true;
        }
        return this.isCompatibleViaLowering(referenceBinding);
    }

    private void checkAmbiguousObjectLower(ReferenceBinding otherType) {
        if (otherType.id == 1 && this.baseclass() != null) {
            Config.setLoweringPossible(true);
        }
    }

    public boolean isCompatibleViaLowering(ReferenceBinding otherType) {
        ReferenceBinding otherRole;
        if (otherType instanceof TypeVariableBinding && this.isCompatibleWith(otherRole = ((TypeVariableBinding)otherType).roletype)) {
            Config.setLoweringRequired(true);
            return true;
        }
        ReferenceBinding baseType = null;
        Dependencies.ensureRoleState(this.roleModel, 7);
        RoleModel strengthened = this._teamAnchor.getStrengthenedRole(this);
        if ((strengthened.getInterfacePartBinding().modifiers & 0x1200) == 512) {
            baseType = strengthened.getInterfacePartBinding().baseclass();
        } else if (strengthened.getClassPartBinding() != null) {
            baseType = strengthened.getClassPartBinding().baseclass();
        }
        if (baseType != null && baseType.isCompatibleWith(otherType)) {
            Config.setLoweringRequired(true);
            return true;
        }
        return false;
    }

    public boolean isStrictlyCompatibleWith(TypeBinding right) {
        return this.isCompatibleWith(right);
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (!(otherType instanceof RoleTypeBinding)) {
            return this._staticallyKnownRoleType.isEquivalentTo(otherType);
        }
        RoleTypeBinding otherDep = RoleTypeBinding.getRoleTypeBinding(otherType);
        return otherDep._teamAnchor.hasSameBestNameAs(this._teamAnchor) && CharOperation.equals(otherDep.internalName(), this.internalName());
    }

    public char[] qualifiedSourceName() {
        return this._staticallyKnownRoleType.qualifiedSourceName();
    }

    public char[] optimalName() {
        if (this._teamAnchor instanceof TThisBinding) {
            return super.readableName();
        }
        char[] anchorName = new char[]{};
        ITeamAnchor[] bestNamePath = this._teamAnchor.getBestNamePath();
        int i = 0;
        while (i < bestNamePath.length) {
            char[] readableName = bestNamePath[i].readableName();
            if (CharOperation.equals(readableName, IOTConstants._OT_BASE)) {
                readableName = "base".toCharArray();
            }
            anchorName = CharOperation.concatWith(new char[][]{anchorName, readableName}, '.');
            ++i;
        }
        return CharOperation.concat(anchorName, this.strippedName(this._staticallyKnownRoleType), '.');
    }

    private char[] strippedName(ReferenceBinding role) {
        if (OTNameUtils.isTSuperMarkerInterface(role.sourceName)) {
            return "<tsuper-mark>".toCharArray();
        }
        if (RoleSplitter.isClassPartName(role.sourceName)) {
            return RoleSplitter.getInterfacePartName(role.sourceName);
        }
        return role.sourceName;
    }

    public char[] sourceName() {
        return this._staticallyKnownRoleType.sourceName();
    }

    public char[] constantPoolName() {
        return this._declaredRoleType.constantPoolName();
    }

    public char[] attributeName() {
        if (this._staticallyKnownRoleClass != null) {
            return this._staticallyKnownRoleClass.attributeName();
        }
        return super.attributeName();
    }

    public String toString() {
        String anchorStr = "";
        ITeamAnchor[] bestNamePath = this._teamAnchor.getBestNamePath(false);
        int i = 0;
        while (i < bestNamePath.length) {
            if (i > 0) {
                anchorStr = String.valueOf(anchorStr) + '.';
            }
            anchorStr = String.valueOf(anchorStr) + new String(bestNamePath[i].readableName());
            ++i;
        }
        String staticTeam = "";
        if (!(this._teamAnchor instanceof TThisBinding)) {
            staticTeam = String.valueOf('[') + new String(this._staticallyKnownTeam.sourceName()) + ']';
        }
        return String.valueOf(anchorStr) + staticTeam + '.' + new String(this.sourceName());
    }
}

