/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.nodeproperties.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.internal.CompositeNodePropertyKey;
import de.rcenvironment.core.utils.common.StringUtils;

public class NodePropertyImpl
implements NodeProperty {
    private final CompositeNodePropertyKey key;
    private final long sequenceNo;
    private final String value;
    private final InstanceNodeSessionId instanceSessionId;

    public NodePropertyImpl(String compactForm, NodeIdentifierService nodeIdentifierService) throws IdentifierException {
        String[] parts = StringUtils.splitAndUnescape((String)compactForm);
        if (parts.length != 4) {
            throw new IllegalArgumentException("Wrong number of segments: " + compactForm);
        }
        this.key = new CompositeNodePropertyKey(parts[0], parts[1]);
        this.sequenceNo = Long.parseLong(parts[2]);
        this.value = parts[3];
        this.instanceSessionId = nodeIdentifierService.parseInstanceNodeSessionIdString(this.key.getInstanceNodeSessionIdString());
    }

    public NodePropertyImpl(InstanceNodeSessionId instanceSessionId, String dataKey, long sequenceNo, String value) {
        this.key = new CompositeNodePropertyKey(instanceSessionId.getInstanceNodeSessionIdString(), dataKey);
        this.sequenceNo = sequenceNo;
        this.value = value;
        this.instanceSessionId = instanceSessionId;
    }

    public CompositeNodePropertyKey getCompositeKey() {
        return this.key;
    }

    @Override
    public InstanceNodeSessionId getInstanceNodeSessionId() {
        return this.instanceSessionId;
    }

    @Override
    public String getInstanceNodeSessionIdString() {
        return this.key.getInstanceNodeSessionIdString();
    }

    @Override
    public String getKey() {
        return this.key.getDataKey();
    }

    @Override
    public long getSequenceNo() {
        return this.sequenceNo;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toCompactForm() {
        return StringUtils.escapeAndConcat((String[])new String[]{this.key.getInstanceNodeSessionIdString(), this.key.getDataKey(), Long.toString(this.sequenceNo), this.value});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodePropertyImpl)) {
            return false;
        }
        NodePropertyImpl other = (NodePropertyImpl)obj;
        return this.key.equals(other.getCompositeKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.toCompactForm();
    }
}

