/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.model.NodeInformationRegistry;
import de.rcenvironment.core.communication.model.SharedNodeInformationHolder;
import de.rcenvironment.core.communication.model.internal.SharedNodeInformationHolderImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.utils.ThreadsafeAutoCreationMap;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;

public class NodeInformationRegistryImpl
implements NodeInformationRegistry {
    private final ThreadsafeAutoCreationMap<String, SharedNodeInformationHolderImpl> threadSafeIdToHolderAutoMap = new ThreadsafeAutoCreationMap<String, SharedNodeInformationHolderImpl>(){

        protected SharedNodeInformationHolderImpl createNewEntry(String key) {
            return new SharedNodeInformationHolderImpl();
        }
    };

    @Override
    public SharedNodeInformationHolder getNodeInformationHolder(String id) {
        return this.getMutableNodeInformationHolder(id);
    }

    @Override
    public void printAllNameAssociations(PrintStream output, String introText) {
        if (introText != null) {
            output.println(introText);
        }
        TreeMap snapshot = new TreeMap(this.threadSafeIdToHolderAutoMap.getShallowCopy());
        for (Map.Entry entry : snapshot.entrySet()) {
            String stringValue = ((SharedNodeInformationHolderImpl)entry.getValue()).getDisplayName();
            if (stringValue != null) {
                output.println(StringUtils.format((String)"  %s -> \"%s\"", (Object[])new Object[]{entry.getKey(), stringValue}));
                continue;
            }
            output.println(StringUtils.format((String)"  %s -> <null>", (Object[])new Object[]{entry.getKey()}));
        }
    }

    public SharedNodeInformationHolderImpl getMutableNodeInformationHolder(String id) {
        return (SharedNodeInformationHolderImpl)this.threadSafeIdToHolderAutoMap.get((Object)id);
    }
}

