/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallback;
import de.rcenvironment.core.component.workflow.execution.api.RemotableWorkflowExecutionControllerService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionController;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.impl.WorkflowExecutionInformationImpl;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionControllerImpl;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WorkflowExecutionControllerServiceImpl
implements RemotableWorkflowExecutionControllerService {
    private BundleContext bundleContext;
    private WorkflowHostService workflowHostService;
    private LocalExecutionControllerUtilsService exeCtrlUtilsService;
    private NotificationService notificationService;
    private Map<String, ServiceRegistration<?>> workflowServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private Map<String, WorkflowExecutionInformation> workflowExecutionInformations = Collections.synchronizedMap(new HashMap());
    private final Log log = LogFactory.getLog(this.getClass());

    protected void activate(BundleContext context) {
        this.bundleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public WorkflowExecutionInformation createExecutionController(WorkflowExecutionContext wfExeCtx, Map<String, String> executionAuthTokens, Boolean calledFromRemote) throws WorkflowExecutionException, RemoteOperationException {
        if (calledFromRemote.booleanValue() && !this.workflowHostService.getLogicalWorkflowHostNodes().contains(wfExeCtx.getNodeId())) {
            throw new WorkflowExecutionException(StringUtils.format((String)"Workflow execution request refused, as the requested instance is not declared as workflow host: %s", (Object[])new Object[]{wfExeCtx.getNodeId()}));
        }
        WorkflowExecutionControllerImpl workflowController = new WorkflowExecutionControllerImpl(wfExeCtx);
        workflowController.setComponentExecutionAuthTokens(executionAuthTokens);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("rce.component.execution.id", wfExeCtx.getExecutionIdentifier());
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(new String[]{WorkflowExecutionController.class.getName(), WorkflowExecutionControllerCallback.class.getName()}, (Object)workflowController, properties);
        WorkflowExecutionInformationImpl workflowExecutionInformation = new WorkflowExecutionInformationImpl(wfExeCtx);
        workflowExecutionInformation.setIdentifier(wfExeCtx.getExecutionIdentifier());
        workflowExecutionInformation.setWorkflowState(WorkflowState.INIT);
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            this.workflowExecutionInformations.put(wfExeCtx.getExecutionIdentifier(), workflowExecutionInformation);
            this.workflowServiceRegistrations.put(wfExeCtx.getExecutionIdentifier(), serviceRegistration);
        }
        return workflowExecutionInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AllowRemoteAccess
    public void performDispose(final String wfExecutionId) throws RemoteOperationException {
        WorkflowStateNotificationSubscriber workflowStateDisposedListener = new WorkflowStateNotificationSubscriber(new SingleWorkflowStateChangeListener(){

            @Override
            public void onWorkflowStateChanged(WorkflowState newState) {
                if (newState == WorkflowState.DISPOSED) {
                    WorkflowExecutionControllerServiceImpl.this.dispose(wfExecutionId);
                } else if (newState != WorkflowState.DISPOSING) {
                    WorkflowExecutionControllerServiceImpl.this.log.warn((Object)StringUtils.format((String)"Received unexpected workflow state '%s' for workflow '%s'", (Object[])new Object[]{newState.getDisplayName(), wfExecutionId}));
                }
            }

            @Override
            public void onWorkflowNotAliveAnymore(String errorMessage) {
            }
        }, wfExecutionId){
            private static final long serialVersionUID = 3168599724769249933L;

            @Override
            public void processNotification(Notification notification) {
                super.processNotification(notification);
                if (WorkflowState.isWorkflowStateValid((String)((Object)notification.getBody())) && !WorkflowState.valueOf((String)((Object)notification.getBody())).equals((Object)WorkflowState.DISPOSING)) {
                    try {
                        WorkflowExecutionControllerServiceImpl.this.notificationService.unsubscribe("rce.component.workflow.state:" + wfExecutionId, (NotificationSubscriber)this);
                    }
                    catch (RemoteOperationException e) {
                        WorkflowExecutionControllerServiceImpl.this.log.warn((Object)StringUtils.format((String)"Failed to unsubscribe from state changes for workflow %s: %s", (Object[])new Object[]{wfExecutionId, e.getMessage()}));
                    }
                }
            }
        };
        try {
            this.notificationService.subscribe("rce.component.workflow.state:" + wfExecutionId, (NotificationSubscriber)workflowStateDisposedListener);
        }
        catch (RemoteOperationException e) {
            this.log.error((Object)("Failed to subscribe for workflow state changes before disposing: " + e.getMessage()));
            return;
        }
        try {
            ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, wfExecutionId, this.bundleContext)).dispose();
        }
        catch (ExecutionControllerException e) {
            this.log.warn((Object)StringUtils.format((String)"Failed to dispose workflow (%s). It seems to be already disposed (%s).", (Object[])new Object[]{wfExecutionId, e.getMessage()}));
        }
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            this.workflowExecutionInformations.remove(wfExecutionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(String executionId) {
        Map<String, ServiceRegistration<?>> map = this.workflowServiceRegistrations;
        synchronized (map) {
            if (this.workflowServiceRegistrations.containsKey(executionId)) {
                this.workflowServiceRegistrations.get(executionId).unregister();
                this.workflowServiceRegistrations.remove(executionId);
            }
        }
    }

    @AllowRemoteAccess
    public void performStart(String executionId) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).start();
    }

    @AllowRemoteAccess
    public void performCancel(String executionId) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).cancel();
    }

    @AllowRemoteAccess
    public void performPause(String executionId) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).pause();
    }

    @AllowRemoteAccess
    public void performResume(String executionId) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).resume();
    }

    @Override
    @AllowRemoteAccess
    public WorkflowState getWorkflowState(String executionId) throws ExecutionControllerException, RemoteOperationException {
        return ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).getState();
    }

    @Override
    @AllowRemoteAccess
    public Long getWorkflowDataManagementId(String executionId) throws ExecutionControllerException {
        return ((WorkflowExecutionController)this.exeCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).getDataManagementId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public Collection<WorkflowExecutionInformation> getWorkflowExecutionInformations() throws ExecutionControllerException, RemoteOperationException {
        HashMap<String, WorkflowExecutionInformation> wfExeInfoSnapshot = null;
        Map<String, WorkflowExecutionInformation> map = this.workflowExecutionInformations;
        synchronized (map) {
            wfExeInfoSnapshot = new HashMap<String, WorkflowExecutionInformation>();
            wfExeInfoSnapshot.putAll(this.workflowExecutionInformations);
        }
        for (String executionId : wfExeInfoSnapshot.keySet()) {
            Long dmId;
            WorkflowState state;
            try {
                state = this.getWorkflowState(executionId);
                dmId = this.getWorkflowDataManagementId(executionId);
            }
            catch (ExecutionControllerException e) {
                this.log.debug((Object)StringUtils.format((String)"Removed workflow %s from temporary set of workflow execution infos: %s", (Object[])new Object[]{executionId, e.getMessage()}));
                continue;
            }
            ((WorkflowExecutionInformationImpl)wfExeInfoSnapshot.get(executionId)).setWorkflowState(state);
            ((WorkflowExecutionInformationImpl)wfExeInfoSnapshot.get(executionId)).setWorkflowDataManagementId(dmId);
        }
        return new HashSet<WorkflowExecutionInformation>(wfExeInfoSnapshot.values());
    }

    protected void bindWorkflowHostService(WorkflowHostService newService) {
        this.workflowHostService = newService;
    }

    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeCtrlUtilsService = newService;
    }

    protected void bindNotificationService(NotificationService newService) {
        this.notificationService = newService;
    }
}

