/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.internal;

import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.File;
import java.io.FilenameFilter;

public class HeadlessWorkflowExecutionContextImpl
implements HeadlessWorkflowExecutionContext {
    private File wfFile;
    private File placeholdersFile;
    private File logDirectory;
    private TextOutputReceiver textOutputReceiver;
    private SingleConsoleRowsProcessor singleConsoleRowsProcessor;
    private HeadlessWorkflowExecutionService.DisposalBehavior disposeBehavior = HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected;
    private HeadlessWorkflowExecutionService.DeletionBehavior deletionBehavior = HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected;
    private boolean abortIfWorkflowUpdateRequired = false;
    private boolean isCompactOutput = false;

    @Override
    public File getWorkflowFile() {
        return this.wfFile;
    }

    @Override
    public File getPlaceholdersFile() {
        return this.placeholdersFile;
    }

    @Override
    public File getLogDirectory() {
        return this.logDirectory;
    }

    @Override
    public File[] getLogFiles() {
        return this.getLogDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("workflow.log");
            }
        });
    }

    @Override
    public TextOutputReceiver getTextOutputReceiver() {
        return this.textOutputReceiver;
    }

    @Override
    public SingleConsoleRowsProcessor getSingleConsoleRowReceiver() {
        return this.singleConsoleRowsProcessor;
    }

    @Override
    public HeadlessWorkflowExecutionService.DisposalBehavior getDisposalBehavior() {
        return this.disposeBehavior;
    }

    @Override
    public boolean shouldAbortIfWorkflowUpdateRequired() {
        return this.abortIfWorkflowUpdateRequired;
    }

    @Override
    public boolean isCompactOutput() {
        return this.isCompactOutput;
    }

    @Override
    public HeadlessWorkflowExecutionService.DeletionBehavior getDeletionBehavior() {
        return this.deletionBehavior;
    }

    public void setWfFile(File wfFile) {
        this.wfFile = wfFile;
    }

    public void setPlaceholdersFile(File placeholdersFile) {
        this.placeholdersFile = placeholdersFile;
    }

    public void setLogDirectory(File logDirectory) {
        this.logDirectory = logDirectory;
    }

    public void setTextOutputReceiver(TextOutputReceiver textOutputReceiver) {
        this.textOutputReceiver = textOutputReceiver;
    }

    public void setSingleConsoleRowsProcessor(SingleConsoleRowsProcessor singleConsoleRowsProcessor) {
        this.singleConsoleRowsProcessor = singleConsoleRowsProcessor;
    }

    public void setDisposeBehavior(HeadlessWorkflowExecutionService.DisposalBehavior disposeBehavior) {
        this.disposeBehavior = disposeBehavior;
    }

    public void setDeletionBehavior(HeadlessWorkflowExecutionService.DeletionBehavior delete) {
        this.deletionBehavior = delete;
    }

    public void setAbortIfWorkflowUpdateRequired(boolean abortIfWorkflowUpdateRequired) {
        this.abortIfWorkflowUpdateRequired = abortIfWorkflowUpdateRequired;
    }

    public void setIsCompactOutput(boolean isCompactOutput) {
        this.isCompactOutput = isCompactOutput;
    }
}

