/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.integration.RemoteToolIntegrationService;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationFileWatcherManager;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.registration.api.ComponentRegistry;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.ImageResize;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class ToolIntegrationServiceImpl
implements ToolIntegrationService,
RemoteToolIntegrationService {
    private static final String IDENTIFIER = "identifier";
    private static final String META_DATA = "metaData";
    private static final String NAME = "name";
    private static final String DATA_TYPES = "dataTypes";
    private static final String DEFAULT_DATA_TYPE = "defaultDataType";
    private static final String INPUT_HANDLINGS = "inputHandlingOptions";
    private static final String DEFAULT_INPUT_HANDLING = "defaultInputHandling";
    private static final String INPUT_EXECUTION_CONSTRAINTS = "inputExecutionConstraintOptions";
    private static final String DEFAULT_INPUT_EXECUTION_CONSTRAINT = "defaultInputExecutionConstraint";
    private static final String STRING_0 = "0";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String POSSIBLE_VALUES = "possibleValues";
    private static final int ICONSIZE32 = 32;
    private static final int ICONSIZE16 = 16;
    private static final String COULD_NOT_READ_TOOL_CONFIGURATION = "Could not read tool configuration: ";
    private static final String ERROR_WRITING_TOOL_INTEGRATION_CONFIG_FILE = "Error writing tool integration config file: ";
    private static final BigInteger DOCU_DIRECTORY_MAXIMUM_SIZE = new BigInteger("52428800");
    private static final Log LOGGER = LogFactory.getLog(ToolIntegrationServiceImpl.class);
    private static Map<String, String> toolNameToPath = Collections.synchronizedMap(new HashMap());
    private static ComponentRegistry registry;
    private final Map<String, Map<String, Object>> integratedConfiguration = Collections.synchronizedMap(new HashMap());
    private Set<String> publishedComponents = Collections.synchronizedSet(new HashSet());
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private ToolIntegrationFileWatcherManager watchManager = new ToolIntegrationFileWatcherManager(this);
    private LogicalNodeId localLogicalNodeId;

    @Override
    public void integrateTool(Map<String, Object> configurationMap, ToolIntegrationContext context) {
        this.integrateTool(configurationMap, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void integrateTool(Map<String, Object> configurationMap, ToolIntegrationContext context, boolean savePublished) {
        ConfigurationDefinition configuration;
        EndpointDefinitionsProvider outputProvider;
        EndpointDefinitionsProvider inputProvider;
        byte[] icon16 = this.readIcons(16, configurationMap, context);
        byte[] icon32 = this.readIcons(32, configurationMap, context);
        String docuHash = this.createDocumentationHash(configurationMap, context);
        String toolComponentID = String.valueOf(context.getPrefixForComponentId()) + (String)configurationMap.get("toolName");
        String toolClassName = context.getImplementingComponentClassName();
        boolean isPublished = false;
        this.readPublishedComponents(context);
        if (this.publishedComponents.contains(configurationMap.get("toolName")) || this.publishedComponents.contains(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory() + File.separator + (String)configurationMap.get("toolName"))) {
            isPublished = true;
        }
        try {
            Set<EndpointDefinition> inputs = this.createInputs(configurationMap);
            inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputs);
            Set<EndpointDefinition> outputs = this.createOutputs(configurationMap);
            outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputs);
            configuration = this.generateConfiguration(configurationMap);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)("Could not read endpoints from " + toolComponentID + ": "), (Throwable)e);
            inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(new HashSet());
            outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(new HashSet());
            configuration = ComponentConfigurationModelFactory.createConfigurationDefinition(new LinkedList(), new LinkedList(), new LinkedList(), new HashMap());
        }
        String groupName = (String)configurationMap.get("groupName");
        if (groupName == null || groupName.isEmpty()) {
            groupName = context.getComponentGroupId();
        }
        LinkedList<String> supportedIds = new LinkedList<String>();
        supportedIds.add(toolComponentID);
        supportedIds.add(String.valueOf(ToolIntegrationConstants.COMPONENT_IDS[1]) + "_" + (String)configurationMap.get("toolName"));
        ComponentInterface componentInterface = new ComponentInterfaceBuilder().setIdentifier(toolComponentID).setIdentifiers(supportedIds).setDisplayName((String)configurationMap.get("toolName")).setGroupName(groupName).setIcon16(icon16).setIcon32(icon32).setDocumentationHash(docuHash).setVersion((String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("version")).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build();
        String limitExecutionCount = "";
        limitExecutionCount = ((Map)((List)configurationMap.get("launchSettings")).get(0)).get("limitInstallationInstances") != null ? (String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("limitInstallationInstances") : (String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("limitInstalltionInstances");
        String maxParallelCountString = (String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("limitInstallationInstancesNumber");
        Integer maxParallelCount = null;
        if (limitExecutionCount != null && Boolean.parseBoolean(limitExecutionCount) && maxParallelCountString != null && !maxParallelCountString.equals("") && (maxParallelCount = Integer.valueOf(Integer.parseInt(maxParallelCountString))) < 1) {
            LOGGER.error((Object)StringUtils.format((String)"A maximum count of parallel executions of %d is invalid, it must be >= 1; a maximum count of 1 is used instead", (Object[])new Object[]{maxParallelCount}));
            maxParallelCount = 1;
        }
        ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName(toolClassName).build()).setNodeId(this.localLogicalNodeId).setInstallationId(componentInterface.getIdentifier()).setIsPublished(isPublished).setMaximumCountOfParallelInstances(maxParallelCount).build();
        if (configurationMap.get("isActive") == null || ((Boolean)configurationMap.get("isActive")).booleanValue()) {
            registry.addComponent(ci);
        }
        Map<String, Map<String, Object>> map = this.integratedConfiguration;
        synchronized (map) {
            this.integratedConfiguration.put(toolComponentID, configurationMap);
        }
        LOGGER.debug((Object)("ToolIntegration: Registered new Component " + toolComponentID));
    }

    private String createDocumentationHash(Map<String, Object> configurationMap, ToolIntegrationContext context) {
        File toolDir = this.createToolDirFile(configurationMap, context);
        File docDir = new File(toolDir, "docs");
        if (!docDir.exists()) {
            docDir.mkdirs();
        }
        if (docDir.listFiles() != null && docDir.listFiles().length > 0 && docDir.exists() && this.validateDocumentationDirectory(docDir)) {
            byte[] zippedByteArray = FileCompressionService.compressDirectoryToByteArray((File)docDir, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
            if (zippedByteArray == null) {
                LOGGER.error((Object)"Was not able to create hash for documentation due to an issue with the compression.");
                return "";
            }
            return DigestUtils.md5Hex((byte[])zippedByteArray);
        }
        return "";
    }

    private boolean validateDocumentationDirectory(File docDir) {
        boolean valid = true;
        BigInteger directorySize = FileUtils.sizeOfDirectoryAsBigInteger((File)docDir);
        if (DOCU_DIRECTORY_MAXIMUM_SIZE.compareTo(directorySize) < 0) {
            LOGGER.error((Object)StringUtils.format((String)"Size of documentation directory %s too big (max. 50 Mb).", (Object[])new Object[]{docDir.getAbsolutePath()}));
            valid = false;
        }
        File[] fileArray = docDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                LOGGER.error((Object)StringUtils.format((String)"Directories not allowed in documentation directory %s.", (Object[])new Object[]{docDir.getAbsolutePath()}));
                valid = false;
            } else if (!ArrayUtils.contains((Object[])ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS, (Object)FilenameUtils.getExtension((String)f.getName())) && !CrossPlatformFilenameUtils.isNFSFile((String)f.getName())) {
                LOGGER.error((Object)StringUtils.format((String)"Invalid filetype of %s in documentation directory %s. (Valid filetypes: %s)", (Object[])new Object[]{f.getName(), docDir.getAbsolutePath(), Arrays.toString(ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS).replaceAll("\\[", "").replaceAll("\\]", "")}));
                valid = false;
            }
            ++n2;
        }
        return valid;
    }

    private File createToolDirFile(Map<String, Object> configurationMap, ToolIntegrationContext context) {
        return new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), (String)configurationMap.get("toolName"));
    }

    private byte[] readIcons(int size, Map<String, Object> configurationMap, ToolIntegrationContext context) {
        byte[] iconArray;
        block16: {
            iconArray = null;
            iconArray = this.readDefaultToolIcon(size);
            String iconPath = (String)configurationMap.get("toolIconPath");
            if (iconPath != null && !iconPath.isEmpty()) {
                File icon;
                if (!new File(iconPath).isAbsolute()) {
                    iconPath = String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory() + File.separator + context.getToolDirectoryPrefix() + configurationMap.get("toolName") + File.separator + iconPath;
                }
                if ((icon = new File(iconPath)).exists() && icon.isFile()) {
                    try {
                        File iconsource = icon;
                        File icontarget = TempFileServiceAccess.getInstance().createTempFileFromPattern("icon_" + size + "*.png");
                        BufferedImage image = ImageIO.read(icon);
                        if (image == null) {
                            iconArray = this.readDefaultToolIcon(size);
                            break block16;
                        }
                        if (!iconsource.exists()) break block16;
                        Throwable throwable = null;
                        Object var11_12 = null;
                        try (FileImageInputStream imageInputStream = new FileImageInputStream(iconsource);){
                            BufferedImage bi = ImageResize.resize((BufferedImage)ImageIO.read(imageInputStream), (int)size);
                            if (bi != null && icontarget != null) {
                                ImageIO.write((RenderedImage)bi, "PNG", icontarget);
                                iconArray = FileUtils.readFileToByteArray((File)icontarget);
                                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(icontarget);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.debug((Object)"Could not load icon, use default icon");
                    }
                }
            }
        }
        return iconArray;
    }

    private byte[] readDefaultToolIcon(int iconSize) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream inputStream = ToolIntegrationServiceImpl.class.getResourceAsStream("/resources/icons/tool" + iconSize + ".png");){
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTool(String componentID, ToolIntegrationContext context) {
        String toolComponentID = componentID;
        if (!componentID.startsWith(context.getPrefixForComponentId())) {
            toolComponentID = String.valueOf(context.getPrefixForComponentId()) + componentID;
        }
        if (this.integratedConfiguration.containsKey(toolComponentID)) {
            String toolIDAndVersion = String.valueOf(toolComponentID) + "/" + (String)((Map)((List)this.integratedConfiguration.get(toolComponentID).get("launchSettings")).get(0)).get("version");
            Map<String, Map<String, Object>> map = this.integratedConfiguration;
            synchronized (map) {
                this.integratedConfiguration.remove(toolComponentID);
            }
            registry.removeComponent(toolIDAndVersion);
        }
        LOGGER.debug((Object)("ToolIntegration: Removed Component " + toolComponentID));
    }

    private ConfigurationDefinition generateConfiguration(Map<String, Object> configurationMap) {
        LinkedList<Object> configuration = new LinkedList<Object>();
        LinkedList<Object> configurationMetadata = new LinkedList<Object>();
        this.readConfigurationWithMetaDataToLists(configurationMap, configuration, configurationMetadata);
        Map<String, String> readOnlyConfiguration = this.createReadOnlyConfiguration(configurationMap);
        return ComponentConfigurationModelFactory.createConfigurationDefinition(configuration, new LinkedList(), configurationMetadata, readOnlyConfiguration);
    }

    private void readConfigurationWithMetaDataToLists(Map<String, Object> configurationMap, List<Object> configuration, List<Object> configurationMetadata) {
        Map properties = (Map)configurationMap.get("toolProperties");
        if (properties != null) {
            for (String groupKey : properties.keySet()) {
                Map group = (Map)properties.get(groupKey);
                String configFileName = null;
                if (group.get("propertyCreateConfigFile") != null && ((Boolean)group.get("propertyCreateConfigFile")).booleanValue()) {
                    configFileName = (String)group.get("propertyConfigFilename");
                }
                for (String propertyOrConfigfile : group.keySet()) {
                    int i = 0;
                    if (group.get(propertyOrConfigfile) instanceof String || group.get(propertyOrConfigfile) instanceof Boolean) continue;
                    Map property = (Map)group.get(propertyOrConfigfile);
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("key", (String)property.get("propertyKey"));
                    config.put(DEFAULT_VALUE, (String)property.get("propertyDefaultValue"));
                    configuration.add(config);
                    HashMap<String, String> configMetadata = new HashMap<String, String>();
                    configMetadata.put("guiName", (String)property.get("propertyDisplayName"));
                    if (configFileName != null) {
                        configMetadata.put("propertyConfigFilename", configFileName);
                    }
                    configMetadata.put("guiGroupPosition", groupKey);
                    configMetadata.put("guiPosition", "" + i++);
                    configMetadata.put("key", (String)property.get("propertyKey"));
                    configurationMetadata.add(configMetadata);
                }
            }
        }
        HashMap<String, String> historyConfig = new HashMap<String, String>();
        historyConfig.put("key", "storeComponentHistoryData");
        historyConfig.put(DEFAULT_VALUE, "false");
        configuration.add(historyConfig);
    }

    private Map<String, String> createReadOnlyConfiguration(Map<String, Object> configurationMap) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String key : configurationMap.keySet()) {
            if (configurationMap.get(key) instanceof String) {
                configuration.put(key, (String)configurationMap.get(key));
            }
            if (!(configurationMap.get(key) instanceof Boolean)) continue;
            configuration.put(key, ((Boolean)configurationMap.get(key)).toString());
        }
        configuration.put("rootWorkingDirectory", (String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("rootWorkingDirectory"));
        configuration.put("toolDirectory", (String)((Map)((List)configurationMap.get("launchSettings")).get(0)).get("toolDirectory"));
        return configuration;
    }

    private Set<EndpointDefinition> createOutputs(Map<String, Object> configurationMap) {
        List dynamicOutputs;
        List definedOutputs = (List)configurationMap.get("outputs");
        HashSet<EndpointDefinition> outputs = new HashSet<EndpointDefinition>();
        if (definedOutputs != null) {
            for (Map output : definedOutputs) {
                HashMap description = new HashMap();
                description.put(NAME, output.get("endpointName"));
                description.put(DEFAULT_DATA_TYPE, output.get("endpointDataType"));
                LinkedList<String> dataTypes = new LinkedList<String>();
                dataTypes.add((String)output.get("endpointDataType"));
                description.put(DATA_TYPES, dataTypes);
                outputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.OUTPUT));
            }
        }
        if ((dynamicOutputs = (List)configurationMap.get(ToolIntegrationConstants.KEY_ENDPOINT_DYNAMIC_OUTPUTS)) != null) {
            for (Map output : dynamicOutputs) {
                HashMap description = new HashMap();
                description.put(IDENTIFIER, output.get("endpointIdentifier"));
                description.put(DEFAULT_DATA_TYPE, output.get("endpointDefaultDataType"));
                LinkedList dataTypes = new LinkedList();
                dataTypes.addAll((List)output.get("endpointDataTypes"));
                description.put(DATA_TYPES, dataTypes);
                Map metadata = (Map)output.get("endpointMetaData");
                description.put(META_DATA, metadata);
                outputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.OUTPUT));
            }
        }
        return outputs;
    }

    private Set<EndpointDefinition> createInputs(Map<String, Object> configurationMap) {
        List definedInputs = (List)configurationMap.get("inputs");
        HashSet<EndpointDefinition> inputs = new HashSet<EndpointDefinition>();
        if (definedInputs != null) {
            for (Map input : definedInputs) {
                String[] inputExecutionConstraints;
                String[] inputHandlings;
                HashMap description = new HashMap();
                description.put(NAME, input.get("endpointName"));
                description.put(DEFAULT_DATA_TYPE, input.get("endpointDataType"));
                LinkedList<String> dataTypes = new LinkedList<String>();
                dataTypes.add((String)input.get("endpointDataType"));
                description.put(DATA_TYPES, dataTypes);
                description.put(DEFAULT_DATA_TYPE, input.get("endpointDataType"));
                if (input.containsKey("inputHandling")) {
                    inputHandlings = StringUtils.splitAndUnescape((String)((String)input.get("inputHandling")));
                    if (input.containsKey(DEFAULT_INPUT_HANDLING)) {
                        description.put(DEFAULT_INPUT_HANDLING, input.get(DEFAULT_INPUT_HANDLING));
                    } else {
                        description.put(DEFAULT_INPUT_HANDLING, inputHandlings[0]);
                    }
                } else {
                    inputHandlings = new String[]{EndpointDefinition.InputDatumHandling.Single.name()};
                    if (((String)input.get("endpointUsage")).equals("initial")) {
                        inputHandlings = new String[]{EndpointDefinition.InputDatumHandling.Constant.name()};
                    }
                    description.put(DEFAULT_INPUT_HANDLING, inputHandlings[0]);
                }
                description.put(INPUT_HANDLINGS, Arrays.asList(inputHandlings));
                if (input.containsKey("inputExecutionConstraint")) {
                    inputExecutionConstraints = StringUtils.splitAndUnescape((String)((String)input.get("inputExecutionConstraint")));
                    if (input.containsKey(DEFAULT_INPUT_EXECUTION_CONSTRAINT)) {
                        description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, input.get(DEFAULT_INPUT_EXECUTION_CONSTRAINT));
                    } else {
                        description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, inputExecutionConstraints[0]);
                    }
                } else {
                    inputExecutionConstraints = new String[]{EndpointDefinition.InputExecutionContraint.Required.name()};
                    if (((String)input.get("endpointUsage")).equals("optional")) {
                        inputExecutionConstraints = new String[]{EndpointDefinition.InputExecutionContraint.NotRequired.name()};
                    }
                    description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, inputExecutionConstraints[0]);
                }
                description.put(INPUT_EXECUTION_CONSTRAINTS, Arrays.asList(inputExecutionConstraints));
                HashMap metadata = new HashMap();
                if ((((String)input.get("endpointDataType")).equals(DataType.FileReference.name()) || ((String)input.get("endpointDataType")).equals(DataType.DirectoryReference.name())) && input.get("endpointFileName") != null) {
                    HashMap<String, Object> metadataFilename = new HashMap<String, Object>();
                    metadataFilename.put("guiName", "Filename");
                    metadataFilename.put("guiPosition", STRING_0);
                    metadataFilename.put("guiGroup", "File");
                    LinkedList<String> possibleValuesListFilename = new LinkedList<String>();
                    possibleValuesListFilename.add((String)input.get("endpointFileName"));
                    metadataFilename.put(POSSIBLE_VALUES, possibleValuesListFilename);
                    metadataFilename.put(DEFAULT_VALUE, input.get("endpointFileName"));
                    metadataFilename.put("visibility", EndpointMetaDataConstants.Visibility.developerConfigurable.toString());
                    metadata.put("endpointFileName", metadataFilename);
                }
                description.put(META_DATA, metadata);
                inputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.INPUT));
            }
        }
        if (configurationMap.containsKey("dynamicInputs")) {
            List dynamicInputs = (List)configurationMap.get("dynamicInputs");
            for (Map input : dynamicInputs) {
                LinkedList<String> inputHandlingOptions;
                HashMap description = new HashMap();
                description.put(IDENTIFIER, input.get("endpointIdentifier"));
                description.put(DEFAULT_DATA_TYPE, input.get("endpointDefaultDataType"));
                LinkedList dataTypes = new LinkedList();
                dataTypes.addAll((List)input.get("endpointDataTypes"));
                description.put(DATA_TYPES, dataTypes);
                Map metadata = (Map)input.get("endpointMetaData");
                description.put(META_DATA, metadata);
                if (metadata.containsKey("usage")) {
                    description.put(DEFAULT_INPUT_HANDLING, EndpointDefinition.InputDatumHandling.Single.name());
                    inputHandlingOptions = new LinkedList<String>();
                    inputHandlingOptions.add(EndpointDefinition.InputDatumHandling.Single.name());
                    inputHandlingOptions.add(EndpointDefinition.InputDatumHandling.Constant.name());
                    description.put(INPUT_HANDLINGS, inputHandlingOptions);
                    description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, EndpointDefinition.InputExecutionContraint.Required.name());
                    LinkedList<String> inputinputExecutionConstraintOptions = new LinkedList<String>();
                    inputinputExecutionConstraintOptions.add(EndpointDefinition.InputExecutionContraint.Required.name());
                    inputinputExecutionConstraintOptions.add(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name());
                    description.put(INPUT_EXECUTION_CONSTRAINTS, inputinputExecutionConstraintOptions);
                    metadata.remove("usage");
                } else {
                    if (input.containsKey("inputinputHandlingOptions")) {
                        description.put(DEFAULT_INPUT_HANDLING, input.get(DEFAULT_INPUT_HANDLING));
                        inputHandlingOptions = new LinkedList();
                        inputHandlingOptions.addAll((List)input.get("inputinputHandlingOptions"));
                        description.put(INPUT_HANDLINGS, inputHandlingOptions);
                    }
                    if (input.containsKey("inputinputExecutionConstraintOptions")) {
                        description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, input.get(DEFAULT_INPUT_EXECUTION_CONSTRAINT));
                        LinkedList inputinputExecutionConstraintOptions = new LinkedList();
                        inputinputExecutionConstraintOptions.addAll((List)input.get("inputinputExecutionConstraintOptions"));
                        description.put(INPUT_EXECUTION_CONSTRAINTS, inputinputExecutionConstraintOptions);
                    }
                }
                inputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.INPUT));
            }
        }
        return inputs;
    }

    @Override
    public void readAndIntegratePersistentTools(ToolIntegrationContext context) {
        String configFolder = context.getRootPathToToolIntegrationDirectory();
        File toolIntegrationFile = new File(configFolder, context.getNameOfToolIntegrationDirectory());
        this.readPublishedComponents(context);
        if (toolIntegrationFile.exists() && toolIntegrationFile.isDirectory() && toolIntegrationFile.listFiles().length > 0) {
            LOGGER.debug((Object)("Reading integration tool directory :" + toolIntegrationFile.getAbsolutePath()));
            File[] fileArray = toolIntegrationFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File toolFolder = fileArray[n2];
                if (toolFolder.isDirectory() && !toolFolder.getName().equals("null")) {
                    this.readToolDirectory(toolFolder, context);
                }
                ++n2;
            }
        }
        this.watchManager.createWatcherForToolRootDirectory(context);
        this.updatePublishedComponents(context);
    }

    @Override
    public void readToolDirectory(File toolFolder, ToolIntegrationContext information) {
        File configFile = new File(toolFolder, information.getConfigurationFilename());
        if (configFile.exists() && configFile.isFile()) {
            try {
                Map configurationMap = (Map)this.mapper.readValue(configFile, new HashMap().getClass());
                if (!this.integratedConfiguration.containsKey(String.valueOf(information.getPrefixForComponentId()) + configurationMap.get("toolName"))) {
                    toolNameToPath.put((String)configurationMap.get("toolName"), toolFolder.getAbsolutePath());
                    this.checkIcon(toolFolder, configurationMap);
                    if (!this.isToolIntegrated(configurationMap, information)) {
                        this.integrateTool(configurationMap, information);
                    }
                } else {
                    LOGGER.warn((Object)("Tool with foldername already exists:  " + toolFolder.getName()));
                }
            }
            catch (JsonParseException e) {
                LOGGER.error((Object)COULD_NOT_READ_TOOL_CONFIGURATION, (Throwable)e);
            }
            catch (JsonMappingException e) {
                LOGGER.error((Object)COULD_NOT_READ_TOOL_CONFIGURATION, (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)COULD_NOT_READ_TOOL_CONFIGURATION, (Throwable)e);
            }
        }
    }

    private void checkIcon(File toolFolder, Map<String, Object> configurationMap) {
        File icon;
        if (configurationMap.get("toolIconPath") != null && !(icon = new File((String)configurationMap.get("toolIconPath"))).isAbsolute()) {
            File file = new File(toolFolder, icon.getName());
        }
    }

    @Override
    public void writeToolIntegrationFileToSpecifiedFolder(String folder, Map<String, Object> configurationMap, ToolIntegrationContext information) throws IOException {
        if (!configurationMap.containsKey("toolIntegrationVersion")) {
            configurationMap.put("toolIntegrationVersion", 1);
        }
        Map launchSettings = (Map)((List)configurationMap.get("launchSettings")).get(0);
        String value = (String)launchSettings.remove("limitInstalltionInstances");
        if (!launchSettings.containsKey("limitInstallationInstances") && value != null) {
            launchSettings.put("limitInstallationInstances", value);
        }
        File toolConfigFile = new File(folder, String.valueOf(information.getNameOfToolIntegrationDirectory()) + File.separator + information.getToolDirectoryPrefix() + configurationMap.get("toolName"));
        toolConfigFile.mkdirs();
        this.handleToolIcon(configurationMap, toolConfigFile);
        this.handleDoc(configurationMap, toolConfigFile);
        configurationMap.remove("publishComponent");
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        sortedMap.putAll(configurationMap);
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(toolConfigFile, information.getConfigurationFilename()), sortedMap);
        toolNameToPath.put((String)configurationMap.get("toolName"), toolConfigFile.getAbsolutePath());
    }

    private void handleDoc(Map<String, Object> configurationMap, File toolConfigFile) {
        if ((String)configurationMap.get("documentationFilePath") != null && !((String)configurationMap.get("documentationFilePath")).isEmpty()) {
            File docfile = new File((String)configurationMap.get("documentationFilePath"));
            File docDir = new File(toolConfigFile, "docs");
            if (docfile.isAbsolute() && docfile.exists() && docfile.isFile()) {
                File destination;
                if (docDir.exists() && docDir.listFiles().length > 0) {
                    File[] fileArray = docDir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        try {
                            FileUtils.forceDelete((File)f);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)("Could not delete old documentation file: " + f.getAbsolutePath() + ": " + e.getMessage()));
                        }
                        ++n2;
                    }
                }
                if (!(destination = new File(docDir, docfile.getName())).getAbsolutePath().equals(docfile.getAbsolutePath())) {
                    try {
                        FileUtils.copyFile((File)docfile, (File)destination);
                        configurationMap.put("documentationFilePath", docfile.getName());
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Could not copy documentation to tool directory: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void handleToolIcon(Map<String, Object> configurationMap, File toolConfigFile) {
        if ((String)configurationMap.get("toolIconPath") != null && !((String)configurationMap.get("toolIconPath")).isEmpty()) {
            File destination;
            File icon = new File((String)configurationMap.get("toolIconPath"));
            if (configurationMap.get("uploadIcon") != null && ((Boolean)configurationMap.get("uploadIcon")).booleanValue() && icon.exists() && icon.isFile() && icon.isAbsolute() && !(destination = new File(toolConfigFile, icon.getName())).getAbsolutePath().equals(icon.getAbsolutePath())) {
                try {
                    FileUtils.copyFile((File)icon, (File)destination);
                    configurationMap.remove("uploadIcon");
                    configurationMap.put("toolIconPath", icon.getName());
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Could not copy icon to tool directory: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void writeToolIntegrationFile(Map<String, Object> configurationMap, ToolIntegrationContext information) throws IOException {
        String configFolder = information.getRootPathToToolIntegrationDirectory();
        this.writeToolIntegrationFileToSpecifiedFolder(configFolder, configurationMap, information);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePublishedComponents(ToolIntegrationContext context) {
        File toolsfolder = new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
        if (!toolsfolder.exists()) {
            toolsfolder.mkdirs();
        }
        try {
            File publishedComponentsFile = new File(toolsfolder, "published.conf");
            if (!publishedComponentsFile.exists()) {
                publishedComponentsFile.createNewFile();
            }
            Set<String> set = this.publishedComponents;
            synchronized (set) {
                if (this.publishedComponents != null) {
                    HashSet<String> componentsToWrite = new HashSet<String>();
                    for (String component : this.publishedComponents) {
                        if (!component.startsWith(toolsfolder.getAbsolutePath())) continue;
                        componentsToWrite.add(component);
                    }
                    FileUtils.writeLines((File)publishedComponentsFile, componentsToWrite);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)ERROR_WRITING_TOOL_INTEGRATION_CONFIG_FILE, (Throwable)e);
        }
    }

    private void readPublishedComponents(ToolIntegrationContext context) {
        File toolsfolder = new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
        if (this.publishedComponents == null) {
            this.publishedComponents = Collections.synchronizedSet(new HashSet());
        }
        if (toolsfolder.exists()) {
            try {
                File publishedComponentsFile = new File(toolsfolder, "published.conf");
                if (!publishedComponentsFile.exists()) {
                    publishedComponentsFile.createNewFile();
                    publishedComponentsFile.setReadable(true);
                    publishedComponentsFile.setWritable(true);
                }
                if (publishedComponentsFile.canWrite()) {
                    HashSet newPublishedComponents = new HashSet(FileUtils.readLines((File)publishedComponentsFile));
                    for (String newComp : newPublishedComponents) {
                        String comp = newComp.trim();
                        if (!new File(newComp).isAbsolute()) {
                            comp = new File(toolsfolder, comp).getAbsolutePath();
                        }
                        if (newComp.isEmpty() || !new File(comp).exists()) continue;
                        this.publishedComponents.add(comp);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)ERROR_WRITING_TOOL_INTEGRATION_CONFIG_FILE, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Set<String> getPublishedComponents() {
        return this.publishedComponents;
    }

    @Override
    public synchronized Map<String, Object> getToolConfiguration(String toolId) {
        return this.integratedConfiguration.get(toolId);
    }

    @Override
    public synchronized Set<String> getIntegratedComponentIds() {
        return this.integratedConfiguration.keySet();
    }

    @Override
    public synchronized Set<String> getActiveComponentIds() {
        HashSet<String> activeIds = new HashSet<String>();
        for (String key : this.integratedConfiguration.keySet()) {
            if (this.integratedConfiguration.get(key).get("isActive") != null && !((Boolean)this.integratedConfiguration.get(key).get("isActive")).booleanValue()) continue;
            activeIds.add(key);
        }
        return activeIds;
    }

    public void activate(BundleContext context) {
    }

    protected void bindComponentRegistry(ComponentRegistry newRegistry) {
        registry = newRegistry;
    }

    protected void unbindComponentRegistry(ComponentRegistry newRegistry) {
        registry = (ComponentRegistry)ServiceUtils.createFailingServiceProxy(ComponentRegistry.class);
    }

    protected void bindPlatformService(PlatformService newService) {
        this.localLogicalNodeId = newService.getLocalDefaultLogicalNodeId();
    }

    protected void unbindPlatformService(PlatformService newService) {
    }

    @Override
    public String getPathOfComponentID(String id, ToolIntegrationContext context) {
        if (id.startsWith(context.getPrefixForComponentId())) {
            return toolNameToPath.get(id.substring(context.getPrefixForComponentId().length()));
        }
        return toolNameToPath.get(id);
    }

    @Override
    public boolean isToolIntegrated(Map<String, Object> configurationMap, ToolIntegrationContext integrationContext) {
        String toolComponentID = String.valueOf(integrationContext.getPrefixForComponentId()) + (String)configurationMap.get("toolName");
        return this.integratedConfiguration.keySet().contains(toolComponentID);
    }

    @Override
    public String getToolNameToPath(String path) {
        for (Map.Entry<String, String> e : toolNameToPath.entrySet()) {
            if (!e.getValue().trim().equals(path.trim())) continue;
            return e.getKey();
        }
        return null;
    }

    @Override
    public void putToolNameToPath(String toolName, File parentFile) {
        toolNameToPath.put(toolName, parentFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePublishedComponents(ToolIntegrationContext context) {
        HashSet<String> oldPublishedComponents = new HashSet<String>();
        Set<String> set = this.publishedComponents;
        synchronized (set) {
            Map<String, Object> configuration;
            String toolComponentID;
            oldPublishedComponents.addAll(this.publishedComponents);
            HashSet<String> toRemove = new HashSet<String>();
            for (String path : this.publishedComponents) {
                if (!path.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                toRemove.add(path);
            }
            this.publishedComponents.removeAll(toRemove);
            this.readPublishedComponents(context);
            HashSet<String> addPublished = new HashSet<String>();
            for (String newComp : this.publishedComponents) {
                if (oldPublishedComponents.contains(newComp) || !newComp.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                addPublished.add(newComp);
            }
            HashSet<String> removePublished = new HashSet<String>();
            for (String oldComp : oldPublishedComponents) {
                if (this.publishedComponents.contains(oldComp) || !oldComp.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                removePublished.add(oldComp);
            }
            for (String path : addPublished) {
                toolComponentID = String.valueOf(context.getPrefixForComponentId()) + this.getToolNameToPath(path);
                configuration = this.integratedConfiguration.get(toolComponentID);
                this.removeTool(toolComponentID, context);
                if (configuration == null) continue;
                this.integrateTool(configuration, context, false);
            }
            for (String path : removePublished) {
                toolComponentID = String.valueOf(context.getPrefixForComponentId()) + this.getToolNameToPath(path);
                configuration = this.integratedConfiguration.get(toolComponentID);
                this.removeTool(toolComponentID, context);
                if (configuration == null) continue;
                this.integrateTool(configuration, context, false);
            }
        }
    }

    @Override
    public synchronized void addPublishedTool(String toolPath) {
        this.publishedComponents.add(toolPath);
    }

    @Override
    public synchronized void unpublishTool(String toolPath) {
        this.publishedComponents.remove(toolPath);
    }

    @Override
    @AllowRemoteAccess
    public byte[] getToolDocumentation(String identifier) throws RemoteOperationException {
        ToolIntegrationContext context = this.getContextForIdentifier(identifier);
        if (context == null) {
            return null;
        }
        String name = identifier.substring(context.getPrefixForComponentId().length());
        File sourceDirectory = new File(toolNameToPath.get(name = name.substring(0, name.indexOf("/"))), "docs");
        byte[] resultData = FileCompressionService.compressDirectoryToByteArray((File)sourceDirectory, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
        if (resultData == null) {
            LOGGER.error((Object)"Was not able to create an archive for documentation due to a compression issue.");
            return null;
        }
        return resultData;
    }

    private ToolIntegrationContext getContextForIdentifier(String identifier) {
        ToolIntegrationContext result = null;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        for (ToolIntegrationContext context : ((ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class)).getAllIntegrationContexts()) {
            if (!identifier.startsWith(context.getPrefixForComponentId())) continue;
            result = context;
        }
        return result;
    }

    @Override
    public void setFileWatcherActive(boolean value) {
        this.watchManager.setAllWatcherActivity(value);
    }

    @Override
    public void unregisterIntegration(String previousToolName, ToolIntegrationContext integrationContext) {
        this.watchManager.unregister(previousToolName, integrationContext);
    }

    @Override
    public void registerRecursive(String toolName, ToolIntegrationContext integrationContext) {
        this.watchManager.registerRecursive(toolName, integrationContext);
    }

    @Override
    public void deactivateIntegrationService() {
        this.watchManager.shutdown();
    }
}

