/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal.handlers;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.internal.handlers.EquinoxConsoleCommandInvoker;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Version;

public class BuiltInCommandPlugin
implements CommandPlugin {
    private static final String CMD_DEV = "dev";
    private static final String CMD_DUMMY = "dummy";
    private static final String CMD_HELP = "help";
    private static final String CMD_HELP_DEV = "help --dev";
    private static final String CMD_OSGI = "osgi";
    private static final String CMD_STATS = "stats";
    private static final String CMD_TASKS = "tasks";
    private static final String CMD_VERSION = "version";
    private static final String CMD_CRASH = "force-crash";

    @Override
    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_HELP, "", false, "list available commands", new String[0]));
        contributions.add(new CommandDescription(CMD_VERSION, "[--detailed]", false, "print version information", new String[0]));
        contributions.add(new CommandDescription(CMD_DEV, "", true, "alias of \"help --dev\" [deprecated]", new String[0]));
        contributions.add(new CommandDescription(CMD_DUMMY, "", true, "prints a test message", new String[0]));
        contributions.add(new CommandDescription(CMD_CRASH, "<delay>", true, "\"kills\" the instance without proper shutdown at <delay> milliseconds after the command is executed", new String[0]));
        contributions.add(new CommandDescription(CMD_HELP_DEV, "", true, "list available commands (including developer commands)", new String[0]));
        contributions.add(new CommandDescription(CMD_STATS, "", true, "show internal statistics", new String[0]));
        contributions.add(new CommandDescription(CMD_OSGI, "[-o <filename>] <command>", true, "executes an OSGi/Equinox console command; use -o to write text output to a file", new String[0]));
        contributions.add(new CommandDescription(CMD_TASKS, "[-a] [-i]", true, "show information about internal tasks", "-a - Show all tasks, including inactive ones", "-i - Extended information: list tasks with a unique id"));
        return contributions;
    }

    @Override
    public void execute(CommandContext context) throws CommandException {
        String cmd = context.consumeNextToken();
        if (CMD_HELP.equals(cmd)) {
            boolean devOption = context.consumeNextTokenIfEquals("--dev");
            this.performHelp(context, devOption);
        } else if (CMD_VERSION.equals(cmd)) {
            this.performVersion(context);
        } else if (CMD_OSGI.equals(cmd)) {
            this.performOsgi(context);
        } else if (CMD_CRASH.equals(cmd)) {
            this.performCrash(context);
        } else if (CMD_DEV.equals(cmd)) {
            this.performHelp(context, true);
        } else if (CMD_STATS.equals(cmd)) {
            this.performStats(context);
        } else if (CMD_TASKS.equals(cmd)) {
            this.performTasks(context);
        } else if (CMD_DUMMY.equals(cmd)) {
            this.performDummy(context);
        } else {
            throw new IllegalStateException();
        }
    }

    private void performHelp(CommandContext context, boolean devOption) throws CommandException {
        context.setDeveloperCommandSetEnabled(devOption);
        throw CommandException.requestHelp(context);
    }

    private void performDummy(CommandContext context) throws CommandException {
        context.println("Dummy command executing");
    }

    private void performOsgi(CommandContext context) throws CommandException {
        EquinoxConsoleCommandInvoker commandInvoker = new EquinoxConsoleCommandInvoker();
        boolean logToFile = context.consumeNextTokenIfEquals("-o");
        if (!logToFile) {
            commandInvoker.execute(context);
        } else {
            String outputFilename = context.consumeNextToken();
            if (outputFilename == null) {
                throw CommandException.syntaxError("Missing filename after -o parameter", context);
            }
            CapturingTextOutReceiver outputReceiver = new CapturingTextOutReceiver();
            CommandContext wrappedContext = new CommandContext(context.consumeRemainingTokens(), (TextOutputReceiver)outputReceiver, context.getInvokerInformation());
            commandInvoker.execute(wrappedContext);
            File outputFile = new File(outputFilename);
            try {
                FileUtils.write((File)outputFile, (CharSequence)outputReceiver.getBufferedOutput());
                context.println("Logged output to " + outputFile.getAbsolutePath());
            }
            catch (IOException iOException) {
                context.println("Internal error: Failed to write to output file " + outputFile.getAbsolutePath());
            }
        }
    }

    private void performVersion(CommandContext context) {
        if (context.consumeNextTokenIfEquals("--detailed")) {
            context.println("RCE platform version: " + VersionUtils.getVersionOfPlatformBundles());
            context.println("RCE core version: " + VersionUtils.getVersionOfCoreBundles());
            context.println("RCE product version: " + VersionUtils.getVersionOfProduct());
        } else {
            Version version = VersionUtils.getVersionOfProduct();
            String buildId = VersionUtils.getBuildIdAsString((Version)version);
            if (buildId == null) {
                buildId = "-";
            }
            context.println(StringUtils.format((String)"%s (build ID: %s)", (Object[])new Object[]{VersionUtils.getVersionAsString((Version)version), buildId}));
        }
    }

    private void performCrash(CommandContext context) throws CommandException {
        String token = context.consumeNextToken();
        if (token == null || context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters(context);
        }
        try {
            int delayMsec = Integer.parseInt(token);
            LogFactory.getLog(this.getClass()).warn((Object)StringUtils.format((String)"Killing the instance (using System.exit(1)) in %,d msec...", (Object[])new Object[]{delayMsec}));
            ConcurrencyUtils.getAsyncTaskService().scheduleAfterDelay(new Runnable(){

                @Override
                @TaskDescription(value="Simulate an instance crash (triggered by console command)")
                public void run() {
                    System.exit(1);
                }
            }, (long)delayMsec);
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.syntaxError(StringUtils.format((String)"You need to specify the delay in milliseconds. %s is not a valid number.", (Object[])new Object[]{token}), context);
        }
    }

    private void performTasks(CommandContext context) throws CommandException {
        String token;
        boolean addTaskIds = false;
        boolean includeInactive = false;
        while ((token = context.consumeNextToken()) != null) {
            switch (token) {
                case "-a": {
                    includeInactive = true;
                    break;
                }
                case "-i": {
                    addTaskIds = true;
                    break;
                }
                default: {
                    throw CommandException.syntaxError("Unknown parameter: " + token, context);
                }
            }
        }
        context.println(ConcurrencyUtils.getThreadPoolManagement().getFormattedStatistics(addTaskIds, includeInactive));
    }

    private void performStats(CommandContext context) {
        for (String line : StatsCounter.getFullReportAsStandardTextRepresentation()) {
            context.println(line);
        }
    }
}

