/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.internal;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.api.Toolkit;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.internal.ToolkitImpl;
import de.rcenvironment.toolkit.core.setup.ToolkitSetup;
import de.rcenvironment.toolkit.core.spi.module.DefaultClassFilter;
import de.rcenvironment.toolkit.core.spi.module.ObjectGraph;
import de.rcenvironment.toolkit.core.spi.module.ShutdownHookReceiver;
import de.rcenvironment.toolkit.core.spi.module.ToolkitModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class ToolkitBuilderImpl
implements ToolkitSetup,
ShutdownHookReceiver {
    private static final int MAX_DEPENDENCY_RESOLUTION_ATTEMPTS = 10;
    private final ObjectGraph objectGraph;
    private final DefaultClassFilter defaultClassFilter = new DefaultClassFilter();
    private final Map<Class<?>, ToolkitModule<?>> moduleInstances = new HashMap();
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();

    public ToolkitBuilderImpl(ObjectGraph objectGraphBuilder) {
        this.objectGraph = objectGraphBuilder;
    }

    @Override
    public <T extends ToolkitModule<TModuleConf>, TModuleConf> TModuleConf configureModule(Class<T> module) throws ToolkitException {
        ToolkitModule<?> moduleInstance;
        if (!this.moduleInstances.containsKey(module)) {
            try {
                moduleInstance = (ToolkitModule<?>)module.newInstance();
                this.moduleInstances.put(module, moduleInstance);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ToolkitException(e);
            }
        } else {
            moduleInstance = this.moduleInstances.get(module);
        }
        return (TModuleConf)moduleInstance.getConfiguration();
    }

    public Toolkit create() throws ToolkitException {
        for (Map.Entry<Class<?>, ToolkitModule<?>> e : this.moduleInstances.entrySet()) {
            ToolkitModule<?> toolkitModule = e.getValue();
            this.registerModule(toolkitModule);
        }
        int i = 0;
        while (i < 10) {
            HashSet missingModulesDependencies = new HashSet();
            for (Map.Entry<Class<?>, ToolkitModule<?>> entry : this.moduleInstances.entrySet()) {
                ToolkitModule<?> module = entry.getValue();
                module.suggestMissingModuleDependencies(this.objectGraph, missingModulesDependencies);
            }
            if (missingModulesDependencies.isEmpty()) break;
            LogFactory.getLog(this.getClass()).debug((Object)("Identified missing service dependencies, loading suggested default module(s) " + missingModulesDependencies));
            for (Class clazz : missingModulesDependencies) {
                try {
                    this.registerModule((ToolkitModule)clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ToolkitException(e);
                }
            }
            ++i;
        }
        ImmutableServiceRegistry serviceRegistry = this.objectGraph.instantiate();
        for (ToolkitModule<?> module : this.moduleInstances.values()) {
            module.registerShutdownHooks(serviceRegistry, this);
        }
        return new ToolkitImpl(serviceRegistry, Collections.unmodifiableList(this.shutdownHooks));
    }

    @Override
    public void addShutdownHook(Runnable shutdownHook) {
        this.shutdownHooks.add(shutdownHook);
    }

    private void registerModule(ToolkitModule<?> module) {
        this.objectGraph.setPublicInterfaceFilter(this.defaultClassFilter);
        module.registerMembers(this.objectGraph);
    }
}

