/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.discovery.internal;

import de.rcenvironment.core.configuration.discovery.bootstrap.DiscoveryBootstrapService;
import de.rcenvironment.core.configuration.discovery.bootstrap.DiscoveryClientSetup;
import de.rcenvironment.core.configuration.discovery.bootstrap.DiscoveryConfiguration;
import de.rcenvironment.core.configuration.discovery.bootstrap.DiscoveryServerSetup;
import de.rcenvironment.core.configuration.discovery.client.DiscoveryClientService;
import de.rcenvironment.core.configuration.discovery.server.DiscoveryServerManagementService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryBootstrapServiceImpl
implements DiscoveryBootstrapService {
    private static String symbolicBundleName;
    private DiscoveryClientService discoveryClientService;
    private DiscoveryServerManagementService discoveryServerManagementService;
    private final Log logger = LogFactory.getLog(this.getClass());

    public static void setSymbolicBundleName(String symbolicName) {
        symbolicBundleName = symbolicName;
    }

    @Override
    public String getSymbolicBundleName() {
        if (symbolicBundleName == null) {
            throw new NullPointerException();
        }
        return symbolicBundleName;
    }

    @Override
    public Map<String, String> initializeDiscovery(DiscoveryConfiguration configuration) {
        HashMap<String, String> receivedDiscoveryProperties = new HashMap<String, String>();
        DiscoveryServerSetup discoveryServerSetup = configuration.getRunDiscoveryServer();
        if (discoveryServerSetup != null) {
            this.startDiscoveryServer(discoveryServerSetup);
        } else {
            this.logger.info((Object)"Not running a discovery server as the relevant setting is empty");
        }
        DiscoveryClientSetup discoveryClientSetup = configuration.getUseDiscovery();
        if (discoveryClientSetup != null) {
            String reflectedClientAddress = this.getExternalHostAdressFromDiscovery(discoveryClientSetup);
            if (reflectedClientAddress != null) {
                receivedDiscoveryProperties.put("reflectedClientAddress", "\"" + reflectedClientAddress + "\"");
            } else {
                Map<String, String> fallbackProperties = discoveryClientSetup.getFallbackProperties();
                if (fallbackProperties.size() != 0) {
                    this.logger.info((Object)"Failed to determine external address from discovery server; using fallback properties");
                    receivedDiscoveryProperties.putAll(fallbackProperties);
                }
            }
        }
        return receivedDiscoveryProperties;
    }

    protected void bindDiscoveryClientService(DiscoveryClientService newService) {
        this.discoveryClientService = newService;
    }

    protected void bindDiscoveryServerManagementService(DiscoveryServerManagementService newService) {
        this.discoveryServerManagementService = newService;
    }

    private void startDiscoveryServer(DiscoveryServerSetup discoveryServerSetup) {
        try {
            this.discoveryServerManagementService.startServer(discoveryServerSetup.getBindAddress(), discoveryServerSetup.getPort());
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to start local discovery service", (Throwable)e);
        }
    }

    private String getExternalHostAdressFromDiscovery(DiscoveryClientSetup discoveryClientSetup) {
        List<DiscoveryClientSetup.ServerEntry> servers = discoveryClientSetup.getServers();
        if (servers.size() == 0) {
            return null;
        }
        if (servers.size() > 1) {
            this.logger.warn((Object)"There is more than one discovery server configured, but multi-host discovery is not implemented yet. Only the first server will be used.");
        }
        DiscoveryClientSetup.ServerEntry server = servers.get(0);
        try {
            String reflectedExternalAddress = this.discoveryClientService.getReflectedIpFromDiscoveryServer(server.getAddress(), server.getPort());
            this.logger.info((Object)("IP address as reported by discovery service: " + reflectedExternalAddress));
            return reflectedExternalAddress;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"External IP auto-detection failed", (Throwable)e);
            return null;
        }
    }
}

