/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationSshConnection;
import de.rcenvironment.core.instancemanagement.internal.DeploymentOperationsImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationOperationDescriptor;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationOperationSequenceImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationException;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsUtils;
import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.AbstractTextOutputReceiver;
import de.rcenvironment.core.utils.incubator.FileSystemOperations;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindrot.jbcrypt.BCrypt;

public class InstanceManagementServiceImpl
implements InstanceManagementService {
    private static final String INSTANCE_MANAGEMENT_DISABLED = "Local instance management is disabled due to missing or invalid configuration: ";
    private static final String ON_INSTANCE = " on instance ";
    private static final String ZIP = ".zip";
    private static final String SLASH = "/";
    private static final String TO = " to ";
    private static final String INDENT = "- ";
    private static final String TEMPLATES = "templates";
    private static final String VERSION = ".version";
    private static final Pattern VALID_IDS_REGEXP_PATTERN = Pattern.compile("[a-zA-Z0-9-_]+");
    private static final String GENERIC_PLACEHOLDER_STRING = "*";
    private static final String CONFIGURATION_SUBTREE_PATH = "instanceManagement";
    private static final String CONFIGURATION_FILENAME = "configuration.json";
    private static final int MAX_INSTALLATION_ROOT_PATH_LENGTH = 30;
    private static final String DATA_ROOT_DIRECTORY_PROPERTY = "dataRootDirectory";
    private static final String INSTALLATIONS_ROOT_DIR_PROPERTY = "installationsRootDirectory";
    private static final Map<String, InstanceConfigurationImpl> CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP = new HashMap<String, InstanceConfigurationImpl>();
    private static final String SUCCESS = " was successful.";
    private static final String TO_INSTANCE = " to instance ";
    private static final String OF_INSTANCE = " of instance ";
    private File dataRootDir;
    private File installationsRootDir;
    private File profilesRootDir;
    private File templatesRootDir;
    private File downloadsCacheDir;
    private volatile boolean hasValidLocalConfiguration = false;
    private volatile boolean hasValidDownloadConfiguration = false;
    private volatile boolean instanceManagementStarted = false;
    private String reasonInstanceManagementNotStarted = "";
    private ConcurrentHashMap<String, String> profileIdToInstallationIdMap = new ConcurrentHashMap();
    private ConfigurationService configurationService;
    private PersistentSettingsService persistentSettingsService;
    private final InstanceOperationsImpl instanceOperations = new InstanceOperationsImpl();
    private final DeploymentOperationsImpl deploymentOperations = new DeploymentOperationsImpl();
    private TempFileService tfs;
    private String downloadSourceFolderUrlPattern;
    private String downloadFilenamePattern;
    private final TextOutputReceiver fallbackUserOutputReceiver;
    private final Log log = LogFactory.getLog(this.getClass());

    public InstanceManagementServiceImpl() {
        this.fallbackUserOutputReceiver = new AbstractTextOutputReceiver(){

            public void addOutput(String line) {
                InstanceManagementServiceImpl.this.log.info((Object)"Operation progress: ");
            }
        };
    }

    public void activate() {
        this.tfs = TempFileServiceAccess.getInstance();
        this.hasValidLocalConfiguration = false;
        this.hasValidDownloadConfiguration = false;
        ConfigurationSegment configuration = this.configurationService.getConfigurationSegment(CONFIGURATION_SUBTREE_PATH);
        if (!configuration.isPresentInCurrentConfiguration()) {
            this.log.debug((Object)"No 'instanceManagement' configuration segment found, disabling instance management");
            this.reasonInstanceManagementNotStarted = "No 'instanceManagement' configuration segment found in configuration.json";
            return;
        }
        try {
            this.applyConfiguration(configuration);
            if (this.hasValidLocalConfiguration) {
                this.initProfileIdToInstallationMap();
                this.instanceManagementStarted = true;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Error while configuring " + this.getClass().getSimpleName()), (Throwable)e);
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
    }

    @Override
    public boolean isInstanceManagementStarted() {
        return this.instanceManagementStarted;
    }

    @Override
    public String getReasonInstanceManagementNotStarted() {
        return this.reasonInstanceManagementNotStarted;
    }

    public void deactivate() {
        this.hasValidLocalConfiguration = false;
        this.hasValidDownloadConfiguration = false;
    }

    @Override
    public void setupInstallationFromUrlQualifier(String installationId, String urlQualifier, InstanceManagementService.InstallationPolicy installationPolicy, TextOutputReceiver userOutputReceiver, long timeout) throws IOException {
        this.validateInstallationId(installationId);
        this.validateConfiguration(true, true);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        this.deploymentOperations.setUserOutputReceiver(userOutputReceiver);
        if (this.isInstallationRunning(installationId)) {
            throw new IOException("Cannot replace installation " + installationId + " because instances are currently running using this installation. Stop the " + "instannces or try the \"im reinstall\" command instead.");
        }
        switch (installationPolicy) {
            case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                this.forceDownloadAndReinstall(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            case FORCE_REINSTALL: {
                this.forceReinstall(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            case ONLY_INSTALL_IF_NOT_PRESENT: {
                this.installIfNotPresent(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            default: {
                throw new IOException("Not supported yet: " + (Object)((Object)installationPolicy));
            }
        }
    }

    @Override
    public void reinstallFromUrlQualifier(String installationId, String urlQualifier, InstanceManagementService.InstallationPolicy installationPolicy, TextOutputReceiver userOutputReceiver, long timeout) throws IOException {
        this.validateInstallationId(installationId);
        this.validateConfiguration(true, true);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        this.deploymentOperations.setUserOutputReceiver(userOutputReceiver);
        List<String> instancesForInstallation = this.getInstancesRunningInstallation(installationId);
        if (!instancesForInstallation.isEmpty()) {
            this.stopInstance(instancesForInstallation, userOutputReceiver, timeout);
        }
        switch (installationPolicy) {
            case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                this.forceDownloadAndReinstall(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            case FORCE_REINSTALL: {
                this.forceReinstall(installationId, urlQualifier, userOutputReceiver);
                break;
            }
            default: {
                throw new IOException("Not supported yet: " + (Object)((Object)installationPolicy));
            }
        }
        if (!instancesForInstallation.isEmpty()) {
            this.startInstance(installationId, instancesForInstallation, userOutputReceiver, timeout, false);
        }
    }

    @Override
    public boolean isSpecialInstallationId(String input) {
        return ":self".equals(input) || input.startsWith("local:");
    }

    @Override
    public InstanceConfigurationOperationSequence newConfigurationOperationSequence() {
        return new InstanceConfigurationOperationSequenceImpl();
    }

    @Override
    public void applyInstanceConfigurationOperations(String instanceId, InstanceConfigurationOperationSequence changeSequence, TextOutputReceiver userOutputReceiver) throws InstanceConfigurationException, IOException {
        this.validateConfiguration(true, false);
        File destinationConfigFile = this.resolveRelativePathWithinProfileDirectory(instanceId, CONFIGURATION_FILENAME);
        this.createProfileWithEmptyConfigFileIfNotPresent(destinationConfigFile);
        List<InstanceConfigurationOperationDescriptor> changeEntries = ((InstanceConfigurationOperationSequenceImpl)changeSequence).getConfigurationSteps();
        if (changeEntries.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one configuration step to perform");
        }
        InstanceConfigurationOperationDescriptor firstEntry = changeEntries.get(0);
        switch (firstEntry.getFlag()) {
            case "--reset": {
                this.writeEmptyConfigFile(destinationConfigFile);
                userOutputReceiver.addOutput("Clearing/resetting the configuration of instance " + instanceId);
                break;
            }
            case "--apply-template": {
                userOutputReceiver.addOutput("Replacing configuration of instance " + instanceId + " with template " + firstEntry.getSingleParameter());
                File template = this.resolveAndCheckTemplateDir(firstEntry.getSingleParameter() + SLASH + CONFIGURATION_FILENAME);
                Path src = template.toPath();
                Files.copy(src, destinationConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        this.applyChangeEntries(changeEntries, destinationConfigFile, instanceId, userOutputReceiver);
    }

    private void applyChangeEntries(List<InstanceConfigurationOperationDescriptor> changeEntries, File destinationConfigFile, String instanceId, TextOutputReceiver userOutputReceiver) throws InstanceConfigurationException {
        InstanceConfigurationImpl configOperations;
        if (CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(destinationConfigFile) == null) {
            configOperations = new InstanceConfigurationImpl(destinationConfigFile);
            CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.put(destinationConfigFile.getName(), configOperations);
        } else {
            configOperations = CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(destinationConfigFile.getName());
        }
        boolean isFirstCommand = true;
        for (InstanceConfigurationOperationDescriptor entry : changeEntries) {
            Object[] parameters = entry.getParameters();
            switch (entry.getFlag()) {
                case "--set-name": {
                    configOperations.setInstanceName((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Setting instance name of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-relay-option": {
                    if (!Boolean.TRUE.equals(entry.getSingleParameter()) && !Boolean.FALSE.equals(entry.getSingleParameter())) {
                        throw new InstanceConfigurationException("The parameter of the --set-relay-option sub-command must be a boolean value, but is a " + entry.getSingleParameter().getClass());
                    }
                    configOperations.setRelayFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("The relay flag of instance " + instanceId + " is set to " + entry.getSingleParameter());
                    break;
                }
                case "--set-comment": {
                    String entryString = (String)entry.getSingleParameter();
                    configOperations.setInstanceComment(entryString);
                    userOutputReceiver.addOutput("Setting comment field  of instance " + instanceId + TO + entryString);
                    break;
                }
                case "--add-connection": {
                    ConfigurationConnection connectionData = (ConfigurationConnection)entry.getSingleParameter();
                    configOperations.addConnection(connectionData);
                    userOutputReceiver.addOutput("Adding connection " + connectionData.getConnectionName() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-connection": {
                    configOperations.removeConnection((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removing connection " + entry.getSingleParameter() + " from instance " + instanceId);
                    break;
                }
                case "--add-server-port": {
                    if (parameters.length != 3) {
                        throw new IllegalArgumentException("Wrong number of parameters.");
                    }
                    String serverPortName = (String)parameters[0];
                    String serverPortIp = (String)parameters[1];
                    Integer serverPortNumber = (Integer)parameters[2];
                    configOperations.addServerPort(serverPortName, serverPortIp, serverPortNumber);
                    userOutputReceiver.addOutput("Adding server port " + serverPortName + TO_INSTANCE + instanceId + SUCCESS);
                    break;
                }
                case "--disable-ssh-server": {
                    configOperations.disableSshServer();
                    userOutputReceiver.addOutput("Disabling ssh server of instance " + instanceId);
                    break;
                }
                case "--set-workflow-host-option": {
                    configOperations.setWorkflowHostFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set workflow host flag of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-tempdir-path": {
                    configOperations.setTempDirectory((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Setting temp directory of instance " + instanceId);
                    break;
                }
                case "--enable-im-ssh-access": {
                    configOperations.enableImSshAccess((Integer)entry.getSingleParameter(), this.getHashedPassphrase());
                    userOutputReceiver.addOutput("Configuring ssh access for IM on instance" + instanceId);
                    break;
                }
                case "--configure-ssh-server": {
                    configOperations.enableSshServer();
                    configOperations.setSshServerIP((String)parameters[0]);
                    configOperations.setSshServerPort((Integer)parameters[1]);
                    break;
                }
                case "--set-ip-filter-option": {
                    configOperations.setIpFilterFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set ip filter flag of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--reset": 
                case "--apply-template": {
                    if (isFirstCommand) break;
                    throw new InstanceConfigurationException("Resetting the configuration or applying a template must take place *before* applying any other configuration commands");
                }
                case "--set-request-timeout": {
                    configOperations.setRequestTimeout((Long)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set request timeout of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-forwarding-timeout": {
                    configOperations.setForwardingTimeout((Long)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set forwarding timeout of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--add-allowed-inbound-ip": {
                    configOperations.addAllowedIp((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Added allowed IP " + entry.getSingleParameter() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-allowed-inbound-ip": {
                    configOperations.removeAllowedIp((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removed allowed IP " + entry.getSingleParameter() + " from " + instanceId);
                    break;
                }
                case "--add-ssh-connection": {
                    ConfigurationSshConnection sshConnectionData = (ConfigurationSshConnection)entry.getSingleParameter();
                    configOperations.addSshConnection(sshConnectionData);
                    userOutputReceiver.addOutput("Adding SSH connection " + sshConnectionData.getName() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-ssh-connection": {
                    configOperations.removeSshConnection((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removing SSH connection " + entry.getSingleParameter() + " from instance " + instanceId);
                    break;
                }
                case "--publish-component": {
                    configOperations.publishComponent((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Published component " + entry.getSingleParameter() + ON_INSTANCE + instanceId);
                    break;
                }
                case "--unpublish-component": {
                    configOperations.unPublishComponent((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Unpublished component " + entry.getSingleParameter() + ON_INSTANCE + instanceId);
                    break;
                }
                case "--set-background-monitoring": {
                    String id = (String)entry.getParameters()[0];
                    int interval = (Integer)entry.getParameters()[1];
                    configOperations.setBackgroundMonitoring(id, interval);
                    userOutputReceiver.addOutput("Setting background monitoring interval for instance" + instanceId + TO + interval);
                    break;
                }
                default: {
                    throw new InstanceConfigurationException("Unhandled configuration change request: " + entry.getFlag());
                }
            }
            isFirstCommand = false;
        }
        configOperations.update();
        userOutputReceiver.addOutput("Updated the configuration file of instance " + instanceId);
    }

    private void createProfileWithEmptyConfigFileIfNotPresent(File config) throws IOException {
        if (!config.exists()) {
            config.getParentFile().mkdir();
            this.writeEmptyConfigFile(config);
        }
    }

    private void writeEmptyConfigFile(File config) throws FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter(config);){
            writer.println("{");
            writer.println("}");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getHashedPassphrase() {
        String passphrase = this.persistentSettingsService.readStringValue("im_master_passphrase");
        if (passphrase == null) {
            passphrase = RandomStringUtils.randomAlphanumeric((int)10);
            this.persistentSettingsService.saveStringValue("im_master_passphrase", passphrase);
        }
        return BCrypt.hashpw((String)passphrase, (String)BCrypt.gensalt((int)10));
    }

    @Override
    public File resolveRelativePathWithinProfileDirectory(String instanceId, String relativePath) {
        return new File(new File(this.profilesRootDir, instanceId).getAbsoluteFile(), relativePath);
    }

    @Override
    public void startInstance(String installationId, List<String> instanceIdList, TextOutputReceiver userOutputReceiver, long timeout, boolean startWithGui) throws InstanceOperationException, IOException {
        File installationDir;
        instanceIdList = new ArrayList<String>(instanceIdList);
        if (installationId == null || instanceIdList == null || installationId.isEmpty() || instanceIdList.isEmpty()) {
            throw new IOException("Malformed command: either no installation id or instance id defined.");
        }
        if (":self".equals(installationId)) {
            installationDir = new File(this.getIMMasterInstallationPathAsInstallationId());
        } else if (installationId.startsWith("local:")) {
            installationDir = new File(installationId.substring("local:".length()));
        } else {
            File possibleInstallation = new File(this.installationsRootDir + SLASH + installationId);
            if (!possibleInstallation.exists()) {
                throw new IOException("Installation with id: " + installationId + " does not exist");
            }
            this.validateInstallationId(installationId);
            installationDir = this.resolveAndCheckInstallationDir(installationId);
        }
        if (!installationDir.isDirectory()) {
            throw new IOException("Resolved the given installation id to directory \"" + installationDir.getAbsolutePath() + "\", but it does not exist");
        }
        this.validateInstanceId(instanceIdList, false);
        this.validateConfiguration(true, false);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        for (String s : new ArrayList<String>(instanceIdList)) {
            if (!this.isInstanceRunning(s)) continue;
            instanceIdList.remove(s);
            userOutputReceiver.addOutput("Profile with id: " + s + " is already running.");
        }
        List<File> profileDirList = this.resolveAndCheckProfileDirList(instanceIdList);
        this.writeInstallationIdToFile(installationId, profileDirList, userOutputReceiver);
        try {
            this.instanceOperations.startInstanceUsingInstallation(profileDirList, installationDir, timeout, userOutputReceiver, startWithGui);
        }
        catch (InstanceOperationException e) {
            throw new IOException("An error occured on the startup process of some instances. Aborted with message: " + e.getMessage());
        }
        this.addInstanceToMap(instanceIdList, installationId);
    }

    @Override
    public void stopInstance(List<String> instanceIdList, TextOutputReceiver userOutputReceiver, long timeout) throws InstanceOperationException, IOException {
        if (instanceIdList == null || instanceIdList.isEmpty()) {
            userOutputReceiver.addOutput("No instance to stop defined.. aborting.");
            return;
        }
        instanceIdList = new ArrayList<String>(instanceIdList);
        this.validateInstanceId(instanceIdList, true);
        this.validateConfiguration(true, false);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        List<File> profileDirList = this.resolveAndCheckProfileDirList(instanceIdList);
        for (File profile : new ArrayList<File>(profileDirList)) {
            if (this.isInstanceRunning(profile.getName())) continue;
            userOutputReceiver.addOutput("Instance with id: " + profile.getName() + " is currently not running.");
            profileDirList.remove(profile);
        }
        if (profileDirList.isEmpty()) {
            return;
        }
        try {
            try {
                this.instanceOperations.shutdownInstance(profileDirList, timeout, userOutputReceiver);
            }
            catch (IOException e) {
                this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, e);
                this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, null);
                this.removeInstanceTopMap(instanceIdList);
                this.removeInstallationFileIfProfileIsNotRunning(this.resolveAndCheckProfileDirList(instanceIdList));
            }
        }
        finally {
            this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, null);
            this.removeInstanceTopMap(instanceIdList);
            this.removeInstallationFileIfProfileIsNotRunning(this.resolveAndCheckProfileDirList(instanceIdList));
        }
    }

    private void removeInstallationFileIfProfileIsNotRunning(List<File> profileDirList) throws IOException {
        for (File profile : profileDirList) {
            if (this.isInstanceRunning(profile.getName()) || !profile.isDirectory()) continue;
            File[] fileArray = profile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean success;
                File file = fileArray[n2];
                if (file.getName().equals("installation") && !(success = file.delete())) {
                    throw new IOException("Failed to delete installation id.");
                }
                ++n2;
            }
        }
    }

    private void checkAndRemoveInstanceLock(List<File> profileDirList, List<String> instanceIdList, IOException e) throws IOException {
        for (File profile : new ArrayList<File>(profileDirList)) {
            if (this.isInstanceRunning(profile.getName())) continue;
            profileDirList.remove(profile);
            if (!profile.isDirectory()) continue;
            File[] fileArray = profile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals("instance.lock")) {
                    boolean success = file.delete();
                    if (e != null && !success) {
                        throw new IOException("Failed to delete instance.lock file.", e);
                    }
                    if (!success) {
                        throw new IOException("Failed to delete instance.lock file.");
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isInstanceRunning(String instanceId) throws IOException {
        this.validateConfiguration(true, false);
        File profileDir = this.resolveAndCheckProfileDir(instanceId);
        return InstanceOperationsUtils.isProfileLocked(profileDir);
    }

    private boolean isInstallationRunning(String installationId) throws IOException {
        for (Map.Entry<String, String> entry : this.profileIdToInstallationIdMap.entrySet()) {
            if (!entry.getValue().equals(installationId) || !this.isInstanceRunning(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private List<String> getInstancesRunningInstallation(String installationId) throws IOException {
        ArrayList<String> instances = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.profileIdToInstallationIdMap.entrySet()) {
            if (!entry.getValue().equals(installationId) || !this.isInstanceRunning(entry.getKey())) continue;
            instances.add(entry.getKey());
        }
        return instances;
    }

    protected void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    protected void bindPersistentSettingsService(PersistentSettingsService newService) {
        this.persistentSettingsService = newService;
    }

    @Override
    public void listInstanceManagementInformation(String scope, TextOutputReceiver userOutputReceiver) throws IOException {
        if ("all".equals(scope)) {
            this.listInstances(userOutputReceiver);
            this.listInstallations(userOutputReceiver);
            this.listTemplates(userOutputReceiver);
        } else if ("instances".equals(scope)) {
            this.listInstances(userOutputReceiver);
        } else if ("installations".equals(scope)) {
            this.listInstallations(userOutputReceiver);
        } else if (TEMPLATES.equals(scope)) {
            this.listTemplates(userOutputReceiver);
        }
    }

    @Override
    public void disposeInstance(String instanceId, TextOutputReceiver outputReceiver) throws IOException {
        if (this.profilesRootDir == null) {
            throw new IOException("Failed to dispose instance. Instances' root directory not defined.");
        }
        File[] fileArray = this.profilesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File instanceFile = fileArray[n2];
            if (instanceFile.isDirectory() && instanceId.equals(instanceFile.getName())) {
                File[] fileArray2 = instanceFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileInInstanceFolder = fileArray2[n4];
                    if (fileInInstanceFolder.getName().equals("instance.lock")) {
                        throw new IOException("Instance with ID " + instanceId + " currently in use. " + "To stop it use 'im stop " + instanceId + "'.");
                    }
                    ++n4;
                }
                FileSystemOperations.deleteSandboxDirectory((File)instanceFile);
                return;
            }
            ++n2;
        }
        throw new IOException("Instance with ID " + instanceId + " not found.");
    }

    @Override
    public void showInstanceManagementInformation(TextOutputReceiver outputReceiver) {
        if (this.profilesRootDir != null) {
            outputReceiver.addOutput("Instances' root directory: " + this.profilesRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Instances' root directory not defined.");
        }
        if (this.installationsRootDir != null) {
            outputReceiver.addOutput("Installations' root directory: " + this.installationsRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Installations' root directory not defined.");
        }
        if (this.templatesRootDir != null) {
            outputReceiver.addOutput("Templates' root directory: " + this.templatesRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Templates' root directory not defined.");
        }
        if (this.dataRootDir != null) {
            outputReceiver.addOutput("Data root directory: " + this.dataRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Data root directory not defined.");
        }
        if (this.downloadsCacheDir != null) {
            outputReceiver.addOutput("Download cache directory: " + this.downloadsCacheDir.getAbsolutePath());
            if (this.downloadsCacheDir.listFiles().length > 0) {
                outputReceiver.addOutput("Downloads cached: ");
                File[] fileArray = this.downloadsCacheDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File cachedDownloadFile = fileArray[n2];
                    outputReceiver.addOutput(INDENT + cachedDownloadFile.getName().replace(ZIP, ""));
                    ++n2;
                }
            } else {
                outputReceiver.addOutput("No download cached.");
            }
        } else {
            outputReceiver.addOutput("Download cache directory not defined.");
        }
    }

    @Override
    public void startAllInstances(String installationId, TextOutputReceiver userOutputReceiver, long timeout) throws InstanceOperationException, IOException {
        ArrayList<String> instanceIdList = new ArrayList<String>();
        try {
            this.addProfiles(this.profilesRootDir.toPath(), instanceIdList);
        }
        catch (IOException e) {
            throw new InstanceOperationException("Failed to add profile. Aborted with message: " + e.getMessage());
        }
        this.startInstance(installationId, instanceIdList, userOutputReceiver, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllInstances(String installationId, TextOutputReceiver userOutputReceiver, long timeout) throws InstanceOperationException, IOException {
        ArrayList<String> instanceIdList = new ArrayList<String>();
        if (!installationId.isEmpty()) {
            ConcurrentHashMap<String, String> concurrentHashMap = this.profileIdToInstallationIdMap;
            synchronized (concurrentHashMap) {
                for (Map.Entry<String, String> entry : this.profileIdToInstallationIdMap.entrySet()) {
                    if (!entry.getValue().equals(installationId)) continue;
                    instanceIdList.add(entry.getKey());
                }
            }
        }
        try {
            this.addProfiles(this.profilesRootDir.toPath(), instanceIdList);
        }
        catch (IOException e) {
            throw new InstanceOperationException("Failed to add profile. Aborted with message: " + e.getMessage());
        }
        this.stopInstance(instanceIdList, userOutputReceiver, timeout);
    }

    protected File getProfilesRootDir() {
        return this.profilesRootDir;
    }

    protected void setProfilesRootDir(File file) {
        this.profilesRootDir = file;
    }

    protected void validateLocalConfig() {
        this.hasValidLocalConfiguration = true;
    }

    protected String fetchVersionInformationFromDownloadSourceFolder(String urlQualifier) throws IOException {
        this.validateConfiguration(false, true);
        File tempVersionFile = this.tfs.createTempFileFromPattern("versionfile-*.tmp");
        String versionFileUrl = String.valueOf(this.downloadSourceFolderUrlPattern.replace(GENERIC_PLACEHOLDER_STRING, urlQualifier)) + "VERSION";
        this.log.debug((Object)("Fetching remote version information from " + versionFileUrl));
        this.deploymentOperations.downloadFile(versionFileUrl, tempVersionFile, true, false);
        return FileUtils.readFileToString((File)tempVersionFile).trim();
    }

    protected void downloadInstallationPackage(String urlQualifier, String version, File localFile) throws IOException {
        this.validateConfiguration(false, true);
        String remoteFileUrl = String.valueOf(this.downloadSourceFolderUrlPattern.replace(GENERIC_PLACEHOLDER_STRING, urlQualifier)) + this.downloadFilenamePattern.replace(GENERIC_PLACEHOLDER_STRING, version);
        this.log.debug((Object)("Downloading installation package from '" + remoteFileUrl + "' to local file '" + localFile.getAbsolutePath() + "'"));
        this.deploymentOperations.downloadFile(remoteFileUrl, localFile, true, true);
    }

    private void applyConfiguration(ConfigurationSegment configuration) throws IOException {
        try {
            this.hasValidLocalConfiguration = false;
            this.dataRootDir = this.getConfiguredDirectory(configuration, DATA_ROOT_DIRECTORY_PROPERTY);
            this.installationsRootDir = this.getConfiguredDirectory(configuration, INSTALLATIONS_ROOT_DIR_PROPERTY);
            if (this.dataRootDir == null || this.installationsRootDir == null) {
                throw new IOException("Data or installation root directory (or both) unspecified");
            }
            this.templatesRootDir = new File(this.dataRootDir, TEMPLATES);
            this.profilesRootDir = new File(this.dataRootDir, "profiles");
            this.downloadsCacheDir = new File(this.dataRootDir, "downloads");
            if (this.installationsRootDir.equals(this.templatesRootDir) || this.installationsRootDir.equals(this.profilesRootDir) || this.templatesRootDir.equals(this.profilesRootDir)) {
                throw new IOException("Two or more configured directory are equal, but they must be unique");
            }
            if (this.installationsRootDir.getPath().length() > 30) {
                throw new IOException("Installation root path is too long: " + this.installationsRootDir.getPath());
            }
            this.prepareAndValidateDirectory(DATA_ROOT_DIRECTORY_PROPERTY, this.dataRootDir);
            this.prepareAndValidateDirectory(INSTALLATIONS_ROOT_DIR_PROPERTY, this.installationsRootDir);
            this.prepareAndValidateDirectory(TEMPLATES, this.templatesRootDir);
            this.prepareAndValidateDirectory("profiles", this.profilesRootDir);
            this.prepareAndValidateDirectory("downloads", this.downloadsCacheDir);
            this.hasValidLocalConfiguration = true;
        }
        catch (IOException e) {
            this.log.error((Object)("Disabling local instance management due to missing or invalid configuration: " + e.getMessage()));
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
        this.downloadSourceFolderUrlPattern = configuration.getString("downloadSourceFolderUrlPattern", "");
        if (this.downloadSourceFolderUrlPattern.length() > 0 && !this.downloadSourceFolderUrlPattern.endsWith(SLASH)) {
            this.downloadSourceFolderUrlPattern = String.valueOf(this.downloadSourceFolderUrlPattern) + SLASH;
        }
        this.downloadFilenamePattern = configuration.getString("downloadFilenamePattern", "");
        try {
            this.hasValidDownloadConfiguration = false;
            if (this.downloadSourceFolderUrlPattern.isEmpty()) {
                throw new IOException("Parameter 'downloadSourceFolderUrlPattern' has not been defined, but is required");
            }
            if (this.downloadFilenamePattern.isEmpty()) {
                throw new IOException("Parameter 'downloadFilenamePattern' has not been defined, but is required");
            }
            this.hasValidDownloadConfiguration = true;
        }
        catch (IOException e) {
            this.log.error((Object)("Error in instance management download configuration: " + e.getMessage()));
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
    }

    private File forceFetchingProductZip(String urlQualifier, String remoteVersion) throws IOException {
        File downloadFile = new File(this.downloadsCacheDir, String.valueOf(remoteVersion) + ZIP);
        int i = 1;
        while (downloadFile.exists()) {
            String newFilePath = String.valueOf(downloadFile.getAbsolutePath().replace(downloadFile.getName(), "")) + remoteVersion + "(" + i++ + ")" + ZIP;
            downloadFile = new File(newFilePath);
        }
        this.downloadInstallationPackage(urlQualifier, remoteVersion, downloadFile);
        return downloadFile;
    }

    private String fetchVersionInformation(TextOutputReceiver userOutputReceiver, String urlQualifier) throws IOException {
        userOutputReceiver.addOutput("Fetching remote version information");
        return this.fetchVersionInformationFromDownloadSourceFolder(urlQualifier);
    }

    private File fetchProductZipIfNecessary(String urlQualifier, String remoteVersion) throws IOException {
        File downloadFile = new File(this.downloadsCacheDir, String.valueOf(remoteVersion) + ZIP);
        if (downloadFile.exists()) {
            this.log.info((Object)("Version " + remoteVersion + " is already present in downloads cache, not downloading"));
        } else {
            this.downloadInstallationPackage(urlQualifier, remoteVersion, downloadFile);
        }
        return downloadFile;
    }

    private void forceDownloadAndReinstall(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver) throws IOException {
        String version = this.fetchVersionInformation(userOutputReceiver, urlQualifier);
        this.reinstall(installationId, version, urlQualifier, userOutputReceiver, true);
    }

    private void forceReinstall(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver) throws IOException {
        String version = this.fetchVersionInformation(userOutputReceiver, urlQualifier);
        this.log.info((Object)StringUtils.format((String)"Identified version of remote installation package '%s': %s", (Object[])new Object[]{urlQualifier, version}));
        this.reinstall(installationId, version, urlQualifier, userOutputReceiver, false);
    }

    private void installIfNotPresent(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver) throws IOException {
        File installationDir = new File(this.installationsRootDir, installationId);
        if (installationDir.exists()) {
            userOutputReceiver.addOutput("Installation with ID " + installationId + " already exists.");
        } else {
            this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver);
        }
    }

    private void installIfVersionIsDifferent(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver) throws IOException {
        String newVersion = this.fetchVersionInformation(userOutputReceiver, urlQualifier);
        this.log.info((Object)StringUtils.format((String)"Identified version of remote installation package '%s': %s", (Object[])new Object[]{urlQualifier, newVersion}));
        String oldVersion = this.getVersionOfInstallation(installationId);
        if (newVersion.isEmpty()) {
            throw new IOException("Unable to find new version");
        }
        if (newVersion.equals(oldVersion)) {
            userOutputReceiver.addOutput("Remote and installed version are the same; no change required");
            return;
        }
        this.reinstall(installationId, newVersion, urlQualifier, userOutputReceiver, false);
    }

    private void reinstall(String installationId, String version, String urlQualifier, TextOutputReceiver userOutputReceiver, boolean force) throws IOException {
        File zipFile;
        if (force) {
            this.log.info((Object)"Reinstalling with 'force new download' option set");
            zipFile = this.forceFetchingProductZip(urlQualifier, version);
        } else {
            zipFile = this.fetchProductZipIfNecessary(urlQualifier, version);
        }
        File installationDir = new File(this.installationsRootDir, installationId);
        if (installationDir.exists()) {
            userOutputReceiver.addOutput("Deleting old installation " + installationId);
            this.deploymentOperations.deleteInstallation(installationDir);
        }
        userOutputReceiver.addOutput("Setting up new installation " + installationId);
        this.deploymentOperations.installFromProductZip(zipFile, installationDir);
        this.log.debug((Object)("Writing version information for installation " + installationId));
        this.storeVersionOfInstallation(installationId, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listInstances(TextOutputReceiver userOutputReceiver) {
        if (this.profilesRootDir == null) {
            userOutputReceiver.addOutput("Instances' root directory not defined.");
            return;
        }
        if (this.profilesRootDir.listFiles().length == 0) {
            userOutputReceiver.addOutput("No instances found.");
            return;
        }
        userOutputReceiver.addOutput("Instances: ");
        File[] fileArray = this.profilesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File instanceFile = fileArray[n2];
            if (instanceFile.isDirectory()) {
                String runningState = "Not running";
                File[] fileArray2 = instanceFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileInProfile = fileArray2[n4];
                    ConcurrentHashMap<String, String> concurrentHashMap = this.profileIdToInstallationIdMap;
                    synchronized (concurrentHashMap) {
                        if (fileInProfile.isFile() && fileInProfile.getName().equals("instance.lock")) {
                            runningState = "Running (" + this.profileIdToInstallationIdMap.get(instanceFile.getName()) + ")";
                        }
                    }
                    ++n4;
                }
                userOutputReceiver.addOutput(INDENT + instanceFile.getName() + " (" + runningState + ")");
            }
            ++n2;
        }
    }

    private void listInstallations(TextOutputReceiver userOutputReceiver) throws IOException {
        if (this.installationsRootDir == null) {
            userOutputReceiver.addOutput("Installations' root directory not defined.");
            return;
        }
        if (this.installationsRootDir.listFiles().length == 0) {
            userOutputReceiver.addOutput("No installations found.");
            return;
        }
        userOutputReceiver.addOutput("Installations: ");
        File[] fileArray = this.installationsRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File installationFile = fileArray[n2];
            if (installationFile.isFile() && installationFile.getName().endsWith(VERSION)) {
                String installationsId = installationFile.getName().replace(VERSION, "");
                String version = FileUtils.readFileToString((File)installationFile);
                userOutputReceiver.addOutput(INDENT + installationsId + " (" + version + ")");
            }
            ++n2;
        }
    }

    private void listTemplates(TextOutputReceiver userOutputReceiver) {
        if (this.templatesRootDir == null) {
            userOutputReceiver.addOutput("Templates' root directory not defined.");
            return;
        }
        if (this.templatesRootDir.listFiles().length == 0) {
            userOutputReceiver.addOutput("No templates found.");
            return;
        }
        userOutputReceiver.addOutput("Templates: ");
        File[] fileArray = this.templatesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File templateFile = fileArray[n2];
            if (templateFile.isDirectory()) {
                userOutputReceiver.addOutput(INDENT + templateFile.getName());
            }
            ++n2;
        }
    }

    private String getVersionOfInstallation(String installationId) throws IOException {
        File installationVersionFile = new File(this.installationsRootDir, String.valueOf(installationId) + VERSION);
        String oldVersion = installationVersionFile.exists() ? FileUtils.readFileToString((File)installationVersionFile) : "";
        return oldVersion;
    }

    private void storeVersionOfInstallation(String installationId, String versionString) throws IOException {
        File installationVersionFile = new File(this.installationsRootDir, String.valueOf(installationId) + VERSION);
        FileUtils.writeStringToFile((File)installationVersionFile, (String)versionString);
    }

    private List<File> resolveAndCheckProfileDirList(List<String> instanceIdList) throws IOException {
        ArrayList<File> dirList = new ArrayList<File>();
        for (String instanceId : instanceIdList) {
            dirList.add(this.resolveAndCheckProfileDir(instanceId));
        }
        return dirList;
    }

    private File resolveAndCheckInstallationDir(String installationId) throws IOException {
        File installationDir = new File(this.installationsRootDir, installationId);
        if (!installationDir.exists()) {
            throw new IOException("The installation directory " + installationId + " does not exist.");
        }
        this.prepareAndValidateDirectory("installation " + installationId, installationDir);
        return installationDir;
    }

    private File resolveAndCheckProfileDir(String instanceId) throws IOException {
        File profileDir = new File(this.profilesRootDir, instanceId);
        this.prepareAndValidateDirectory("instance " + instanceId, profileDir);
        return profileDir;
    }

    private File resolveAndCheckTemplateDir(String templateId) throws IOException {
        File templateDir = new File(this.templatesRootDir, templateId);
        return templateDir;
    }

    private void prepareAndValidateDirectory(String id, File dir) throws IOException {
        dir.mkdirs();
        String absolutePath = dir.getAbsolutePath();
        if (!dir.isDirectory()) {
            throw new IOException("The configured path '" + id + "' ('" + absolutePath + "') could not be created");
        }
        if (absolutePath.contains("\"")) {
            throw new IOException("The directory path '" + absolutePath + "' contains illegal characters");
        }
        this.log.debug((Object)("Final path for id '" + id + "' " + absolutePath));
    }

    private TextOutputReceiver ensureUserOutputReceiverDefined(TextOutputReceiver userOutputReceiver) {
        if (userOutputReceiver != null) {
            return userOutputReceiver;
        }
        return this.fallbackUserOutputReceiver;
    }

    private void validateConfiguration(boolean validateLocalConfig, boolean validateDownloadConfig) throws IOException {
        if (validateLocalConfig && !this.hasValidLocalConfiguration) {
            throw new IOException("The instance management service is disabled or has no valid local configuration - cannot execute the requested operation");
        }
        if (validateDownloadConfig && !this.hasValidDownloadConfiguration) {
            throw new IOException("The instance management service is disabled or has no valid download configuration - cannot execute the requested operation");
        }
    }

    private <T> boolean isUnique(Collection<T> idList) {
        LinkedHashSet<T> duplicateIdList = new LinkedHashSet<T>();
        HashSet<T> uniqueIdList = new HashSet<T>();
        for (T t : idList) {
            if (uniqueIdList.add(t)) continue;
            duplicateIdList.add(t);
        }
        return duplicateIdList.isEmpty();
    }

    private boolean isIdValid(String id) {
        return VALID_IDS_REGEXP_PATTERN.matcher(id).matches();
    }

    private boolean isProfilePresent(String id) {
        File possibleProfile = new File(this.profilesRootDir + SLASH + id);
        return possibleProfile.exists();
    }

    private void validateInstallationId(String id) throws IOException {
        if (!this.isIdValid(id)) {
            throw new IOException("Malformed id: " + id);
        }
    }

    private void validateInstanceId(List<String> idList, boolean forShutdown) throws IOException {
        if (!this.isUnique(idList)) {
            throw new IOException("Malformed command: multiple instances with identical id");
        }
        for (String id : idList) {
            if (!this.isIdValid(id)) {
                throw new IOException("Malformed id: " + id);
            }
            if (!forShutdown || this.isProfilePresent(id)) continue;
            throw new IOException("Malformed command: tried to shutdown instance, which doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProfileIdToInstallationMap() throws IOException {
        File[] fileArray = this.profilesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File instanceFile = fileArray[n2];
            if (instanceFile.isDirectory()) {
                File[] fileArray2 = instanceFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileInProfile = fileArray2[n4];
                    if (fileInProfile.getName().equals("installation")) {
                        Throwable throwable = null;
                        Object var10_11 = null;
                        try (BufferedReader br = new BufferedReader(new FileReader(fileInProfile));){
                            ConcurrentHashMap<String, String> concurrentHashMap = this.profileIdToInstallationIdMap;
                            synchronized (concurrentHashMap) {
                                this.profileIdToInstallationIdMap.put(instanceFile.getName(), br.readLine());
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstanceToMap(List<String> instanceIds, String installationId) {
        for (String instanceId : instanceIds) {
            ConcurrentHashMap<String, String> concurrentHashMap = this.profileIdToInstallationIdMap;
            synchronized (concurrentHashMap) {
                this.profileIdToInstallationIdMap.put(instanceId, installationId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstanceTopMap(List<String> instanceIds) throws IOException {
        Iterator<String> iterator = instanceIds.iterator();
        while (iterator.hasNext()) {
            ConcurrentHashMap<String, String> concurrentHashMap = this.profileIdToInstallationIdMap;
            synchronized (concurrentHashMap) {
                if (this.profileIdToInstallationIdMap.remove(iterator.next()) == null) {
                    iterator.remove();
                }
            }
        }
    }

    private void addProfiles(Path directory, Collection<String> all) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
            for (Path child : ds) {
                all.add(child.getFileName().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File getConfiguredDirectory(ConfigurationSegment configuration, String id) throws IOException {
        String configuredPath = configuration.getString(id);
        this.log.debug((Object)("Configuration value for property '" + id + "': " + configuredPath));
        if (configuredPath != null) {
            return new File(configuredPath).getAbsoluteFile();
        }
        return null;
    }

    private void writeInstallationIdToFile(String installationId, List<File> profileDirList, TextOutputReceiver userOutputReceiver) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        for (File profile : profileDirList) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(profile.getAbsolutePath()) + SLASH + "installation"), "utf-8"));){
                writer.write(installationId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCommandOnInstance(String instanceId, String command, TextOutputReceiver userOutputReceiver) throws JSchException, SshParameterException, IOException, InterruptedException {
        Objects.requireNonNull(instanceId);
        if (!this.isInstanceRunning(instanceId)) {
            userOutputReceiver.addOutput("Cannot execute command on instance " + instanceId + " because it is not running.");
            return;
        }
        Logger logger = JschSessionFactory.createDelegateLogger((Log)this.log);
        Integer port = null;
        try {
            port = this.getSshPortForInstance(instanceId);
        }
        catch (InstanceConfigurationException e) {
            throw new IOException((Throwable)((Object)e));
        }
        String ip = null;
        try {
            ip = this.getSshIpForInstance(instanceId);
        }
        catch (InstanceConfigurationException e) {
            throw new IOException((Throwable)((Object)e));
        }
        String passphrase = this.persistentSettingsService.readStringValue("im_master_passphrase");
        if (passphrase != null && port != null && ip != null) {
            Session session;
            block19: {
                session = JschSessionFactory.setupSession((String)ip, (int)port, (String)"im_master", null, (String)passphrase, (Logger)logger);
                JSchRCECommandLineExecutor rceExecutor = new JSchRCECommandLineExecutor(session);
                rceExecutor.start(command);
                Throwable throwable = null;
                Object var11_14 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            TextStreamWatcher stdoutWatcher = TextStreamWatcherFactory.create((InputStream)stdoutStream, (TextOutputReceiver[])new TextOutputReceiver[]{userOutputReceiver});
                            TextStreamWatcher stderrWatcher = TextStreamWatcherFactory.create((InputStream)stderrStream, (TextOutputReceiver[])new TextOutputReceiver[]{userOutputReceiver});
                            stdoutWatcher.start();
                            stderrWatcher.start();
                            rceExecutor.waitForTermination();
                            stdoutWatcher.waitForTermination();
                            stderrWatcher.waitForTermination();
                        }
                        if (stdoutStream == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            session.disconnect();
            userOutputReceiver.addOutput("Finished executing command " + command + ON_INSTANCE + instanceId);
            return;
        }
        userOutputReceiver.addOutput("Could not retrieve password and/or port for instance " + instanceId + ".");
    }

    private Integer getSshPortForInstance(String instanceId) throws IOException, InstanceConfigurationException {
        File config = this.resolveRelativePathWithinProfileDirectory(instanceId, CONFIGURATION_FILENAME);
        if (!config.exists()) {
            this.log.warn((Object)("No config file for instance " + instanceId + " exists."));
            return null;
        }
        InstanceConfigurationImpl configOperations = CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(config) == null ? new InstanceConfigurationImpl(config) : CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(config.getName());
        return configOperations.getSshServerPort();
    }

    private String getSshIpForInstance(String instanceId) throws InstanceConfigurationException {
        File config = this.resolveRelativePathWithinProfileDirectory(instanceId, CONFIGURATION_FILENAME);
        if (!config.exists()) {
            this.log.warn((Object)("No config file for instance " + instanceId + " exists."));
            return null;
        }
        InstanceConfigurationImpl configOperations = CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(config) == null ? new InstanceConfigurationImpl(config) : CONFIG_FILE_NAME_TO_CONFIG_STORE_MAP.get(config.getName());
        return configOperations.getSshServerIp();
    }

    private String getIMMasterInstallationPathAsInstallationId() throws IOException {
        String runningIMInstallationPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        runningIMInstallationPath = runningIMInstallationPath.substring(0, runningIMInstallationPath.lastIndexOf(SLASH));
        runningIMInstallationPath = runningIMInstallationPath.substring(0, runningIMInstallationPath.lastIndexOf(SLASH));
        try {
            runningIMInstallationPath = URLDecoder.decode(runningIMInstallationPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("Failed to decode installation path");
        }
        if (runningIMInstallationPath == null || runningIMInstallationPath.isEmpty()) {
            throw new IOException("Installation path of IM master instance is either null or empty");
        }
        return runningIMInstallationPath;
    }
}

