/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;

public class ComponentInstallationBuilder {
    private final ComponentInstallationImpl componentInstallation = new ComponentInstallationImpl();

    public static ComponentInstallationBuilder fromComponentInstallation(ComponentInstallation templateComponentInstallation) {
        ComponentInstallationBuilder componentInstallationBuilder = new ComponentInstallationBuilder();
        componentInstallationBuilder.setInstallationId(templateComponentInstallation.getInstallationId());
        componentInstallationBuilder.setComponentRevision((ComponentRevisionImpl)templateComponentInstallation.getComponentRevision());
        componentInstallationBuilder.setIsPublished(templateComponentInstallation.getIsPublished());
        componentInstallationBuilder.setMaximumCountOfParallelInstances(templateComponentInstallation.getMaximumCountOfParallelInstances());
        componentInstallationBuilder.setNodeId(NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)templateComponentInstallation.getNodeId()));
        return componentInstallationBuilder;
    }

    public ComponentInstallationBuilder setInstallationId(String installationId) {
        this.componentInstallation.setInstallationId(installationId);
        return this;
    }

    public ComponentInstallationBuilder setComponentRevision(ComponentRevision componentRevision) {
        this.componentInstallation.setComponentRevision((ComponentRevisionImpl)componentRevision);
        return this;
    }

    public ComponentInstallationBuilder setNodeId(LogicalNodeId nodeId) {
        if (nodeId != null) {
            this.componentInstallation.setNodeIdFromObject(nodeId);
        } else {
            this.componentInstallation.setNodeId(null);
        }
        return this;
    }

    public ComponentInstallationBuilder setMaximumCountOfParallelInstances(Integer maximumCountOfParallelInstances) {
        this.componentInstallation.setMaximumCountOfParallelInstances(maximumCountOfParallelInstances);
        return this;
    }

    public ComponentInstallationBuilder setIsPublished(boolean isPublished) {
        this.componentInstallation.setIsPublished(isPublished);
        return this;
    }

    public ComponentInstallation build() {
        return this.componentInstallation;
    }
}

