/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.datamanagement.DataManagementIdMapping;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;

public class ComponentExecutionStorageBridge {
    private static MetaDataService metaDataService;
    private final ComponentExecutionRelatedInstances compExeRelatedInstances;
    private final String errorMessageSuffix;
    private final int timestampOffset;
    private Long compExeDmId;
    private EndpointCountMap inputCount = new EndpointCountMap();
    private EndpointCountMap outputCount = new EndpointCountMap();

    @Deprecated
    public ComponentExecutionStorageBridge() {
        this.compExeRelatedInstances = null;
        this.timestampOffset = 0;
        this.errorMessageSuffix = null;
    }

    public ComponentExecutionStorageBridge(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        this.compExeRelatedInstances = compExeRelatedInstances;
        this.timestampOffset = compExeRelatedInstances.timestampOffsetToWorkfowNode;
        this.errorMessageSuffix = StringUtils.format((String)" of '%s' (%s) (workflow '%s' (%s)) at %s", (Object[])new Object[]{compExeRelatedInstances.compExeCtx.getInstanceName(), compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier(), compExeRelatedInstances.compExeCtx.getWorkflowNodeId()});
    }

    protected synchronized void addComponentExecution(ComponentExecutionContext compExeCtx, Integer executionCount) throws ComponentExecutionException {
        try {
            this.compExeDmId = metaDataService.addComponentRun(this.compExeRelatedInstances.compExeCtx.getInstanceDataManagementId(), DataManagementIdMapping.mapLogicalNodeIdToDbString((LogicalNodeId)compExeCtx.getNodeId()), executionCount, Long.valueOf(System.currentTimeMillis() + (long)this.timestampOffset), (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException("Failed to store component execution" + this.errorMessageSuffix, e);
        }
    }

    protected synchronized Long addOutput(String outputName, String datum) throws ComponentExecutionException {
        this.assertCompExeDmIdNotNull("Adding value for output: " + outputName);
        try {
            return metaDataService.addOutputDatum(this.compExeDmId, this.compExeRelatedInstances.compExeCtx.getOutputDataManagementIds().get(outputName), datum, this.outputCount.getAndIncrement(outputName), (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException(String.valueOf(StringUtils.format((String)"Failed to store output '%s'", (Object[])new Object[]{outputName})) + this.errorMessageSuffix, e);
        }
    }

    protected synchronized void addInput(String inputName, Long typedDatumId) throws ComponentExecutionException {
        this.assertCompExeDmIdNotNull("Adding value for input: " + inputName);
        if (typedDatumId == null) {
            throw new ComponentExecutionException(String.valueOf(StringUtils.format((String)"Failed to store input '%s'", (Object[])new Object[]{inputName})) + this.errorMessageSuffix + ", " + "because given datamanagement id of related output was null. Likely, because saving output failed earlier.");
        }
        try {
            metaDataService.addInputDatum(this.compExeDmId, typedDatumId, this.compExeRelatedInstances.compExeCtx.getInputDataManagementIds().get(inputName), this.inputCount.getAndIncrement(inputName), (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException(String.valueOf(StringUtils.format((String)"Failed to store input '%s'", (Object[])new Object[]{inputName})) + this.errorMessageSuffix, e);
        }
    }

    protected synchronized void setComponentExecutionFinished(FinalComponentRunState finalState) throws ComponentExecutionException {
        this.assertCompExeDmIdNotNull("Setting component execution to finish");
        try {
            metaDataService.setComponentRunFinished(this.compExeDmId, Long.valueOf(System.currentTimeMillis() + (long)this.timestampOffset), finalState, (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException("Failed to store component execution" + this.errorMessageSuffix, e);
        }
        this.compExeDmId = null;
    }

    protected synchronized void setFinalComponentState(FinalComponentState finalState) throws ComponentExecutionException {
        try {
            metaDataService.setComponentInstanceFinalState(this.compExeRelatedInstances.compExeCtx.getInstanceDataManagementId(), finalState, (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException("Failed to store final state" + this.errorMessageSuffix, e);
        }
    }

    protected synchronized void setOrUpdateHistoryDataItem(String historyDataItem) throws ComponentExecutionException {
        this.assertCompExeDmIdNotNull("Adding or updating history data");
        try {
            metaDataService.setOrUpdateHistoryDataItem(this.compExeDmId, historyDataItem, (ResolvableNodeId)this.compExeRelatedInstances.compExeCtx.getDefaultStorageNodeId());
        }
        catch (CommunicationException | RuntimeException e) {
            throw new ComponentExecutionException("Failed to add or update history data" + this.errorMessageSuffix, e);
        }
    }

    protected synchronized boolean hasUnfinishedComponentExecution() {
        return this.compExeDmId != null;
    }

    protected synchronized Long getComponentExecutionDataManagementId() {
        return this.compExeDmId;
    }

    private void assertCompExeDmIdNotNull(String info) throws ComponentExecutionException {
        if (this.compExeDmId == null) {
            throw new ComponentExecutionException(StringUtils.format((String)"No component run for component '%s' stored in the database; request failed: '%s'; note: writing outputs and history data items is only allowed within 'start()' if 'treatStartAsComponentRun()' returns true and within 'processInputs()' and not allowed at all if component was cancelled", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), info}));
        }
    }

    protected void bindMetaDataService(MetaDataService newService) {
        metaDataService = newService;
    }

    private class EndpointCountMap
    extends HashMap<String, Integer> {
        private static final long serialVersionUID = 6170727124152514043L;

        private EndpointCountMap() {
        }

        @Override
        public Integer get(Object key) {
            if (!this.containsKey(key)) {
                this.put((String)key, new Integer(0));
            }
            return (Integer)super.get(key);
        }

        public Integer getAndIncrement(String endpointName) {
            Integer count = this.get(endpointName);
            this.put(endpointName, count + 1);
            return count;
        }
    }
}

