/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class WorkflowGraphNode
implements Serializable {
    private static final long serialVersionUID = 272922098023592460L;
    private final String executionIdentifier;
    private final Set<String> inputIdentifiers;
    private final Set<String> outputIdentifiers;
    private final Map<String, String> endpointNames;
    private final boolean isDriver;
    private final boolean isDrivingFaultTolerantLoop;
    private final String name;

    public WorkflowGraphNode(String nodeId, Set<String> inputIdentifiers, Set<String> outputIdentifiers, Map<String, String> endpointNames, boolean isDriver, boolean isDrivingFaultTolerantLoop) {
        this(nodeId, inputIdentifiers, outputIdentifiers, endpointNames, isDriver, isDrivingFaultTolerantLoop, nodeId);
    }

    public WorkflowGraphNode(String nodeId, Set<String> inputIdentifiers, Set<String> outputIdentifiers, Map<String, String> endpointNames, boolean isDriver, boolean isDrivingFaultTolerantLoop, String name) {
        this.executionIdentifier = nodeId;
        this.inputIdentifiers = inputIdentifiers;
        this.outputIdentifiers = outputIdentifiers;
        this.endpointNames = endpointNames;
        this.isDriver = isDriver;
        this.isDrivingFaultTolerantLoop = isDrivingFaultTolerantLoop;
        this.name = name;
    }

    public String getExecutionIdentifier() {
        return this.executionIdentifier;
    }

    public Set<String> getInputIdentifiers() {
        return this.inputIdentifiers;
    }

    public Set<String> getOutputIdentifiers() {
        return this.outputIdentifiers;
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    public boolean isDrivingFaultTolerantLoop() {
        return this.isDrivingFaultTolerantLoop;
    }

    public String getEndpointName(String endpointIdentifier) {
        return this.endpointNames.get(endpointIdentifier);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return StringUtils.format((String)"%s (driver: %b)", (Object[])new Object[]{this.getExecutionIdentifier(), this.isDriver()});
    }
}

