/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.ComponentRunInterval;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunTimline;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.view.timeline.AreaChangedListener;
import de.rcenvironment.core.gui.workflow.view.timeline.Messages;
import de.rcenvironment.core.gui.workflow.view.timeline.ResizeListener;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineActivityPart;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineActivityType;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentList;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentRow;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineFilterDialog;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineNavigationControl;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TimelineView
extends ViewPart
implements AreaChangedListener,
ResizeListener,
ControlListener,
SelectionListener {
    public static final String ID = "de.rcenvironment.gui.TimeTable";
    private static final int SCROLLBAR_MAXIMUM = 10000;
    private static final Map<String, Image> COMPONENT_ICON_CACHE = new HashMap<String, Image>();
    private Composite rootComposite = null;
    private TimelineNavigationControl navigation = null;
    private SashForm sashMiddle = null;
    private TimelineComponentList list = null;
    private TimelineComponentRow[] rows = new TimelineComponentRow[0];
    private Slider scrollBar = null;
    private Action refreshAction = null;
    private Action zoomInAction = null;
    private Action zoomOutAction = null;
    private Action filterAction = null;
    private Date wfStartDate = null;
    private Date wfEndDate = null;
    private Label workflowNameLabel = null;
    private String[] allowedComponentNames = null;
    private final Color backgroundColorWhite = Display.getCurrent().getSystemColor(1);
    private final int defaultMaximumZoomValue = 10000;
    private final int defaultMinimumZoomValue = 45;
    private int currentZoomValue = 10000;
    private MetaDataService metaDataService = (MetaDataService)ServiceRegistry.createAccessFor((Object)this).getService(MetaDataService.class);
    private Long workflowDmId;
    private ResolvableNodeId workflowCtrlNode;
    private boolean workflowTerminated = false;
    private Composite parentComposite;
    private boolean actualContentSet = false;
    private Label refreshLabel;

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.parentComposite.setBackground(this.backgroundColorWhite);
        this.refreshLabel = new Label(this.parentComposite, 0);
        this.refreshLabel.setText("Fetching workflow timeline...");
        this.rootComposite = new Composite((Composite)new Shell(), 0);
        this.rootComposite.setBackground(this.backgroundColorWhite);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginBottom = 0;
        mainLayout.verticalSpacing = 0;
        this.rootComposite.setLayout((Layout)mainLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        this.rootComposite.setLayoutData((Object)gridData);
        this.makeActions(this.rootComposite);
        this.initGUI(this.rootComposite);
        this.contributeToActionBars();
        this.rootComposite.setEnabled(false);
    }

    private void initGUI(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.verticalSpan = 1;
        gridData.grabExcessVerticalSpace = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite titleComposite = new Composite(parent, 0);
        titleComposite.setLayoutData((Object)gridData);
        titleComposite.setBackground(this.backgroundColorWhite);
        titleComposite.setLayout((Layout)gridLayout);
        Composite workflowName = new Composite(titleComposite, 0);
        workflowName.setLayoutData((Object)gridData);
        workflowName.setBackground(this.backgroundColorWhite);
        workflowName.setLayout((Layout)new RowLayout());
        this.workflowNameLabel = new Label(workflowName, 0);
        this.workflowNameLabel.setBackground(this.backgroundColorWhite);
        Composite colorLegend = new Composite(titleComposite, 0x4000000);
        colorLegend.setLayoutData((Object)gridData);
        colorLegend.setBackground(this.backgroundColorWhite);
        colorLegend.setLayout((Layout)new RowLayout());
        TimelineActivityType[] timelineActivityTypeArray = TimelineActivityType.values();
        int n = timelineActivityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimelineActivityType current = timelineActivityTypeArray[n2];
            if (current.getColor() != null) {
                Label label = new Label(colorLegend, 0);
                label.setBackground(this.backgroundColorWhite);
                label.setText("   " + current.getDisplayName() + " ");
                Label colorLabel = new Label(colorLegend, 0);
                colorLabel.setText("      ");
                colorLabel.setBackground(new Color((Device)label.getDisplay(), current.getColor()));
            }
            ++n2;
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        SashForm master = new SashForm(parent, 512);
        master.setSashWidth(2);
        master.setLayoutData((Object)gridData);
        this.initTopGUI((Composite)master);
        this.initBottomGUI((Composite)master);
        master.setWeights(new int[]{5, 1});
    }

    private void initTopGUI(Composite parent) {
        Composite master = new Composite(parent, 0);
        master.setBackground(this.backgroundColorWhite);
        master.setLayout((Layout)new GridLayout(1, true));
        this.list = new TimelineComponentList(master);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.list.setLayoutData(gridData);
        this.list.addResizeListener(this);
        this.list.setBackground(this.backgroundColorWhite);
        this.sashMiddle = new SashForm(master, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.sashMiddle.setLayoutData((Object)gridData);
        Composite zoomComposite = new Composite((Composite)this.sashMiddle, 0);
        zoomComposite.setBackground(this.backgroundColorWhite);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        zoomComposite.setLayout((Layout)layout);
        this.scrollBar = new Slider((Composite)this.sashMiddle, 256);
        this.scrollBar.setMaximum(10000);
        this.scrollBar.setPageIncrement(10000);
        this.scrollBar.setIncrement(10);
        this.scrollBar.setThumb(this.scrollBar.getMaximum());
        this.scrollBar.setEnabled(false);
        this.scrollBar.setLayoutData((Object)gridData);
        this.scrollBar.addControlListener((ControlListener)this);
        this.scrollBar.addSelectionListener((SelectionListener)this);
        this.sashMiddle.setWeights(new int[]{1, 7});
    }

    private void initBottomGUI(Composite parent) {
        this.navigation = new TimelineNavigationControl(parent);
        this.navigation.setBackground(this.backgroundColorWhite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.navigation.setLayoutData(gridData);
        this.navigation.addAreaChangeListener(this);
    }

    public void initialize(Long wfDmId, ResolvableNodeId wfCtrlNode) {
        this.workflowDmId = wfDmId;
        this.workflowCtrlNode = wfCtrlNode;
        this.updateContent();
    }

    private void updateContent() {
        this.refreshAction.setEnabled(false);
        Job job = new Job("Workflow Timeline"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Fetching workflow timeline", 2);
                        monitor.worked(1);
                        WorkflowRunTimline timeline = TimelineView.this.metaDataService.getWorkflowTimeline(TimelineView.this.workflowDmId, TimelineView.this.workflowCtrlNode);
                        final String timelineAsString = TimelineView.this.getWorkflowRunTimelineAsJsonString(timeline);
                        monitor.worked(1);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TimelineView.this.parentComposite.isDisposed()) {
                                    boolean isZoomed = TimelineView.this.currentZoomValue != 10000;
                                    Date visibleEndTime = null;
                                    Date visibleStartTime = null;
                                    if (isZoomed && TimelineView.this.navigation != null) {
                                        visibleEndTime = TimelineView.this.navigation.getVisibleEndTime();
                                        visibleStartTime = TimelineView.this.navigation.getVisibleStartTime();
                                    }
                                    if (TimelineView.this.updateContent(timelineAsString) && !TimelineView.this.actualContentSet) {
                                        TimelineView.this.refreshLabel.setParent((Composite)new Shell());
                                        TimelineView.this.refreshLabel.dispose();
                                        TimelineView.this.rootComposite.setParent(TimelineView.this.parentComposite);
                                        TimelineView.this.rootComposite.getShell().layout(true, true);
                                        TimelineView.this.enableZoomActions();
                                        TimelineView.this.filterAction.setEnabled(true);
                                        TimelineView.this.actualContentSet = true;
                                    }
                                    TimelineView.this.rootComposite.setEnabled(true);
                                    TimelineView.this.list.setMinSize(TimelineView.this.list.computeSize(-1, -1, true));
                                    TimelineView.this.list.layout();
                                    TimelineView.this.rootComposite.pack();
                                    TimelineView.this.rootComposite.setBounds(TimelineView.this.rootComposite.getParent().getBounds());
                                    if (isZoomed && visibleStartTime != null && visibleEndTime != null) {
                                        TimelineView.this.setVisibleArea(visibleStartTime, visibleEndTime);
                                    }
                                    TimelineView.this.refreshAction.setEnabled(!TimelineView.this.workflowTerminated);
                                }
                            }
                        });
                    }
                    catch (CommunicationException | IOException e) {
                        LogFactory.getLog(TimelineView.class).error((Object)"Failed to load timeline of workflow", e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)TimelineView.this);
                                MessageDialog.openError((Shell)TimelineView.this.getSite().getShell(), (String)"Workflow Timeline", (String)"Failed to load the timeline. Did you get disconnected from a remote instance?\n\nPlease refresh the workflow data browser and try again.\n\nSee log for more details.");
                            }
                        });
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private String getWorkflowRunTimelineAsJsonString(WorkflowRunTimline timeline) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("WorkflowName", timeline.getWorkflowRunName());
        rootNode.put("WorkflowStartTime", String.valueOf(timeline.getWorkflowRunInterval().getStartTime()));
        if (timeline.getWorkflowRunInterval().getEndTime() != null) {
            rootNode.put("WorkflowEndTime", String.valueOf(timeline.getWorkflowRunInterval().getEndTime()));
            this.workflowTerminated = true;
        } else {
            rootNode.put("WorkflowEndTime", String.valueOf(System.currentTimeMillis()));
        }
        ArrayNode componentsArray = rootNode.putArray("Components");
        HashMap<String, ObjectNode> componentNodes = new HashMap<String, ObjectNode>();
        HashMap componentEventNodes = new HashMap();
        for (ComponentRunInterval cri : timeline.getComponentRunIntervalsSortedByTime()) {
            ObjectNode eventNode;
            if (!componentNodes.containsKey(cri.getComponentInstanceName())) {
                ObjectNode componentNode = mapper.createObjectNode();
                componentNode.put("Name", cri.getComponentInstanceName());
                componentNode.put("Id", cri.getComponentID());
                componentNode.putArray("Events");
                componentNodes.put(cri.getComponentInstanceName(), componentNode);
            }
            if (!componentEventNodes.containsKey(cri.getComponentInstanceName())) {
                componentEventNodes.put(cri.getComponentInstanceName(), new TreeMap());
            }
            SortedMap sortedEventNodes = (SortedMap)componentEventNodes.get(cri.getComponentInstanceName());
            if (cri.getType() == TimelineIntervalType.COMPONENT_RUN) {
                eventNode = mapper.createObjectNode();
                eventNode.put("Time", String.valueOf(cri.getStartTime()));
                eventNode.put("Type", String.valueOf(cri.getType().name()));
                sortedEventNodes.put(cri.getStartTime(), eventNode);
                if (cri.getEndTime() == null) continue;
                ObjectNode waitEventNode = mapper.createObjectNode();
                waitEventNode.put("Time", String.valueOf(cri.getEndTime()));
                waitEventNode.put("Type", "COMPONENT_WAIT");
                sortedEventNodes.put(cri.getEndTime(), waitEventNode);
                continue;
            }
            eventNode = mapper.createObjectNode();
            eventNode.put("Time", String.valueOf(cri.getStartTime()));
            eventNode.put("Type", String.valueOf(cri.getType().name()));
            sortedEventNodes.put(cri.getStartTime(), eventNode);
            if (cri.getEndTime() == null || sortedEventNodes.containsKey(cri.getEndTime())) continue;
            ObjectNode runEventNode = mapper.createObjectNode();
            runEventNode.put("Time", String.valueOf(cri.getEndTime()));
            runEventNode.put("Type", TimelineIntervalType.COMPONENT_RUN.name());
            sortedEventNodes.put(cri.getEndTime(), runEventNode);
        }
        for (String compInstanceName : componentNodes.keySet()) {
            ArrayNode eventsNode = (ArrayNode)((ObjectNode)componentNodes.get(compInstanceName)).get("Events");
            for (ObjectNode eventNode : ((SortedMap)componentEventNodes.get(compInstanceName)).values()) {
                eventsNode.add((JsonNode)eventNode);
            }
            componentsArray.add((JsonNode)componentNodes.get(compInstanceName));
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return writer.writeValueAsString((Object)rootNode);
    }

    private boolean updateContent(String resource) {
        ArrayList jsonComponentList;
        String jsonWorkflowEnd;
        String jsonWorkflowStart;
        String jsonWorkflowName;
        block14: {
            this.list.clear();
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            Map jsonStructureRoot = (Map)mapper.readValue(resource, new HashMap().getClass());
            jsonWorkflowName = (String)jsonStructureRoot.get("WorkflowName");
            jsonWorkflowStart = (String)jsonStructureRoot.get("WorkflowStartTime");
            jsonWorkflowEnd = (String)jsonStructureRoot.get("WorkflowEndTime");
            jsonComponentList = (ArrayList)jsonStructureRoot.get("Components");
            if (jsonWorkflowName != null && !jsonWorkflowName.equals("") && jsonWorkflowStart != null && !jsonWorkflowStart.equals("") && jsonWorkflowEnd != null && !jsonWorkflowEnd.equals("") && jsonComponentList != null && !jsonComponentList.isEmpty()) break block14;
            String message = "Unable to open the timeline view for the selected workflow run. An unexpected problem occured while reading the timeline data.";
            LogFactory.getLog(TimelineView.class).error((Object)message);
            this.refreshLabel.setText(message);
            return false;
        }
        try {
            this.workflowNameLabel.setText(jsonWorkflowName);
            this.workflowNameLabel.pack();
            this.wfStartDate = new Date();
            this.wfStartDate.setTime(Long.valueOf(jsonWorkflowStart));
            this.wfEndDate = new Date();
            this.wfEndDate.setTime(Long.valueOf(jsonWorkflowEnd));
            this.setVisibleArea(this.wfStartDate, this.wfEndDate);
            this.navigation.setWorflowStartEndTime(this.wfStartDate, this.wfEndDate);
            ArrayList<TimelineComponentRow> currentRows = new ArrayList<TimelineComponentRow>();
            for (Object jsonCurrentComponentObject : jsonComponentList) {
                Map jsonCurrentComponent = (Map)jsonCurrentComponentObject;
                String currentComponentName = (String)jsonCurrentComponent.get("Name");
                String currentComponentID = (String)jsonCurrentComponent.get("Id");
                TimelineComponentRow currentRow = new TimelineComponentRow(currentComponentName, currentComponentID, this.wfStartDate, this.wfEndDate);
                ArrayList jsonActivityList = (ArrayList)jsonCurrentComponent.get("Events");
                Collections.sort(jsonActivityList, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        HashMap compare1 = (HashMap)o1;
                        HashMap compare2 = (HashMap)o2;
                        return ((String)compare1.get("Time")).compareTo((String)compare2.get("Time"));
                    }
                });
                ArrayList<TimelineActivityPart> currentActivities = new ArrayList<TimelineActivityPart>();
                boolean extToolRunPrev = false;
                int run = 0;
                for (Object jsonCurrentActivity : jsonActivityList) {
                    Map currentActivityMap = (Map)jsonCurrentActivity;
                    Date currentActivityTime = new Date();
                    long activityTime = Long.valueOf((String)currentActivityMap.get("Time"));
                    currentActivityTime.setTime(activityTime);
                    String currentEventType = (String)currentActivityMap.get("Type");
                    TimelineActivityType eventType = TimelineActivityType.valueOfjsonName(currentEventType);
                    String comment = null;
                    if (currentActivityMap.containsKey("InformationText")) {
                        comment = (String)currentActivityMap.get("InformationText");
                    }
                    TimelineActivityPart currentActivity = null;
                    if (eventType == TimelineActivityType.COMPONENT_RUN) {
                        if (extToolRunPrev) {
                            extToolRunPrev = false;
                        } else {
                            ++run;
                        }
                        currentActivity = new TimelineActivityPart(currentComponentName, eventType, currentActivityTime, String.valueOf(run), comment);
                    } else {
                        currentActivity = new TimelineActivityPart(currentComponentName, eventType, currentActivityTime, String.valueOf(run), comment);
                        if (eventType == TimelineActivityType.EXTERNAL_TOOL_RUN_IN_COMPONENT_RUN) {
                            extToolRunPrev = true;
                        }
                    }
                    if (currentActivities.size() == 0 && !currentActivityTime.equals(this.wfStartDate)) {
                        TimelineActivityPart currentFirstActivity = new TimelineActivityPart(currentComponentName, TimelineActivityType.WAITING, this.wfStartDate, null);
                        currentFirstActivity.setEndtime(currentActivityTime);
                        if (currentActivities.size() > 0) {
                            ((TimelineActivityPart)currentActivities.get(currentActivities.size() - 1)).setEndtime(currentActivityTime);
                        }
                        currentActivities.add(currentFirstActivity);
                    }
                    if (currentActivities.size() > 0) {
                        ((TimelineActivityPart)currentActivities.get(currentActivities.size() - 1)).setEndtime(currentActivityTime);
                    }
                    currentActivities.add(currentActivity);
                }
                currentRow.setActivities(currentActivities.toArray(new TimelineActivityPart[currentActivities.size()]));
                currentRow.setWorkflowStartTime(this.wfStartDate);
                currentRow.setWorkflowEndTime(this.wfEndDate);
                currentRows.add(currentRow);
            }
            this.rows = currentRows.toArray(new TimelineComponentRow[currentRows.size()]);
        }
        catch (IOException e) {
            LogFactory.getLog(TimelineView.class).error((Object)e);
            return false;
        }
        this.showComponentRows(this.rows);
        return true;
    }

    private void setVisibleArea(Date visibleStartTime, Date visibleEndTime) {
        this.list.setTimeArea(visibleStartTime, visibleEndTime);
        this.navigation.setVisibleArea(visibleStartTime, visibleEndTime);
    }

    private void showComponentRows(TimelineComponentRow[] newrows) {
        this.navigation.setWorflowStartEndTime(this.wfStartDate, this.wfEndDate);
        this.navigation.setTimeTableComponentRows(this.filter(newrows, this.allowedComponentNames));
        this.list.setTimeTableComponentRows(this.filter(newrows, this.allowedComponentNames));
    }

    private TimelineComponentRow[] filter(TimelineComponentRow[] oldrows, String[] allowed) {
        if (allowed == null) {
            return oldrows;
        }
        ArrayList<TimelineComponentRow> showRows = new ArrayList<TimelineComponentRow>();
        TimelineComponentRow[] timelineComponentRowArray = oldrows;
        int n = oldrows.length;
        int n2 = 0;
        while (n2 < n) {
            TimelineComponentRow currentRow = timelineComponentRowArray[n2];
            if (this.filterContains(currentRow.getName(), allowed)) {
                showRows.add(currentRow);
            }
            ++n2;
        }
        return showRows.toArray(new TimelineComponentRow[showRows.size()]);
    }

    private boolean filterContains(String name, String[] filter) {
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String filterKey = stringArray[n2];
            if (filterKey.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void makeActions(Composite parent) {
        this.refreshAction = new Action("Refresh"){

            public void run() {
                TimelineView.this.updateContent();
            }
        };
        this.refreshAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.REFRESH_16));
        this.refreshAction.setEnabled(false);
        this.zoomInAction = new Action(Messages.zoomin){

            public void run() {
                int maxZoom = 1000;
                int minZoom = TimelineView.this.currentZoomValue - maxZoom;
                if (minZoom == 0) {
                    TimelineView.this.setZoom(45);
                } else if (minZoom > 0) {
                    TimelineView.this.setZoom(minZoom);
                } else if (minZoom < 0) {
                    TimelineView.this.setZoom(45);
                }
                TimelineView.this.enableZoomActions();
            }
        };
        this.zoomInAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)TimelineView.class.getResource("/resources/icons/zoom_in.gif")));
        this.zoomInAction.setEnabled(false);
        this.zoomOutAction = new Action(Messages.zoomout){

            public void run() {
                int maxZoom = 1000;
                int minZoom = 10000 - TimelineView.this.currentZoomValue;
                if (TimelineView.this.currentZoomValue + maxZoom <= 10000) {
                    TimelineView.this.setZoom(TimelineView.this.currentZoomValue + maxZoom);
                } else if (minZoom > 0 && minZoom < maxZoom) {
                    TimelineView.this.setZoom(TimelineView.this.currentZoomValue + minZoom);
                }
                TimelineView.this.enableZoomActions();
            }
        };
        this.zoomOutAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)TimelineView.class.getResource("/resources/icons/zoom_out.gif")));
        this.zoomOutAction.setEnabled(false);
        this.filterAction = new Action("Filter"){

            public void run() {
                if (TimelineView.this.allowedComponentNames == null) {
                    ArrayList<String> currentList = new ArrayList<String>();
                    TimelineComponentRow[] timelineComponentRowArray = TimelineView.this.rows;
                    int n = timelineComponentRowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TimelineComponentRow currentRow = timelineComponentRowArray[n2];
                        currentList.add(currentRow.getName());
                        ++n2;
                    }
                    TimelineView.this.allowedComponentNames = currentList.toArray(new String[currentList.size()]);
                }
                TimelineFilterDialog dialog = new TimelineFilterDialog(Display.getCurrent().getActiveShell(), TimelineView.this.allowedComponentNames, TimelineView.this.rows);
                dialog.create();
                dialog.updateContent();
                if (dialog.open() == 0) {
                    TimelineView.this.allowedComponentNames = dialog.getFilteredNames();
                    TimelineView.this.showComponentRows(TimelineView.this.rows);
                }
            }
        };
        this.filterAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)TimelineView.class.getResource("/resources/icons/filter.gif")));
        this.filterAction.setEnabled(false);
    }

    protected void enableZoomActions() {
        this.zoomOutAction.setEnabled(this.currentZoomValue != 10000);
        this.zoomInAction.setEnabled(this.currentZoomValue != 0);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.zoomInAction);
        manager.add((IAction)this.zoomOutAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterAction);
        manager.add((IContributionItem)new Separator());
    }

    public static Image getImageIconFromId(String identifier, Object caller) {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)caller);
        DistributedComponentKnowledgeService componentKnowledgeService = (DistributedComponentKnowledgeService)serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        Collection installations = componentKnowledgeService.getCurrentComponentKnowledge().getAllInstallations();
        for (ComponentInstallation installation : installations) {
            if (!installation.getInstallationId().startsWith(identifier)) continue;
            if (!COMPONENT_ICON_CACHE.containsKey(installation.getInstallationId())) {
                byte[] icon = installation.getComponentRevision().getComponentInterface().getIcon16();
                if (icon != null) {
                    Image image = ImageDescriptor.createFromImage((Image)new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(icon))).createImage();
                    COMPONENT_ICON_CACHE.put(installation.getInstallationId(), image);
                } else {
                    COMPONENT_ICON_CACHE.put(installation.getInstallationId(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_16));
                }
            }
            return COMPONENT_ICON_CACHE.get(installation.getInstallationId());
        }
        return null;
    }

    public static String getComponentNameFromId(String identifier, Object caller) {
        if (identifier == null) {
            return null;
        }
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)caller);
        DistributedComponentKnowledgeService componentKnowledgeService = (DistributedComponentKnowledgeService)serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        Collection installations = componentKnowledgeService.getCurrentComponentKnowledge().getAllInstallations();
        for (ComponentInstallation installation : installations) {
            if (!installation.getInstallationId().startsWith(identifier)) continue;
            return installation.getComponentRevision().getComponentInterface().getDisplayName();
        }
        return null;
    }

    public void setZoom(int zoom) {
        Date vET = this.navigation.getVisibleEndTime();
        Date vST = this.navigation.getVisibleStartTime();
        long diffVSET = vET.getTime() - vST.getTime();
        double middleTimeStamp = vST.getTime() + diffVSET / 2L;
        long startTime = this.wfStartDate.getTime();
        long endTime = this.wfEndDate.getTime();
        double currentAddValue = (long)zoom * (this.wfEndDate.getTime() - this.wfStartDate.getTime()) / 20000L;
        Date newStartDate = new Date((long)(middleTimeStamp - currentAddValue));
        Date newEndDate = new Date((long)(middleTimeStamp + currentAddValue));
        long newStartTime = newStartDate.getTime();
        long newEndTime = newEndDate.getTime();
        if (newStartTime < startTime) {
            long overTime = startTime - newStartTime;
            newEndDate = new Date(newEndTime + overTime);
            newStartDate = this.wfStartDate;
        } else if (newEndTime > endTime) {
            long overTime = endTime - newEndTime;
            newStartDate = new Date(newStartTime + overTime);
            newEndDate = this.wfEndDate;
        }
        this.navigation.setVisibleArea(newStartDate, newEndDate);
        this.navigation.notifyAreaChangeListener();
    }

    public static Date convertPixelToDate(int xPixel, int canvasSizeX, Date currentWorkflowStartTime, Date currentWorkflowEndTime) {
        long value = (currentWorkflowEndTime.getTime() * (long)xPixel + currentWorkflowStartTime.getTime() * (long)(canvasSizeX - xPixel)) / (long)canvasSizeX;
        Date date = new Date();
        date.setTime(value);
        return date;
    }

    public static int convertDateToPixel(Date date, int canvasSizeX, Date currentWorkflowStartTime, Date currentWorkflowEndTime) {
        long value = date.getTime();
        int xPixel = (int)((value - currentWorkflowStartTime.getTime()) * (long)canvasSizeX / (currentWorkflowEndTime.getTime() - currentWorkflowStartTime.getTime()));
        return xPixel;
    }

    public void setFocus() {
    }

    @Override
    public void resized() {
        this.sashMiddle.setWeights(this.list.getWeights());
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        this.list.setWeights(this.sashMiddle.getWeights());
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        int begin = this.scrollBar.getMinimum() + this.scrollBar.getSelection();
        int end = this.scrollBar.getMinimum() + this.scrollBar.getSelection() + this.scrollBar.getThumb();
        this.setVisibleArea(TimelineView.convertPixelToDate(begin, this.scrollBar.getMaximum(), this.wfStartDate, this.wfEndDate), TimelineView.convertPixelToDate(end, this.scrollBar.getMaximum(), this.wfStartDate, this.wfEndDate));
    }

    @Override
    public void selectedAreaChanged(Date selectedStartTime, Date selectedEndTime) {
        this.list.setTimeArea(selectedStartTime, selectedEndTime);
        long selectedTime = selectedEndTime.getTime() - selectedStartTime.getTime();
        long wfTime = this.wfEndDate.getTime() - this.wfStartDate.getTime();
        float dividedTime = (float)selectedTime / (float)wfTime * 100.0f;
        this.currentZoomValue = Math.round(dividedTime) * 100;
        this.scrollBar.setEnabled(this.currentZoomValue < this.scrollBar.getMaximum());
        if (this.currentZoomValue != 0) {
            this.scrollBar.setThumb(this.currentZoomValue);
        } else {
            this.scrollBar.setThumb(45);
        }
        int beginSelection = TimelineView.convertDateToPixel(selectedStartTime, this.scrollBar.getMaximum(), this.wfStartDate, this.wfEndDate) - this.scrollBar.getMinimum();
        this.scrollBar.setSelection(beginSelection);
        this.enableZoomActions();
    }
}

