/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.incubator.formatter;

import de.rcenvironment.core.gui.utils.incubator.formatter.Alignments;
import de.rcenvironment.core.gui.utils.incubator.formatter.ArrayBasedDataTable;
import de.rcenvironment.core.gui.utils.incubator.formatter.DataTable;
import de.rcenvironment.core.utils.common.StringUtils;

public class Formatter
extends ArrayBasedDataTable {
    public final StringBuilder[] renderTable(DataTable table) {
        StringBuilder[] newTable = new StringBuilder[table.getSizeOfTable()];
        this.setAmountOfSpace(table);
        int i = 0;
        while (i < table.getSizeOfTable()) {
            newTable[i] = new StringBuilder();
            ++i;
        }
        i = 0;
        while (i < table.getSizeOfTable()) {
            int j = 0;
            while (j < table.getSizeOfRow()) {
                StringBuilder newCell = this.renderCell(table.getRow(i)[j], j, table);
                newTable[i].append(newCell + " ");
                ++j;
            }
            ++i;
        }
        return newTable;
    }

    private void setAmountOfSpace(DataTable table) {
        int i = 0;
        while (i < table.getSizeOfRow()) {
            this.maxAmountOfSpace.add(0);
            this.maxAmountOfSpaceBeforeAlignmentChar.add(0);
            this.maxAmountOfSpaceAfterAlignmentChar.add(0);
            int maxAmountOfSpaceInColumn = 0;
            int maxAmountOfSpaceInColumnBeforeAlignmentChar = 0;
            int maxAmountOfSpaceInColumnAfterAlignmentChar = 0;
            int j = 0;
            while (j < table.getSizeOfTable()) {
                if (table.getRow(j)[i].length() > maxAmountOfSpaceInColumn) {
                    maxAmountOfSpaceInColumn = table.getRow(j)[i].length();
                }
                if (table.getRow(j)[i].contains(Character.toString('.'))) {
                    int numberSymbols = 0;
                    while (numberSymbols < table.getRow(j)[i].length()) {
                        if (table.getRow(j)[i].charAt(numberSymbols) == '.') {
                            if (numberSymbols > maxAmountOfSpaceInColumnBeforeAlignmentChar) {
                                maxAmountOfSpaceInColumnBeforeAlignmentChar = numberSymbols;
                            }
                            if (table.getRow(j)[i].length() - numberSymbols - 1 <= maxAmountOfSpaceInColumnAfterAlignmentChar) break;
                            maxAmountOfSpaceInColumnAfterAlignmentChar = table.getRow(j)[i].length() - numberSymbols - 1;
                            break;
                        }
                        ++numberSymbols;
                    }
                    this.maxAmountOfSpaceBeforeAlignmentChar.set(i, maxAmountOfSpaceInColumnBeforeAlignmentChar);
                    this.maxAmountOfSpaceAfterAlignmentChar.set(i, maxAmountOfSpaceInColumnAfterAlignmentChar);
                }
                ++j;
            }
            this.maxAmountOfSpace.set(i, maxAmountOfSpaceInColumn);
            ++i;
        }
    }

    private StringBuilder renderCell(String cell, int columnNumber, DataTable table) {
        StringBuilder newCell;
        Alignments alignment = table.getAlignments()[columnNumber];
        switch (alignment) {
            case RIGHT: {
                newCell = this.alignRight(cell, columnNumber, table);
                break;
            }
            case CENTER: {
                newCell = this.alignCenter(cell, columnNumber, table);
                break;
            }
            case CHARALIGNMENT: {
                newCell = this.alignByChar(cell, columnNumber, table);
                break;
            }
            default: {
                newCell = this.alignLeft(cell, columnNumber, table);
            }
        }
        return newCell;
    }

    private StringBuilder alignLeft(String cell, int columnNumber, DataTable table) {
        String cellFormat = this.createFormatExpressionAlignedLeft((Integer)this.maxAmountOfSpace.get(columnNumber));
        StringBuilder renderedCell = new StringBuilder();
        renderedCell.append(StringUtils.format((String)cellFormat, (Object[])new Object[]{cell}));
        return renderedCell;
    }

    private StringBuilder alignRight(String cell, int columnNumber, DataTable table) {
        String cellFormat = this.createFormatExpressionAlignedRight((Integer)this.maxAmountOfSpace.get(columnNumber));
        StringBuilder renderedCell = new StringBuilder();
        renderedCell.append(StringUtils.format((String)cellFormat, (Object[])new Object[]{cell}));
        return renderedCell;
    }

    private StringBuilder alignCenter(String cell, int columnNumber, DataTable table) {
        int space = (Integer)this.maxAmountOfSpace.get(columnNumber);
        int spaceBeforeCell = (space - cell.length()) / 2;
        int spaceAfterCell = (space - cell.length()) % 2 == 1 ? (space - cell.length()) / 2 + 1 : (space - cell.length()) / 2;
        String cellFormatSpaceBeforeCell = this.createFormatExpressionAlignedRight(spaceBeforeCell + cell.length());
        String temporaryCell = StringUtils.format((String)cellFormatSpaceBeforeCell, (Object[])new Object[]{cell});
        String cellFormatSpaceAfterCell = this.createFormatExpressionAlignedLeft(spaceAfterCell + temporaryCell.length());
        StringBuilder finalCell = new StringBuilder();
        finalCell.append(StringUtils.format((String)cellFormatSpaceAfterCell, (Object[])new Object[]{temporaryCell}));
        return finalCell;
    }

    private StringBuilder alignByChar(String cell, int columnNumber, DataTable table) {
        int spaceBeforeAlignmentChar = 0;
        int spaceAfterAlignmentChar = 0;
        int j = 0;
        while (j < cell.length()) {
            if (cell.charAt(j) == table.getAlignmentCharacter()) {
                spaceBeforeAlignmentChar = j;
                spaceAfterAlignmentChar = cell.length() - j - 1;
                break;
            }
            ++j;
        }
        String cellFormatSpaceBeforeCell = this.createFormatExpressionAlignedRight((Integer)this.maxAmountOfSpaceBeforeAlignmentChar.get(columnNumber) + cell.length() - spaceBeforeAlignmentChar);
        String temporaryCell = StringUtils.format((String)cellFormatSpaceBeforeCell, (Object[])new Object[]{cell});
        String cellFormatSpaceAfterCell = this.createFormatExpressionAlignedLeft((Integer)this.maxAmountOfSpaceAfterAlignmentChar.get(columnNumber) + temporaryCell.length() - spaceAfterAlignmentChar);
        StringBuilder finalCell = new StringBuilder();
        finalCell.append(StringUtils.format((String)cellFormatSpaceAfterCell, (Object[])new Object[]{temporaryCell}));
        return finalCell;
    }

    private String createFormatExpressionAlignedRight(int space) {
        String formatExpression = "%" + Integer.toString(space) + "s";
        return formatExpression;
    }

    private String createFormatExpressionAlignedLeft(int space) {
        String formatExpression = "%-" + Integer.toString(space) + "s";
        return formatExpression;
    }
}

