/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.SigningPolicyException;
import org.globus.gsi.SigningPolicyParser;
import org.globus.gsi.provider.SigningPolicyStoreException;
import org.globus.gsi.stores.ResourceStoreException;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSigningPolicy {
    protected Resource resource;
    private Log logger = LogFactory.getLog(ResourceSigningPolicy.class.getCanonicalName());
    private boolean changed;
    private Map<X500Principal, SigningPolicy> signingPolicyMap;
    private long lastModified = -1L;

    public ResourceSigningPolicy(Resource resource) throws ResourceStoreException {
        this.init(resource);
    }

    protected void init(Resource initResource) throws ResourceStoreException {
        this.resource = initResource;
        this.signingPolicyMap = this.create(this.resource);
        this.logger.debug(String.format("Loading initResource: %s", this.resource.toString()));
        try {
            this.lastModified = this.resource.lastModified();
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    protected void init(Resource initResource, Map<X500Principal, SigningPolicy> initSigningPolicy) throws ResourceStoreException {
        if (initSigningPolicy == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.signingPolicyMap = initSigningPolicy;
        this.resource = initResource;
    }

    public Collection<SigningPolicy> getSigningPolicies() throws SigningPolicyStoreException {
        try {
            Map<X500Principal, SigningPolicy> object = this.getObject();
            if (object != null) {
                return object.values();
            }
        }
        catch (ResourceStoreException e) {
            throw new SigningPolicyStoreException(e);
        }
        return null;
    }

    public Map<X500Principal, SigningPolicy> create(Resource signingPolicyResource) throws ResourceStoreException {
        Map<X500Principal, SigningPolicy> policies;
        SigningPolicyParser parser = new SigningPolicyParser();
        try {
            policies = parser.parse(new InputStreamReader(signingPolicyResource.getInputStream()));
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (SigningPolicyException e) {
            throw new ResourceStoreException(e);
        }
        return policies;
    }

    protected void reload() throws ResourceStoreException {
        long latestLastModified;
        this.changed = false;
        try {
            latestLastModified = this.resource.lastModified();
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        if (this.lastModified < latestLastModified) {
            this.signingPolicyMap = this.create(this.resource);
            this.lastModified = latestLastModified;
            this.changed = true;
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    protected Map<X500Principal, SigningPolicy> getObject() throws ResourceStoreException {
        this.reload();
        return this.signingPolicyMap;
    }

    public boolean hasChanged() {
        return this.changed;
    }
}

