/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.profile;

import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileUtils;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public final class ProfileUtils {
    public static final String SYSTEM_PROPERTY_DEFAULT_PROFILE_ID_OR_PATH = "rce.profile.default";
    public static final String SYSTEM_PROPERTY_USER_HOME = "user.home";
    public static final String SYSTEM_PROPERTY_PROFILES_PARENT_DIRECTORY_OVERRIDE = "rce.profiles.parentDir";
    private static final String FAILED_TO_CREATE_PROFILE_PARENT_MESSAGE_TEMLATE = "Failed to create the profile root directory \"%s\"";
    private static final String PROFILE_PARENT_NEEDS_TO_BE_ABSOLUTE_MESSAGE = "The path used to override the profile parent directory needs to be absolute.";
    private static final String SYSTEM_PROPERTY_SYSTEM_TEMP_DIR = "java.io.tmpdir";

    private ProfileUtils() {
    }

    public static File getProfilesParentDirectory() throws ProfileException {
        File profilesRootDir;
        String parentPathOverride = System.getProperty(SYSTEM_PROPERTY_PROFILES_PARENT_DIRECTORY_OVERRIDE);
        if (parentPathOverride == null) {
            String userHome = System.getProperty(SYSTEM_PROPERTY_USER_HOME);
            profilesRootDir = new File(userHome, ".rce").getAbsoluteFile();
        } else {
            profilesRootDir = new File(parentPathOverride);
            if (!profilesRootDir.isAbsolute()) {
                throw new ProfileException(StringUtils.format((String)"The path used to override the profile parent directory needs to be absolute. %s", (Object[])new Object[]{profilesRootDir.getAbsolutePath()}));
            }
        }
        profilesRootDir.mkdirs();
        if (!profilesRootDir.isDirectory()) {
            throw new ProfileException(StringUtils.format((String)FAILED_TO_CREATE_PROFILE_PARENT_MESSAGE_TEMLATE, (Object[])new Object[]{profilesRootDir.getAbsolutePath()}));
        }
        return profilesRootDir;
    }

    public static File getDefaultProfilePath() throws ProfileException {
        String explicitDefault = System.getProperty(SYSTEM_PROPERTY_DEFAULT_PROFILE_ID_OR_PATH);
        if (explicitDefault != null) {
            File explicitDefaultPath = new File(explicitDefault);
            if (!explicitDefaultPath.isAbsolute()) {
                return new File(ProfileUtils.getProfilesParentDirectory(), explicitDefault);
            }
            return explicitDefaultPath;
        }
        File savedDefaultProfile = null;
        try {
            savedDefaultProfile = CommonProfileUtils.getSavedDefaultProfile();
        }
        catch (CommonProfileException commonProfileException) {}
        if (savedDefaultProfile != null) {
            return savedDefaultProfile;
        }
        File profileParentDirectory = ProfileUtils.getProfilesParentDirectory();
        return new File(profileParentDirectory, "default");
    }

    public static List<Profile> listProfiles(File profileParentDirectory) {
        LinkedList<Profile> profiles = new LinkedList<Profile>();
        File[] fileArray = profileParentDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File profileDirectory = fileArray[n2];
            try {
                Profile profile = new Profile(profileDirectory, false);
                profiles.add(profile);
            }
            catch (ProfileException profileException) {}
            ++n2;
        }
        return profiles;
    }

    public static Profile getFallbackProfile() throws ProfileException {
        String fallbackProfileName = "rce-fallback-profile-" + System.currentTimeMillis();
        File fallbackProfileDirectory = new File(System.getProperty(SYSTEM_PROPERTY_SYSTEM_TEMP_DIR), fallbackProfileName);
        return new Profile(fallbackProfileDirectory);
    }
}

