/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.properties;

import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.common.SimpleExcelService;
import de.rcenvironment.components.excel.gui.properties.Messages;
import de.rcenvironment.components.excel.gui.properties.VariablesEditDialog;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VariablesSelectionPane
extends EndpointSelectionPane {
    private EndpointSelectionPane[] allPanes;
    private Button buttonAutoDiscover;

    public VariablesSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, WorkflowNodeCommand.Executor executor) {
        super(title, direction, dynEndpointIdToManage, new String[0], new String[0], executor);
    }

    public EndpointSelectionPane[] getAllPanes() {
        return this.allPanes;
    }

    public void setAllPanes(EndpointSelectionPane[] allPanes) {
        this.allPanes = allPanes;
    }

    public Control createControl(final Composite parent, String title, FormToolkit toolkit) {
        Control superControl = super.createControl(parent, title, toolkit);
        new Label(this.client, 8);
        this.buttonAutoDiscover = toolkit.createButton(this.client, Messages.autoDiscover, 0x800000);
        this.buttonAutoDiscover.setLayoutData((Object)new GridData(4, 128, false, false));
        SelectionAdapter excelButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == VariablesSelectionPane.this.buttonAutoDiscover) {
                    final ArrayList commands = new ArrayList();
                    Job job = new Job(VariablesSelectionPane.this.endpointType + " Autodiscover"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask("Starting", -1);
                                SimpleExcelService excelService = new SimpleExcelService();
                                String excelFile = VariablesSelectionPane.this.getConfiguration().getConfigurationDescription().getConfigurationValue("xlFilename");
                                File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
                                String regex = null;
                                regex = VariablesSelectionPane.this.endpointType == EndpointType.INPUT ? "^(I_)[ A-Za-z0-9!\"#$%&'()*+,./:;<=>?@\\^_`{|}~-]*" : "^(O_)[ A-Za-z0-9!\"#$%&'()*+,./:;<=>?@\\^_`{|}~-]*";
                                boolean successful = false;
                                if (excelService.isValidExcelFile(xlFile)) {
                                    ArrayList<String> visitedAdresses = new ArrayList<String>();
                                    ExcelAddress[] excelAddressArray = excelService.getUserDefinedCellNames(xlFile);
                                    int n = excelAddressArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        ExcelAddress addr = excelAddressArray[n2];
                                        if (addr.isUserDefindNameOfScheme(regex)) {
                                            HashMap<String, String> metaData = new HashMap<String, String>();
                                            metaData.put("address", addr.getFullAddress());
                                            boolean exists = false;
                                            for (EndpointDescription endpoint : VariablesSelectionPane.this.endpointManager.getEndpointDescriptions()) {
                                                if (!endpoint.getName().equals(addr.getUserDefinedName())) continue;
                                                exists = true;
                                                break;
                                            }
                                            if (!exists && !visitedAdresses.contains(addr.getFullAddress())) {
                                                visitedAdresses.add(addr.getFullAddress());
                                                AddDynamicEndpointCommand command = new AddDynamicEndpointCommand(VariablesSelectionPane.this.endpointType, VariablesSelectionPane.this.dynEndpointIdToManage, addr.getUserDefinedName(), VariablesSelectionPane.this.endpointManager.getDynamicEndpointDefinition("default").getDefaultDataType(), metaData, (Refreshable[])VariablesSelectionPane.this.allPanes);
                                                commands.add(command);
                                                successful = true;
                                            }
                                        }
                                        ++n2;
                                    }
                                    visitedAdresses.clear();
                                    if (successful) {
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                monitor.worked(1);
                                return null;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    job.addJobChangeListener(new IJobChangeListener(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult() == Status.OK_STATUS) {
                                for (final WorkflowNodeCommand command : commands) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            VariablesSelectionPane.this.execute(command);
                                        }
                                    });
                                }
                            } else if (event.getResult() == Status.CANCEL_STATUS) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageBox dialog = new MessageBox(parent.getShell(), 8);
                                        dialog.setText("Warning!");
                                        dialog.setMessage("No " + VariablesSelectionPane.this.endpointType + " could be added!");
                                        dialog.open();
                                    }
                                });
                            }
                            commands.clear();
                        }

                        public void awake(IJobChangeEvent arg0) {
                        }

                        public void aboutToRun(IJobChangeEvent arg0) {
                        }

                        public void sleeping(IJobChangeEvent arg0) {
                        }

                        public void scheduled(IJobChangeEvent arg0) {
                        }

                        public void running(IJobChangeEvent arg0) {
                        }
                    });
                    job.setUser(true);
                    job.schedule();
                }
            }
        };
        this.buttonAutoDiscover.addSelectionListener((SelectionListener)excelButtonListener);
        this.buttonAdd.addPaintListener((PaintListener)new EnablingPaintListener(this.buttonAdd));
        this.buttonAutoDiscover.addPaintListener((PaintListener)new EnablingPaintListener(this.buttonAutoDiscover));
        return superControl;
    }

    protected void onAddClicked() {
        String excelFile = this.getConfiguration().getConfigurationDescription().getConfigurationValue("xlFilename");
        File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
        SimpleExcelService excelService = new SimpleExcelService();
        if (excelFile != null && !excelFile.isEmpty() && excelService.isValidExcelFile(xlFile)) {
            VariablesEditDialog dialog = new VariablesEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.icon, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>(), xlFile);
            super.onAddClicked((EndpointEditDialog)dialog);
        } else {
            MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 8);
            box.setMessage("Please select an Excel file in the \"File\" section!");
            box.setText("Warning");
            box.open();
        }
    }

    protected void onEditClicked() {
        String excelFile = this.getConfiguration().getConfigurationDescription().getConfigurationValue("xlFilename");
        File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        VariablesEditDialog dialog = new VariablesEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, isStaticEndpoint, this.icon, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData, xlFile);
        super.onEditClicked(name, (EndpointEditDialog)dialog, newMetaData);
    }

    class EnablingPaintListener
    implements PaintListener {
        private Button buttonToEnable = null;

        EnablingPaintListener(Button button) {
            this.buttonToEnable = button;
        }

        public void paintControl(PaintEvent event) {
            String excelFile = VariablesSelectionPane.this.getConfiguration().getConfigurationDescription().getConfigurationValue("xlFilename");
            SimpleExcelService excelService = new SimpleExcelService();
            File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
            if (excelFile == null || excelFile.isEmpty() || !excelService.isValidExcelFile(xlFile)) {
                this.buttonToEnable.setEnabled(false);
            } else {
                this.buttonToEnable.setEnabled(true);
            }
        }
    }
}

