/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.monitoring.common.spi.PeriodicMonitoringDataContributor;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.RemotableSystemMonitoringService;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataService;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationEntryPoint;
import de.rcenvironment.core.monitoring.system.internal.SystemLoadInformationCollector;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringDataServiceImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.modules.objectbindings.api.ObjectBindingsService;
import de.rcenvironment.toolkit.utils.common.DefaultTimeSource;
import de.rcenvironment.toolkit.utils.common.TimeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class SystemMonitoringAggregationServiceImpl
implements RemotableSystemMonitoringService,
LocalSystemMonitoringAggregationService {
    private static final int COMPLETE_SNAPSHOT_CACHE_LIFETIME_MSEC = 2000;
    private static final int SYSTEM_LOAD_INFORMATION_COLLECTION_BUFFER_SIZE = 30;
    private SystemIntegrationAdapter adapter;
    private SystemMonitoringDataService systemDataService;
    private AsyncTaskService asyncTaskService;
    private ObjectBindingsService objectBindingsService;
    private Map<String, String> topicIdToDescriptionMap = new HashMap<String, String>();
    private FullSystemAndProcessDataSnapshot cachedFullSnapshot;
    private long cachedFullSnapshotTimestamp = 0L;
    private final Log log = LogFactory.getLog(SystemMonitoringDataServiceImpl.class);
    private ScheduledFuture<?> systemLoadCollectorFuture;
    private SystemLoadInformationCollector systemLoadInformationCollector;
    private ConcurrencyUtilsFactory concurrencyUtilsFactory;
    private CommunicationService communicationService;

    protected void activate(BundleContext bundleContext) {
        Objects.requireNonNull(this.systemDataService);
        Objects.requireNonNull(this.objectBindingsService);
        Objects.requireNonNull(this.asyncTaskService);
        this.adapter = SystemIntegrationEntryPoint.getAdapter();
        Objects.requireNonNull(this.adapter);
        this.topicIdToDescriptionMap.put("basic_system_data", "Logs basic system monitoring data (total CPU and RAM usage)");
        this.objectBindingsService.addBinding(PeriodicMonitoringDataContributor.class, (Object)this.setUpPeriodicMonitoringDataContributorAdapter(), (Object)this);
        this.systemLoadInformationCollector = new SystemLoadInformationCollector(this.systemDataService, 30, (TimeSource)new DefaultTimeSource(), 500, 5000);
        this.systemLoadCollectorFuture = this.asyncTaskService.scheduleAtFixedRate((Runnable)this.systemLoadInformationCollector, 1000L);
        this.log.debug((Object)"System load collector initialized");
    }

    protected void deactivate(BundleContext bundleContext) {
        this.systemLoadInformationCollector = null;
        this.systemLoadCollectorFuture.cancel(false);
        this.systemLoadCollectorFuture = null;
        this.objectBindingsService.removeAllBindingsOfOwner((Object)this);
    }

    protected void bindObjectBindingsService(ObjectBindingsService newInstance) {
        this.objectBindingsService = newInstance;
    }

    protected void bindSystemMonitoringDataService(SystemMonitoringDataService newInstance) {
        this.systemDataService = newInstance;
    }

    protected void bindAsyncTaskService(AsyncTaskService newInstance) {
        this.asyncTaskService = newInstance;
    }

    protected void bindConcurrencyUtilsFactory(ConcurrencyUtilsFactory newInstance) {
        this.concurrencyUtilsFactory = newInstance;
    }

    protected void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    @Override
    @AllowRemoteAccess
    public synchronized FullSystemAndProcessDataSnapshot getCompleteSnapshot() throws OperatingSystemException {
        FullSystemAndProcessDataSnapshot newSnapshot;
        if (this.hasValidCachedFullSnapshot()) {
            return this.cachedFullSnapshot;
        }
        this.cachedFullSnapshot = newSnapshot = this.createFullSnapshot();
        this.cachedFullSnapshotTimestamp = System.currentTimeMillis();
        return newSnapshot;
    }

    @Override
    @AllowRemoteAccess
    public SystemLoadInformation getSystemLoadInformation(Integer maxSamples) {
        return this.systemLoadInformationCollector.getSystemLoadInformation(maxSamples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ResolvableNodeId> Map<T, SystemLoadInformation> collectSystemMonitoringDataWithTimeLimit(Set<T> nodeIds, final int timeSpanMsec, int timeLimitMsec) throws InterruptedException, ExecutionException, TimeoutException {
        final ConcurrentHashMap concurrentResultMap = new ConcurrentHashMap();
        final int nodeCount = nodeIds.size();
        final Semaphore finishCounter = new Semaphore(0);
        for (final ResolvableNodeId nodeId : nodeIds) {
            this.asyncTaskService.execute(new Runnable(){

                @Override
                @TaskDescription(value="Fetch system load data from a single node")
                public void run() {
                    RemotableSystemMonitoringService remotableService = (RemotableSystemMonitoringService)SystemMonitoringAggregationServiceImpl.this.communicationService.getRemotableService(RemotableSystemMonitoringService.class, nodeId);
                    try {
                        SystemLoadInformation systemLoadInformation = remotableService.getSystemLoadInformation(timeSpanMsec / 1000);
                        concurrentResultMap.put(nodeId, systemLoadInformation);
                    }
                    catch (RemoteOperationException e) {
                        SystemMonitoringAggregationServiceImpl.this.log.warn((Object)("Error while fetching remote system load data: " + e.toString()));
                    }
                    finishCounter.release();
                }
            });
        }
        this.asyncTaskService.scheduleAfterDelay(new Runnable(){

            @Override
            @TaskDescription(value="Enforce time limit while waiting for system load information responses")
            public void run() {
                finishCounter.release(nodeCount);
            }
        }, (long)timeLimitMsec);
        if (!finishCounter.tryAcquire(nodeCount, timeLimitMsec * 2, TimeUnit.MILLISECONDS)) {
            this.log.warn((Object)"Fallback time limit reached while waiting for individual system load data responses");
        }
        ConcurrentHashMap concurrentHashMap = concurrentResultMap;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableMap(new HashMap(concurrentResultMap));
        }
    }

    protected void clearFullSnapshotCache() {
        this.cachedFullSnapshot = null;
        this.cachedFullSnapshotTimestamp = 0L;
    }

    private FullSystemAndProcessDataSnapshot createFullSnapshot() throws OperatingSystemException {
        ArrayList<ProcessInformation> ownProcesses;
        ArrayList<ProcessInformation> subProcesses;
        double systemCPUUsage = this.systemDataService.getTotalCPUUsage();
        double cpuIdle = Double.isNaN(systemCPUUsage) ? Double.NaN : 1.0 - systemCPUUsage;
        long systemRAMUsage = this.systemDataService.getTotalUsedRAM();
        if (this.adapter.areSelfPidsAndProcessStatesAvailable()) {
            subProcesses = this.systemDataService.getFullChildProcessInformation(this.adapter.getSelfJavaPid());
            ownProcesses = new ArrayList();
            ownProcesses.add(new ProcessInformation(this.adapter.getSelfLauncherPid(), this.adapter.getSelfLauncherProcState().getName(), Collections.emptyList(), this.systemDataService.getProcessCPUUsage(this.adapter.getSelfLauncherPid()), this.systemDataService.getProcessRAMUsage(this.adapter.getSelfLauncherPid())));
            ownProcesses.add(new ProcessInformation(this.adapter.getSelfJavaPid(), this.adapter.getSelfJavaProcState().getName(), Collections.emptyList(), this.systemDataService.getProcessCPUUsage(this.adapter.getSelfJavaPid()), this.systemDataService.getProcessRAMUsage(this.adapter.getSelfJavaPid())));
        } else {
            subProcesses = new ArrayList();
            ownProcesses = new ArrayList<ProcessInformation>();
        }
        return new FullSystemAndProcessDataSnapshot(systemCPUUsage, systemRAMUsage, this.systemDataService.getTotalSystemRAM(), cpuIdle, subProcesses, ownProcesses);
    }

    private String createSimpleSystemMonitoringSummary() {
        try {
            long systemRamUsage;
            long ram;
            double nodeCpuUsage;
            if (this.hasValidCachedFullSnapshot()) {
                nodeCpuUsage = this.cachedFullSnapshot.getNodeCPUusage();
                ram = this.cachedFullSnapshot.getNodeSystemRAM();
                systemRamUsage = this.cachedFullSnapshot.getNodeRAMUsage();
            } else {
                ram = this.systemDataService.getTotalSystemRAM();
                nodeCpuUsage = this.systemDataService.getTotalCPUUsage();
                systemRamUsage = this.systemDataService.getTotalUsedRAM();
            }
            return StringUtils.format((String)"System CPU usage: %.2f%%, System RAM usage: %d / %d MiB", (Object[])new Object[]{nodeCpuUsage * 100.0, systemRamUsage, ram});
        }
        catch (OperatingSystemException e) {
            return "Error gathering system data: " + e.getMessage();
        }
    }

    private boolean hasValidCachedFullSnapshot() {
        return this.cachedFullSnapshotTimestamp >= System.currentTimeMillis() - 2000L && this.cachedFullSnapshot != null;
    }

    private String logDetailedMonitoringData() {
        if (this.hasValidCachedFullSnapshot()) {
            return this.cachedFullSnapshot.toString();
        }
        try {
            return this.getCompleteSnapshot().toString();
        }
        catch (OperatingSystemException e) {
            this.log.error((Object)e);
            return "<error>";
        }
    }

    private PeriodicMonitoringDataContributor setUpPeriodicMonitoringDataContributorAdapter() {
        return new PeriodicMonitoringDataContributor(){

            @Override
            public Collection<String> getTopicIds() {
                return SystemMonitoringAggregationServiceImpl.this.topicIdToDescriptionMap.keySet();
            }

            @Override
            public String getTopicDescription(String topicId) {
                return (String)SystemMonitoringAggregationServiceImpl.this.topicIdToDescriptionMap.get(topicId);
            }

            @Override
            public void generateOutput(String topicId, List<String> collection) {
                switch (topicId) {
                    case "basic_system_data": {
                        collection.add(SystemMonitoringAggregationServiceImpl.this.createSimpleSystemMonitoringSummary());
                        break;
                    }
                    case "detailed_system_data": {
                        collection.add(SystemMonitoringAggregationServiceImpl.this.logDetailedMonitoringData());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("There is no topic id such as: " + topicId);
                    }
                }
            }
        };
    }
}

