/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.internal.PTQLWrapper;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringUtils;
import de.rcenvironment.core.utils.common.OSFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ptql.ProcessFinder;

public class SIGARSystemIntegrationAdapter
implements SystemIntegrationAdapter {
    private static final String SIGAR_ERROR_MESSAGE_NO_SUCH_PROCESS = "No such process";
    private static final String SIGAR_ERROR_MESSAGE_ACCESS_DENIED = "Access is denied.";
    private static final int TOTAL_CPU_NAN_MAX_RETRY_COUNT = 50;
    private static final int TOTAL_CPU_NAN_RETRY_WAIT_MSEC = 1;
    private static final String MAY_RETRY_LATER_TEXT = "a new attempt may be made later: ";
    private static final int CONVERSION_FACTOR_1K = 1024;
    private static final double CONVERSION_FACTOR_PERCENT = 100.0;
    private static final int SIG_ID_KILL = 15;
    private static final int SIG_ID_FORCE_KILL = -9;
    private final Sigar sigarInstance = new Sigar();
    private long cachedTotalSystemRam;
    private long selfJavaPid = 0L;
    private ProcState selfJavaProcState = null;
    private long selfLauncherPid = 0L;
    private ProcState selfLauncherProcState = null;
    private final Log log = LogFactory.getLog(this.getClass());

    public SIGARSystemIntegrationAdapter() throws OperatingSystemException {
        this.cachedTotalSystemRam = this.fetchTotalSystemRAM();
        if (!this.areSelfPidsAndProcessStatesAvailable()) {
            this.log.debug((Object)"Failed to initialize process states for system monitoring, will retry later");
        }
    }

    public static boolean shouldAttemptToInitialize() {
        return !OSFamily.isWindows();
    }

    @Override
    public boolean isProvidingActualSystemData() {
        return true;
    }

    @Override
    public long getCachedTotalSystemRam() {
        return this.cachedTotalSystemRam;
    }

    @Override
    public boolean areSelfPidsAndProcessStatesAvailable() {
        if (this.selfJavaPid == 0L) {
            this.selfJavaPid = Humidor.getInstance().getSigar().getPid();
            this.log.debug((Object)("Java process ID: " + this.selfJavaPid));
        }
        if (this.selfJavaPid != 0L && this.selfJavaProcState == null) {
            try {
                this.selfJavaProcState = this.fetchProcessState(this.selfJavaPid);
            }
            catch (OperatingSystemException e) {
                this.log.debug((Object)("Failed to determine the JVM's process state; a new attempt may be made later: " + e.toString()));
            }
        }
        if (this.selfJavaPid != 0L && this.selfLauncherPid == 0L) {
            try {
                this.selfLauncherPid = this.fetchProcessState(this.selfJavaPid).getPpid();
                this.log.debug((Object)("Launcher process ID: " + this.selfLauncherPid));
            }
            catch (OperatingSystemException e) {
                this.log.debug((Object)("Failed to determine the ID of the launcher process; a new attempt may be made later: " + e.toString()));
            }
        }
        if (this.selfLauncherPid != 0L && this.selfLauncherProcState == null) {
            try {
                this.selfLauncherProcState = this.fetchProcessState(this.selfLauncherPid);
            }
            catch (OperatingSystemException e) {
                this.log.debug((Object)("Failed to determine the launcher's process state; a new attempt may be made later: " + e.toString()));
            }
        }
        return this.selfJavaPid != 0L && this.selfJavaProcState != null && this.selfLauncherPid != 0L && this.selfLauncherProcState != null;
    }

    @Override
    public long getSelfJavaPid() {
        return this.selfJavaPid;
    }

    @Override
    public ProcState getSelfJavaProcState() {
        return this.selfJavaProcState;
    }

    @Override
    public long getSelfLauncherPid() {
        return this.selfLauncherPid;
    }

    @Override
    public ProcState getSelfLauncherProcState() {
        return this.selfLauncherProcState;
    }

    @Override
    public ProcState fetchProcessState(long pid) throws OperatingSystemException {
        try {
            return Humidor.getInstance().getSigar().getProcState(pid);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException((Object)((Object)OperatingSystemException.ErrorType.FAILED_TO_GET_PROCESS_STATE) + " for process with pid: " + pid);
        }
    }

    @Override
    public double getTotalCPUUsage() throws OperatingSystemException {
        try {
            double cpuUsage;
            block7: {
                SigarProxy sigarProxy = Humidor.getInstance().getSigar();
                cpuUsage = sigarProxy.getCpuPerc().getCombined();
                if (Double.isNaN(cpuUsage)) {
                    int retryCount = 1;
                    while (true) {
                        if (!Double.isNaN(cpuUsage = sigarProxy.getCpuPerc().getCombined())) {
                            this.log.debug((Object)("Fetched valid CPU load data after " + retryCount + " immediate retries"));
                            break block7;
                        }
                        if (retryCount >= 50) break;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE, "Interrupted while waiting for CPU load data retry");
                        }
                        ++retryCount;
                    }
                    throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE, "Failed to fetch valid CPU load data even after " + retryCount + " immediate retries");
                }
            }
            return SystemMonitoringUtils.clampToPercentageOrNAN(cpuUsage);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProcessCPUUsage(Long pid) throws OperatingSystemException {
        Sigar sigar;
        double processCPUusage = 0.0;
        int watch = 0;
        try {
            if (pid == null) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
            }
            do {
                sigar = this.sigarInstance;
                synchronized (sigar) {
                    processCPUusage = this.sigarInstance.getProcCpu(pid.longValue()).getPercent();
                }
                if (++watch != 10) continue;
                return processCPUusage;
            } while (processCPUusage == 0.0);
        }
        catch (SigarException e) {
            if (e.getMessage().contains(SIGAR_ERROR_MESSAGE_NO_SUCH_PROCESS)) {
                throw OperatingSystemException.createNoSuchProcessException(pid);
            }
            if (e.getMessage().contains(SIGAR_ERROR_MESSAGE_ACCESS_DENIED)) {
                throw OperatingSystemException.createAccessDeniedException(pid);
            }
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_CPU_PROCESS_USAGE, " of process with pid: " + pid);
        }
        sigar = this.sigarInstance;
        synchronized (sigar) {
            try {
            }
            catch (SigarException sigarException) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CPU_LIST);
            }
        }
        return SystemMonitoringUtils.clampToPercentageOrNAN(processCPUusage /= (double)this.sigarInstance.getCpuList().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getReportedCPUIdle() throws OperatingSystemException {
        try {
            double idle = 0.0;
            Sigar sigar = this.sigarInstance;
            synchronized (sigar) {
                idle = this.sigarInstance.getCpuPerc().getIdle();
            }
            return SystemMonitoringUtils.clampToPercentageOrNAN(idle);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_IDLE);
        }
    }

    @Override
    public long getProcessRAMUsage(Long pid) throws OperatingSystemException {
        try {
            if (pid == null) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
            }
            return Humidor.getInstance().getSigar().getProcMem(pid.longValue()).getResident() / 0x100000L;
        }
        catch (SigarException e) {
            if (e.getMessage().contains(SIGAR_ERROR_MESSAGE_NO_SUCH_PROCESS)) {
                throw OperatingSystemException.createNoSuchProcessException(pid);
            }
            if (e.getMessage().contains(SIGAR_ERROR_MESSAGE_ACCESS_DENIED)) {
                throw OperatingSystemException.createAccessDeniedException(pid);
            }
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_RAM_PROCESS_USAGE, " of process with pid: " + pid);
        }
    }

    @Override
    public long getTotalSystemRAM() throws OperatingSystemException {
        return this.getCachedTotalSystemRam();
    }

    @Override
    public long getTotalUsedRAM() throws OperatingSystemException {
        return (long)((double)this.getCachedTotalSystemRam() * this.getTotalUsedRAMPercentage());
    }

    @Override
    public long getFreeRAM() throws OperatingSystemException {
        return (long)((double)this.getCachedTotalSystemRam() * (1.0 - this.getTotalUsedRAMPercentage()));
    }

    @Override
    public double getTotalUsedRAMPercentage() throws OperatingSystemException {
        try {
            return Humidor.getInstance().getSigar().getMem().getUsedPercent() / 100.0;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM_PERCENTAGE);
        }
    }

    @Override
    public double getProcessRAMPercentage(Long pid) throws OperatingSystemException {
        long totalRam = this.getTotalSystemRAM();
        if (totalRam == 0L) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM_PERCENTAGE);
        }
        long ram = this.getProcessRAMUsage(pid);
        return ram / totalRam;
    }

    @Override
    public long getUsedLocalDiskSpace() throws OperatingSystemException {
        return this.getFileSystemUsage().getUsed();
    }

    @Override
    public long getFreeLocalDiskSpace() throws OperatingSystemException {
        return this.getFileSystemUsage().getFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> getProcesses() throws OperatingSystemException {
        try {
            HashMap<Long, String> processMap = new HashMap<Long, String>();
            List<Long> processList = Arrays.asList(ArrayUtils.toObject((long[])Humidor.getInstance().getSigar().getProcList()));
            for (Long pid : processList) {
                Sigar sigar = this.sigarInstance;
                synchronized (sigar) {
                    long[] pids;
                    long[] lArray = pids = ProcessFinder.find((Sigar)this.sigarInstance, (String)(String.valueOf(PTQLWrapper.createQuery().createQueryString(PTQLWrapper.pid(), PTQLWrapper.eq())) + pid));
                    int n = pids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long process = lArray[n2];
                        processMap.put(process, Humidor.getInstance().getSigar().getProcState(process).getName());
                        ++n2;
                    }
                }
            }
            return processMap;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_PROCESS_LIST);
        }
    }

    @Override
    public Map<Long, String> getChildProcessesAndIds(Long pid) throws OperatingSystemException {
        if (pid == null) {
            return Collections.emptyMap();
        }
        List<ProcessInformation> childList = this.getFullChildProcessInformation(pid);
        HashMap<Long, String> childMap = new HashMap<Long, String>();
        if (!childList.isEmpty()) {
            for (ProcessInformation process : childList) {
                childMap.put(process.getPid(), process.getName());
            }
        }
        return childMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(Long pid, Boolean force) throws OperatingSystemException {
        block11: {
            try {
                this.log.info((Object)("Killing process with pid: " + pid));
                if (force.booleanValue()) {
                    Sigar sigar = this.sigarInstance;
                    synchronized (sigar) {
                        this.sigarInstance.kill(pid.longValue(), -9);
                        break block11;
                    }
                }
                Sigar sigar = this.sigarInstance;
                synchronized (sigar) {
                    this.sigarInstance.kill(pid.longValue(), 15);
                }
            }
            catch (SigarException e) {
                if (e.getMessage().contains("The parameter is incorrect.")) {
                    this.log.error((Object)("Failed to shut down process caused by incorrect parameters. The process with pid: " + pid + " may already be dead."));
                    return;
                }
                if (e.getMessage().contains(SIGAR_ERROR_MESSAGE_ACCESS_DENIED)) {
                    throw OperatingSystemException.createAccessDeniedException(pid);
                }
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_KILL_PROCESS, " with pid: " + pid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessInformation> getFullChildProcessInformation(long pid) throws OperatingSystemException {
        long[] pids = null;
        ArrayList<ProcessInformation> children = null;
        Sigar sigar = this.sigarInstance;
        synchronized (sigar) {
            try {
                pids = ProcessFinder.find((Sigar)this.sigarInstance, (String)(String.valueOf(PTQLWrapper.createQuery().createQueryString(PTQLWrapper.statePPID(), PTQLWrapper.eq())) + pid));
            }
            catch (SigarException e) {
                if (e.getMessage().equals(SIGAR_ERROR_MESSAGE_ACCESS_DENIED)) {
                    throw OperatingSystemException.createAccessDeniedException(pid);
                }
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CHILD_PROCESS_LIST, " of parent process with pid: " + pid);
            }
        }
        if (pids != null && pids.length > 0) {
            children = new ArrayList<ProcessInformation>();
            long[] lArray = pids;
            int n = pids.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    ProcessInformation p;
                    Long child = lArray[n2];
                    try {
                        p = new ProcessInformation(child, this.fetchProcessState(child).getName(), this.getFullChildProcessInformation(child), this.getProcessCPUUsage(child), this.getProcessRAMUsage(child));
                    }
                    catch (OperatingSystemException e) {
                        if (e.getErrorType().equals((Object)OperatingSystemException.ErrorType.NO_SUCH_PROCESS)) {
                            this.log.info((Object)("Couldn't find process with pid: " + child + ". Process might already be dead."));
                            break block12;
                        }
                        throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CHILD_PROCESS_LIST, " of parent process with pid: " + pid);
                    }
                    children.add(p);
                }
                ++n2;
            }
        }
        if (children != null) {
            return children;
        }
        return Collections.emptyList();
    }

    private long fetchTotalSystemRAM() throws OperatingSystemException {
        try {
            long ramValue = Humidor.getInstance().getSigar().getMem().getRam();
            if (ramValue == 0L) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM);
            }
            return ramValue;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM);
        }
    }

    private FileSystemUsage getFileSystemUsage() throws OperatingSystemException {
        FileSystem[] fileSystemList;
        try {
            fileSystemList = Humidor.getInstance().getSigar().getFileSystemList();
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_FILE_SYSTEM);
        }
        FileSystem[] fileSystemArray = fileSystemList;
        int n = fileSystemList.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fs = fileSystemArray[n2];
            if (fs.getType() == 2) {
                try {
                    return Humidor.getInstance().getSigar().getFileSystemUsage(fs.getDirName());
                }
                catch (SigarException sigarException) {
                    throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_FILE_SYSTEM_USAGE);
                }
            }
            ++n2;
        }
        this.log.warn((Object)"No local file system found; returning dummy usage data");
        return new FileSystemUsage();
    }
}

