/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.RemotableFileDataService;
import de.rcenvironment.core.datamanagement.backend.DataBackend;
import de.rcenvironment.core.datamanagement.commons.BinaryReference;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamanagement.internal.BackendSupport;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Exchanger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class FileDataServiceImpl
implements FileDataService {
    private static final String UPLOAD_BLOCK_SIZE_PROPERTY = "communication.uploadBlockSize";
    private static final int DOWNLOAD_STREAM_BUFFER_SIZE = 262144;
    private static final int DEFAULT_UPLOAD_CHUNK_SIZE = 262144;
    private static final int MINIMUM_UPLOAD_CHUNK_SIZE = 8192;
    private static final long CHUNK_UPLOAD_TIME_WARNING_THRESHOLD_MSEC = 25000L;
    private static final int REMOTE_REFERENCE_POLLING_INTERVAL_MSEC = 1000;
    private static final int END_OF_STREAM_MARKER = -1;
    private static final String DRCE_DEACTIVATE_SINGLE_STEP_UPDATE = "rce.upload.deactivateSingleStepUpdate";
    private PlatformService platformService;
    private final Log log = LogFactory.getLog(this.getClass());
    private final int uploadChunkSize;
    private CommunicationService communicationService;

    public FileDataServiceImpl() {
        int tempHolder = 262144;
        String chunkSizeArg = System.getProperty(UPLOAD_BLOCK_SIZE_PROPERTY);
        if (chunkSizeArg != null) {
            try {
                int parsedValue = Integer.parseInt(chunkSizeArg);
                if (parsedValue >= 8192) {
                    tempHolder = parsedValue;
                } else {
                    this.log.error((Object)"Invalid upload block size specified: minimum value is 8192");
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"Failed to parse communication.uploadBlockSize setting; using default", (Throwable)e);
            }
        }
        this.uploadChunkSize = tempHolder;
        this.log.debug((Object)("Using remote upload block size " + this.uploadChunkSize));
    }

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.communicationService = newCommunicationService;
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    @Override
    public InputStream getStreamFromDataReference(DataReference dataReference) throws AuthorizationException, CommunicationException {
        try {
            InputStream rawStream = this.getRemoteFileDataService((ResolvableNodeId)dataReference.getStorageNodeId()).getStreamFromDataReference(dataReference, !this.platformService.matchesLocalInstance((ResolvableNodeId)dataReference.getStorageNodeId()));
            return new BufferedInputStream(rawStream, 262144);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to get stream from data reference from remote node %s: ", (Object[])new Object[]{dataReference.getStorageNodeId()})) + e.getMessage());
        }
    }

    @Override
    public DataReference newReferenceFromStream(InputStream inputStream, MetaDataSet metaDataSet, ResolvableNodeId platform) throws AuthorizationException, IOException, InterruptedException, CommunicationException {
        if (platform == null) {
            platform = this.platformService.getLocalInstanceNodeSessionId();
        }
        if (this.platformService.matchesLocalInstance(platform)) {
            try {
                return this.getRemoteFileDataService(platform).newReferenceFromStream(inputStream, metaDataSet);
            }
            catch (RemoteOperationException e) {
                throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to create new data reference from stream from remote node @%s: ", (Object[])new Object[]{platform})) + e.getMessage());
            }
        }
        return this.performRemoteUpload(inputStream, metaDataSet, platform);
    }

    private DataReference performRemoteUpload(InputStream inputStream, MetaDataSet metaDataSet, final ResolvableNodeId remoteNodeId) throws InterruptedException, IOException, CommunicationException {
        final RemotableFileDataService remoteDataService = (RemotableFileDataService)this.communicationService.getRemotableService(RemotableFileDataService.class, remoteNodeId);
        try {
            DataReference reference;
            ChunkBuffer readBuffer = new ChunkBuffer(this.uploadChunkSize);
            readBuffer.fillFromStream(inputStream);
            if (!System.getProperties().containsKey(DRCE_DEACTIVATE_SINGLE_STEP_UPDATE) && readBuffer.getContentSize() < this.uploadChunkSize) {
                this.log.debug((Object)"Data to upload is smaller than chunk size: performing upload in single step.");
                DataReference reference2 = remoteDataService.uploadInSingleStep(readBuffer.getContentSizeBuffer(), metaDataSet);
                return reference2;
            }
            final String uploadId = remoteDataService.initializeUpload();
            if (uploadId == null) {
                throw new NullPointerException("Received null upload id");
            }
            this.log.debug((Object)("Received remote upload id " + uploadId));
            AsyncBufferUploader asyncUploader = new AsyncBufferUploader(this, this.uploadChunkSize){
                private long localTotalSize;
                {
                    super($anonymous0);
                    this.localTotalSize = 0L;
                }

                @Override
                protected void sendSingleBuffer(ChunkBuffer filledBuffer) throws IOException {
                    long remoteTotalSize;
                    long startTime = System.currentTimeMillis();
                    try {
                        remoteTotalSize = remoteDataService.appendToUpload(uploadId, filledBuffer.getContentSizeBuffer());
                    }
                    catch (RemoteOperationException e) {
                        throw new RuntimeException(String.valueOf(StringUtils.format((String)"Failed to create new data reference from stream from remote node @%s: ", (Object[])new Object[]{remoteNodeId})) + e.getMessage());
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    if (duration > 25000L) {
                        log.warn((Object)StringUtils.format((String)"Uploading a data block of %d bytes took %d msec", (Object[])new Object[]{filledBuffer.getContentSize(), duration}));
                    }
                    this.localTotalSize += (long)filledBuffer.getContentSize();
                    if (this.localTotalSize != remoteTotalSize) {
                        throw new IllegalStateException("Consistency error: Local and remote write counts are not equal!");
                    }
                }
            };
            ConcurrencyUtils.getAsyncTaskService().execute((Runnable)asyncUploader);
            long totalRead2 = 0L;
            do {
                totalRead2 += (long)readBuffer.getContentSize();
            } while ((readBuffer = asyncUploader.swapBuffersWhenReady(readBuffer)).fillFromStream(inputStream));
            if (readBuffer.getContentSize() > 0) {
                totalRead2 += (long)readBuffer.getContentSize();
                readBuffer = asyncUploader.swapBuffersWhenReady(readBuffer);
            }
            asyncUploader.shutDown();
            remoteDataService.finishUpload(uploadId, metaDataSet);
            this.log.debug((Object)StringUtils.format((String)"Finished uploading %d bytes for upload id %s; polling for remote data reference", (Object[])new Object[]{totalRead2, uploadId}));
            do {
                Thread.sleep(1000L);
            } while ((reference = remoteDataService.pollUploadForDataReference(uploadId)) == null);
            this.log.debug((Object)("Received remote data reference for upload id " + uploadId));
            return reference;
        }
        catch (IOException e) {
            throw new IOException("Error uploading file", e);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to perform remote upload to node @%s: ", (Object[])new Object[]{remoteNodeId})) + e.getMessage());
        }
    }

    @Override
    public void deleteReference(DataReference dataReference) throws CommunicationException {
        try {
            for (BinaryReference br : dataReference.getBinaryReferences()) {
                this.getRemoteFileDataService((ResolvableNodeId)dataReference.getStorageNodeId()).deleteReference(br.getBinaryReferenceKey());
            }
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to delete data reference on remote node %s: ", (Object[])new Object[]{dataReference.getStorageNodeId()})) + e.getMessage());
        }
    }

    private RemotableFileDataService getRemoteFileDataService(ResolvableNodeId nodeId) throws RemoteOperationException {
        return (RemotableFileDataService)this.communicationService.getRemotableService(RemotableFileDataService.class, nodeId);
    }

    @Override
    public void deleteReference(String binaryReferenceKey) throws RemoteOperationException {
        DataBackend dataService = BackendSupport.getDataBackend();
        URI location = dataService.suggestLocation(UUID.fromString(binaryReferenceKey));
        dataService.delete(location);
    }

    private abstract class AsyncBufferUploader
    implements Runnable {
        private int bufferSize;
        private Exchanger<ChunkBuffer> exchanger = new Exchanger();

        AsyncBufferUploader(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        @TaskDescription(value="Async upload")
        public void run() {
            ChunkBuffer readyToReturnBuffer = new ChunkBuffer(this.bufferSize);
            try {
                while (true) {
                    ChunkBuffer filledBuffer;
                    if ((filledBuffer = this.exchanger.exchange(readyToReturnBuffer)) == null) {
                        FileDataServiceImpl.this.log.debug((Object)"Async uploader shutting down");
                        break;
                    }
                    try {
                        this.sendSingleBuffer(filledBuffer);
                    }
                    catch (IOException e) {
                        FileDataServiceImpl.this.log.debug((Object)"I/O exception during async upload", (Throwable)e);
                        filledBuffer.setExceptionOnWrite(e);
                        this.exchanger.exchange(filledBuffer);
                        break;
                    }
                    readyToReturnBuffer = filledBuffer;
                }
            }
            catch (InterruptedException interruptedException) {
                FileDataServiceImpl.this.log.warn((Object)"Async upload thread interrupted");
            }
        }

        protected abstract void sendSingleBuffer(ChunkBuffer var1) throws IOException;

        ChunkBuffer getInitialEmptyBuffer() {
            ChunkBuffer firstBuffer = new ChunkBuffer(this.bufferSize);
            return firstBuffer;
        }

        ChunkBuffer swapBuffersWhenReady(ChunkBuffer filledBuffer) throws InterruptedException, IOException {
            ChunkBuffer returnedBuffer = this.exchanger.exchange(filledBuffer);
            IOException exceptionOnWrite = returnedBuffer.getExceptionOnWrite();
            if (exceptionOnWrite != null) {
                throw exceptionOnWrite;
            }
            return returnedBuffer;
        }

        void shutDown() throws InterruptedException, IOException {
            ChunkBuffer returnedBuffer = this.exchanger.exchange(null);
            IOException exceptionOnWrite = returnedBuffer.getExceptionOnWrite();
            if (exceptionOnWrite != null) {
                throw exceptionOnWrite;
            }
        }
    }

    private final class ChunkBuffer {
        private byte[] buffer;
        private int contentSize;
        private IOException exceptionOnWrite;

        ChunkBuffer(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.contentSize = 0;
        }

        public void setExceptionOnWrite(IOException e) {
            this.exceptionOnWrite = e;
        }

        public IOException getExceptionOnWrite() {
            return this.exceptionOnWrite;
        }

        public int getContentSize() {
            return this.contentSize;
        }

        public byte[] getContentSizeBuffer() {
            if (this.contentSize == this.buffer.length) {
                return this.buffer;
            }
            return Arrays.copyOf(this.buffer, this.contentSize);
        }

        public boolean fillFromStream(InputStream inputStream) throws IOException {
            int actualRead = inputStream.read(this.buffer);
            if (actualRead == 0) {
                throw new IllegalStateException("Read zero bytes");
            }
            this.contentSize = actualRead >= 0 ? actualRead : 0;
            while (actualRead < this.buffer.length && actualRead != -1) {
                actualRead = inputStream.read(this.buffer, this.contentSize, this.buffer.length - this.contentSize);
                if (actualRead == 0) {
                    throw new IllegalStateException("Read zero bytes");
                }
                if (actualRead <= 0) continue;
                this.contentSize += actualRead;
            }
            return actualRead != -1;
        }
    }
}

