/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import de.rcenvironment.core.start.validators.internal.ProfileDirectoryVersionValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ProfileDirectoryNotInUseValidator
extends DefaultInstanceValidator {
    private static ConfigurationService configService;

    public InstanceValidationResult validate() {
        if (!configService.isIntendedProfileDirectorySuccessfullyLocked()) {
            String errorMessage = StringUtils.format((String)Messages.instanceIdAlreadyInUse, (Object[])new Object[]{configService.getOriginalProfileDirectory().getAbsolutePath()});
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"Profile directory lock", (String)errorMessage, (String)errorMessage);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Profile directory lock");
    }

    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }

    public List<Class<? extends InstanceValidator>> getNecessaryPredecessors() {
        ArrayList<Class<? extends InstanceValidator>> predecessors = new ArrayList<Class<? extends InstanceValidator>>();
        predecessors.add(ProfileDirectoryVersionValidator.class);
        return predecessors;
    }
}

