/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.sshremoteaccess.internal;

import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.registration.api.ComponentRegistry;
import de.rcenvironment.core.component.sshremoteaccess.SshRemoteAccessClientService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshRemoteAccessClientServiceImpl
implements SshRemoteAccessClientService {
    private static final int SIZE_32 = 32;
    private static final int SIZE_16 = 16;
    private static final Log LOG = LogFactory.getLog(SshRemoteAccessClientService.class);
    private static final int UPDATE_TOOLS_INTERVAL_SECS = 10;
    private static ComponentRegistry registry;
    private PlatformService platformService;
    private SshConnectionService sshService;
    private Map<String, Map<String, ComponentInstallation>> registeredComponentsPerConnection = new HashMap<String, Map<String, ComponentInstallation>>();
    private ScheduledFuture<?> taskFuture;
    private volatile boolean started;
    private Map<String, LogicalNodeId> logicalNodeMap = new HashMap<String, LogicalNodeId>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateSshRemoteAccessComponents(String connectionId) {
        ArrayList<String> componentIdsReceived;
        Map<String, ComponentInstallation> registeredComponents;
        block55: {
            InputStream stderrStream22;
            Object stdoutStream;
            String toolDescriptionsString;
            String command;
            JSchRCECommandLineExecutor executor;
            block52: {
                registeredComponents = this.registeredComponentsPerConnection.get(connectionId);
                if (registeredComponents == null) {
                    registeredComponents = new HashMap<String, ComponentInstallation>();
                    this.registeredComponentsPerConnection.put(connectionId, registeredComponents);
                }
                Session session = null;
                session = this.sshService.getAvtiveSshSession(connectionId);
                if (session == null) return;
                executor = new JSchRCECommandLineExecutor(session);
                componentIdsReceived = new ArrayList<String>();
                command = StringUtils.format((String)"ra list-tools", (Object[])new Object[0]);
                toolDescriptionsString = "";
                try {
                    executor.start(command);
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try {
                        stdoutStream = executor.getStdout();
                        try {
                            stderrStream22 = executor.getStderr();
                            try {
                                executor.waitForTermination();
                                toolDescriptionsString = IOUtils.toString((InputStream)stdoutStream);
                            }
                            finally {
                                if (stderrStream22 != null) {
                                    stderrStream22.close();
                                }
                            }
                            if (stdoutStream == null) break block52;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (stdoutStream == null) throw throwable;
                            ((InputStream)stdoutStream).close();
                            throw throwable;
                        }
                        ((InputStream)stdoutStream).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException | InterruptedException e1) {
                    LOG.error((Object)"Executing SSH command (ra list-tools) failed", (Throwable)e1);
                }
            }
            CSVFormat csvFormat = CSVFormat.newFormat((char)' ').withQuote('\"').withQuoteMode(QuoteMode.ALL);
            CSVParser parser = null;
            try {
                stdoutStream = null;
                stderrStream22 = null;
                try (StringReader toolDescriptionReader = new StringReader(toolDescriptionsString);){
                    parser = csvFormat.parse((Reader)toolDescriptionReader);
                    for (CSVRecord record : parser.getRecords()) {
                        String toolName = record.get(0);
                        String toolVersion = record.get(1);
                        String hostId = record.get(2);
                        String hostName = record.get(3);
                        String toolId = toolName;
                        String toolAndHostId = this.createUniqueToolAndHostId(toolId, hostId, connectionId);
                        if (!registeredComponents.containsKey(toolAndHostId)) {
                            LOG.info((Object)StringUtils.format((String)"Detected new SSH tool %s (version %s) on host %s.", (Object[])new Object[]{toolName, toolVersion, hostName}));
                            this.registerToolAccessComponent(toolId, toolName, toolVersion, hostName, hostId, connectionId, false);
                        } else if (!registeredComponents.get(toolAndHostId).getComponentRevision().getComponentInterface().getVersion().equals(toolVersion)) {
                            this.removeToolAccessComponent(toolAndHostId, connectionId);
                            this.registerToolAccessComponent(toolId, toolName, toolVersion, hostName, hostId, connectionId, false);
                            LOG.info((Object)StringUtils.format((String)"SSH tool %s changed to version %s on host %s.", (Object[])new Object[]{toolName, toolVersion, hostName}));
                        }
                        componentIdsReceived.add(toolAndHostId);
                    }
                }
                catch (Throwable stderrStream22) {
                    if (stdoutStream == null) {
                        stdoutStream = stderrStream22;
                        throw stdoutStream;
                    }
                    if (stdoutStream == stderrStream22) throw stdoutStream;
                    ((Throwable)stdoutStream).addSuppressed(stderrStream22);
                    throw stdoutStream;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Could not parse tool descriptions" + e.toString()));
            }
            command = StringUtils.format((String)"ra list-wfs", (Object[])new Object[0]);
            try {
                executor.start(command);
                Throwable e = null;
                stderrStream22 = null;
                try {
                    InputStream stdoutStream2 = executor.getStdout();
                    try {
                        try (InputStream stderrStream = executor.getStderr();){
                            LineIterator it = IOUtils.lineIterator((InputStream)stdoutStream2, null);
                            Integer numberOfWorkflows = null;
                            Integer tokensPerWorkflow = null;
                            if (it.hasNext()) {
                                numberOfWorkflows = Integer.parseInt(it.nextLine());
                            }
                            if (it.hasNext()) {
                                tokensPerWorkflow = Integer.parseInt(it.nextLine());
                            }
                            if (numberOfWorkflows != null && tokensPerWorkflow != null) {
                                if (tokensPerWorkflow != 4) {
                                    LOG.error((Object)"Unkown format of workflow descriptions");
                                } else {
                                    int i = 0;
                                    while (i < numberOfWorkflows) {
                                        String wfName = it.nextLine();
                                        String wfVersion = it.nextLine();
                                        String hostId = it.nextLine();
                                        String hostName = it.nextLine();
                                        String componentId = String.valueOf(wfName) + "_wf_" + hostId;
                                        String toolAndHostId = this.createUniqueToolAndHostId(componentId, hostId, connectionId);
                                        if (!registeredComponents.containsKey(toolAndHostId)) {
                                            LOG.info((Object)StringUtils.format((String)"Detected new remote workflow %s (version %s) on host %s.", (Object[])new Object[]{wfName, wfVersion, hostName}));
                                            this.registerToolAccessComponent(componentId, wfName, wfVersion, hostName, hostId, connectionId, true);
                                        }
                                        componentIdsReceived.add(toolAndHostId);
                                        ++i;
                                    }
                                }
                            }
                            executor.waitForTermination();
                        }
                        if (stdoutStream2 == null) break block55;
                    }
                    catch (Throwable stderrStream22) {
                        if (e == null) {
                            e = stderrStream22;
                        } else if (e != stderrStream22) {
                            e.addSuppressed(stderrStream22);
                        }
                        if (stdoutStream2 == null) throw e;
                        stdoutStream2.close();
                        throw e;
                    }
                    stdoutStream2.close();
                }
                catch (Throwable stderrStream22) {
                    if (e == null) {
                        e = stderrStream22;
                        throw e;
                    }
                    if (e == stderrStream22) throw e;
                    e.addSuppressed(stderrStream22);
                    throw e;
                }
            }
            catch (IOException | InterruptedException e1) {
                LOG.error((Object)"Executing SSH command (ra list-wfs) failed", (Throwable)e1);
            }
        }
        Iterator<String> it = registeredComponents.keySet().iterator();
        while (it.hasNext()) {
            String regCompName = it.next();
            if (componentIdsReceived.contains(regCompName)) continue;
            this.removeToolAccessComponent(regCompName, connectionId);
            it.remove();
        }
        return;
    }

    private String createUniqueToolAndHostId(String toolId, String hostId, String connectionId) {
        return String.valueOf(toolId) + "/" + connectionId + "/" + hostId;
    }

    protected void registerToolAccessComponent(String componentId, String toolName, String toolVersion, String hostName, String hostId, String connectionId, boolean isWorkflow) {
        Set<EndpointDefinition> inputs = this.createInputs();
        EndpointDefinitionsProvider inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputs);
        Set<EndpointDefinition> outputs = this.createOutputs();
        EndpointDefinitionsProvider outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputs);
        ConfigurationDefinition configuration = this.generateConfiguration(toolName, toolVersion, hostName, hostId, connectionId, isWorkflow);
        ComponentInterface componentInterface = isWorkflow ? new ComponentInterfaceBuilder().setIdentifier("de.rcenvironment.remoteaccess." + componentId).setDisplayName(StringUtils.format((String)"%s (%s) [workflow on %s]", (Object[])new Object[]{toolName, toolVersion, hostName})).setIcon16(this.readDefaultToolIcon(16)).setIcon32(this.readDefaultToolIcon(32)).setGroupName("SSH Remote Access Workflows").setVersion(toolVersion).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build() : new ComponentInterfaceBuilder().setIdentifier("de.rcenvironment.remoteaccess." + componentId).setDisplayName(StringUtils.format((String)"%s [SSH forwarded]", (Object[])new Object[]{toolName})).setIcon16(this.readDefaultToolIcon(16)).setIcon32(this.readDefaultToolIcon(32)).setGroupName("SSH Remote Access Tools").setVersion(toolVersion).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build();
        ComponentInstallation ci = new ComponentInstallationBuilder().setComponentRevision(new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName("de.rcenvironment.core.component.sshremoteaccess.SshRemoteAccessClientComponent").build()).setNodeId(this.getLocalLogicalNodeIdForRemoteNode(hostId)).setInstallationId(this.createUniqueToolAndHostId(componentInterface.getIdentifier(), hostId, connectionId)).setIsPublished(true).build();
        registry.addComponent(ci);
        this.registeredComponentsPerConnection.get(connectionId).put(this.createUniqueToolAndHostId(componentId, hostId, connectionId), ci);
    }

    private LogicalNodeId getLocalLogicalNodeIdForRemoteNode(String remoteNodeId) {
        if (this.logicalNodeMap.containsKey(remoteNodeId)) {
            return this.logicalNodeMap.get(remoteNodeId);
        }
        try {
            LogicalNodeId remoteId = NodeIdentifierUtils.parseLogicalNodeIdString((String)remoteNodeId);
            String recPart = remoteId.getInstanceNodeIdString();
            LogicalNodeId logicalNode = this.platformService.createRecognizableLocalLogicalNodeId(recPart);
            this.logicalNodeMap.put(remoteNodeId, logicalNode);
            return logicalNode;
        }
        catch (IdentifierException identifierException) {
            return this.platformService.getLocalDefaultLogicalNodeId();
        }
    }

    protected void removeToolAccessComponent(String toolAndHostId, String connectionId) {
        ComponentInstallation ci = this.registeredComponentsPerConnection.get(connectionId).get(toolAndHostId);
        if (ci != null) {
            registry.removeComponent(ci.getInstallationId());
        }
    }

    private ConfigurationDefinition generateConfiguration(String toolName, String toolVersion, String hostName, String hostId, String connectionId, boolean isWorkflow) {
        LinkedList configuration = new LinkedList();
        HashMap<String, String> readOnlyConfiguration = new HashMap<String, String>();
        readOnlyConfiguration.put("toolName", toolName);
        readOnlyConfiguration.put("version", toolVersion);
        readOnlyConfiguration.put("connection", connectionId);
        readOnlyConfiguration.put("hostId", hostId);
        readOnlyConfiguration.put("hostName", hostName);
        readOnlyConfiguration.put("isWorkflow", Boolean.toString(isWorkflow));
        return ComponentConfigurationModelFactory.createConfigurationDefinition(configuration, new LinkedList(), new LinkedList(), readOnlyConfiguration);
    }

    private Set<EndpointDefinition> createOutputs() {
        HashSet<EndpointDefinition> outputs = new HashSet<EndpointDefinition>();
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("name", "output");
        description.put("defaultDataType", DataType.DirectoryReference.name());
        LinkedList<String> dataTypes = new LinkedList<String>();
        dataTypes.add(DataType.DirectoryReference.name());
        description.put("dataTypes", dataTypes);
        outputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.OUTPUT));
        return outputs;
    }

    private Set<EndpointDefinition> createInputs() {
        HashSet<EndpointDefinition> inputs = new HashSet<EndpointDefinition>();
        ArrayList<String> inputHandlings = new ArrayList<String>();
        inputHandlings.add(EndpointDefinition.InputDatumHandling.Constant.name());
        inputHandlings.add(EndpointDefinition.InputDatumHandling.Single.name());
        inputHandlings.add(EndpointDefinition.InputDatumHandling.Queue.name());
        ArrayList<String> inputExecutionConstraints = new ArrayList<String>();
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.NotRequired.name());
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.Required.name());
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name());
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("name", "input_text");
        description.put("defaultDataType", DataType.ShortText.name());
        LinkedList<String> dataTypes = new LinkedList<String>();
        dataTypes.add(DataType.ShortText.name());
        description.put("dataTypes", dataTypes);
        description.put("defaultInputExecutionConstraint", EndpointDefinition.InputExecutionContraint.Required.name());
        description.put("inputExecutionConstraintOptions", inputExecutionConstraints);
        description.put("defaultInputHandling", EndpointDefinition.InputDatumHandling.Queue.name());
        description.put("inputHandlingOptions", inputHandlings);
        inputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.INPUT));
        HashMap<String, Object> description2 = new HashMap<String, Object>();
        description2.put("name", "input_directory");
        description2.put("defaultDataType", DataType.DirectoryReference.name());
        LinkedList<String> dataTypes2 = new LinkedList<String>();
        dataTypes2.add(DataType.DirectoryReference.name());
        description2.put("dataTypes", dataTypes2);
        description2.put("defaultInputExecutionConstraint", EndpointDefinition.InputExecutionContraint.Required.name());
        description2.put("inputExecutionConstraintOptions", inputExecutionConstraints);
        description2.put("defaultInputHandling", EndpointDefinition.InputDatumHandling.Queue.name());
        description2.put("inputHandlingOptions", inputHandlings);
        inputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description2, (EndpointType)EndpointType.INPUT));
        return inputs;
    }

    protected void bindComponentRegistry(ComponentRegistry newRegistry) {
        registry = newRegistry;
    }

    protected void unbindComponentRegistry(ComponentRegistry newRegistry) {
        registry = (ComponentRegistry)ServiceUtils.createFailingServiceProxy(ComponentRegistry.class);
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    protected void unbindPlatformService(PlatformService newService) {
        this.platformService = (PlatformService)ServiceUtils.createFailingServiceProxy(PlatformService.class);
    }

    protected void bindSSHConnectionService(SshConnectionService newService) {
        this.sshService = newService;
    }

    public SshConnectionService getSshService() {
        return this.sshService;
    }

    @Override
    public void updateSshRemoteAccessComponents() {
        Collection activeConnectionIds = this.sshService.getAllActiveSshConnectionSetupIds();
        for (String id : activeConnectionIds) {
            this.updateSshRemoteAccessComponents(id);
        }
        HashSet<String> outdatedConnectionIds = new HashSet<String>(this.registeredComponentsPerConnection.keySet());
        outdatedConnectionIds.removeAll(activeConnectionIds);
        for (String id : outdatedConnectionIds) {
            Map<String, ComponentInstallation> registeredComponents = this.registeredComponentsPerConnection.get(id);
            if (registeredComponents == null) continue;
            for (String oldCompName : registeredComponents.keySet()) {
                this.removeToolAccessComponent(oldCompName, id);
            }
            this.registeredComponentsPerConnection.remove(id);
        }
    }

    public void activate() {
        this.taskFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedRate((Runnable)new UpdateSSHToolsTask(), TimeUnit.SECONDS.toMillis(10L));
        this.started = true;
    }

    public void deactivate() {
        this.started = false;
        if (this.taskFuture != null) {
            this.taskFuture.cancel(false);
            this.taskFuture = null;
        }
    }

    private byte[] readDefaultToolIcon(int iconSize) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream inputStream = this.getClass().getResourceAsStream("/icons/tool" + iconSize + ".png");){
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException | NullPointerException exception) {
            return null;
        }
    }

    public class UpdateSSHToolsTask
    implements Runnable {
        @Override
        @TaskDescription(value="Periodic updating of SSH-accessible remote tools")
        public void run() {
            SshRemoteAccessClientServiceImpl.this.updateSshRemoteAccessComponents();
        }
    }
}

