/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.execution.validator;

import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelException;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.common.SimpleExcelService;
import de.rcenvironment.components.excel.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class ExcelComponentValidator
extends AbstractComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.excel";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        messages.addAll(this.validateExcelPart(componentDescription));
        messages.addAll(this.validateMacroPart(componentDescription));
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private List<ComponentValidationMessage> validateExcelPart(ComponentDescription componentDescription) {
        ComponentValidationMessage validationMessage;
        SimpleExcelService excelService = new SimpleExcelService();
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String excelFile = this.getProperty(componentDescription, "xlFilename");
        boolean driver = Boolean.valueOf(this.getProperty(componentDescription, "Driver"));
        File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
        if (xlFile == null || !xlFile.exists() || !excelService.isValidExcelFile(xlFile)) {
            validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "xlFilename", Messages.errorNoExcelFileRelative, Messages.bind((String)Messages.errorNoExcelFileRelative, null), true);
            messages.add(validationMessage);
        }
        if (driver && this.getOutputs(componentDescription).isEmpty()) {
            validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "Driver", Messages.errorNoOutputAsDriverRelative, Messages.bind((String)Messages.errorNoOutputAsDriverAbsolute, (Object)"Driver"));
            messages.add(validationMessage);
        }
        return messages;
    }

    private List<ComponentValidationMessage> testChannelMetaData(File xlFile, EndpointDescription endpointDesc) {
        LinkedList<ComponentValidationMessage> messages = new LinkedList<ComponentValidationMessage>();
        String address = endpointDesc.getMetaDataValue("address");
        ComponentValidationMessage validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "address", Messages.errorNoMetaDataAddressRelative, Messages.bind((String)Messages.errorNoMetaDataAddressAbsolute, (Object)"address"));
        try {
            new ExcelAddress(xlFile, address);
        }
        catch (ExcelException excelException) {
            messages.add(validationMessage);
        }
        return messages;
    }

    private List<ComponentValidationMessage> validateMacroPart(ComponentDescription componentDescription) {
        SimpleExcelService excelService = new SimpleExcelService();
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String excelFile = this.getProperty(componentDescription, "xlFilename");
        String premacro = this.getProperty(componentDescription, "preMacro");
        String runmacro = this.getProperty(componentDescription, "runMacro");
        String postmacro = this.getProperty(componentDescription, "postMacro");
        File xlFile = ExcelUtils.getAbsoluteFile((String)excelFile);
        try {
            if (xlFile != null) {
                ComponentValidationMessage validationMessage;
                String[] macros = null;
                if (premacro != null && !premacro.isEmpty() || runmacro != null && !runmacro.isEmpty() || postmacro != null && !postmacro.isEmpty()) {
                    macros = excelService.getMacros(xlFile);
                }
                if (premacro != null && !premacro.isEmpty() && !Arrays.asList(macros).contains(premacro)) {
                    validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "preMacro", Messages.errorWrongPreMacroRelative, Messages.bind((String)Messages.errorWrongPreMacroAbsolute, (Object)"preMacro"));
                    messages.add(validationMessage);
                }
                if (runmacro != null && !runmacro.isEmpty() && !Arrays.asList(macros).contains(runmacro)) {
                    validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "runMacro", Messages.errorWrongRunMacroRelative, Messages.bind((String)Messages.errorWrongRunMacroAbsolute, (Object)"runMacro"));
                    messages.add(validationMessage);
                }
                if (postmacro != null && !postmacro.isEmpty() && !Arrays.asList(macros).contains(postmacro)) {
                    validationMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "postMacro", Messages.errorWrongPostMacroRelative, Messages.bind((String)Messages.errorWrongPostMacroAbsolute, (Object)"postMacro"));
                    messages.add(validationMessage);
                }
            }
        }
        catch (ExcelException excelException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"Excel Exception (not relevant at configuration validation time.)");
        }
        return messages;
    }
}

