/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.components.outputwriter.common.OutputWriterComponentConstants;
import de.rcenvironment.components.outputwriter.execution.OutputLocationWriter;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class OutputWriterComponent
extends DefaultComponent {
    private static final String FRONTSLASH = "/";
    private static final String BACKSLASHES = "\\";
    private static final String DOT = ".";
    private static final String DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss-S";
    private ComponentContext componentContext;
    private ComponentLog componentLog;
    private ComponentDataManagementService dataManagementService;
    private TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private String root = "";
    private String wfStartTimeStamp;
    private boolean writesToRelativePath = false;
    private Map<String, OutputLocationWriter> inputNameToOutputLocationWriter = new HashMap<String, OutputLocationWriter>();

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    private void checkRelativePathForValidProject(String relativePath) throws ComponentException {
        if (relativePath.split(FRONTSLASH).length < 2) {
            throw new ComponentException(StringUtils.format((String)"Cannot resolve root location '%s' because it contains no project.", (Object[])new Object[]{relativePath}));
        }
        String projectName = relativePath.split(FRONTSLASH)[1];
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            throw new ComponentException(StringUtils.format((String)"Failed to resolve root location '%s' because the given project '%s' could not be found.", (Object[])new Object[]{relativePath, projectName}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String adaptRootToAbsoluteRootIfProjectRelative(String rootToBeAdapted) throws ComponentException {
        String absoluteRoot = rootToBeAdapted;
        if (rootToBeAdapted.contains(FRONTSLASH) && rootToBeAdapted.contains(BACKSLASHES)) {
            throw new ComponentException(StringUtils.format((String)"Given path to file or directory could not be resolved, as it contains front and backslash as well: %s", (Object[])new Object[]{rootToBeAdapted}));
        }
        File file = new File(rootToBeAdapted);
        if (file.isAbsolute()) return absoluteRoot;
        if (rootToBeAdapted.startsWith("${dir:workspace}/")) {
            if (!ResourcesPlugin.getWorkspace().getRoot().exists()) throw new ComponentException(StringUtils.format((String)"Failed to resolve root location '%s' because the workspace could not be determined. Note that in headless mode relative paths are not supported.", (Object[])new Object[]{rootToBeAdapted}));
            this.checkRelativePathForValidProject(rootToBeAdapted);
            String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            return rootToBeAdapted.replace("${dir:workspace}", workspacePath);
        }
        this.componentLog.componentWarn(StringUtils.format((String)"Note that from version 9.0 on relative paths have to start explicitly with the prefix '%s'. Relative paths without this prefix are resolved relative to the current working directory.", (Object[])new Object[]{"${dir:workspace}"}));
        return absoluteRoot;
    }

    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        this.wfStartTimeStamp = df.format(dt);
        String rootonworkflowstart = this.componentContext.getConfigurationValue("SelectRootOnWorkflowStart");
        boolean onwfstart = Boolean.parseBoolean(rootonworkflowstart);
        if (onwfstart) {
            this.root = this.componentContext.getConfigurationValue("OWWritePath");
        } else {
            this.root = this.adaptRootToAbsoluteRootIfProjectRelative(this.componentContext.getConfigurationValue("SelectedRoot"));
            File tempRootFile = new File(this.componentContext.getConfigurationValue("SelectedRoot"));
            this.writesToRelativePath = !tempRootFile.isAbsolute();
        }
        String jsonString = this.componentContext.getConfigurationValue("outputLocations");
        if (jsonString != null && !jsonString.isEmpty()) {
            ObjectMapper jsonMapper = JsonUtils.getDefaultObjectMapper();
            jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            try {
                OutputLocationList outputList = (OutputLocationList)jsonMapper.readValue(jsonString, OutputLocationList.class);
                for (OutputLocation out : outputList.getOutputLocations()) {
                    OutputLocationWriter writer = new OutputLocationWriter(out.getInputs(), out.getHeader(), out.getFormatString(), out.getHandleExistingFile(), this.componentLog);
                    for (String input : out.getInputs()) {
                        this.inputNameToOutputLocationWriter.put(input, writer);
                    }
                    String path = String.valueOf(out.getFolderForSaving()) + File.separator + out.getFilename();
                    path = path.substring("[root]".length() + 1);
                    path = this.replacePlaceholder(path, "", null);
                    File fileToWrite = new File(String.valueOf(this.root) + File.separator + path);
                    writer.initializeFile(fileToWrite);
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to parse (internal) configuration (JSON string)", (Throwable)e);
            }
        }
    }

    public void processInputs() throws ComponentException {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String inputName = (String)this.componentContext.getInputsWithDatum().iterator().next();
        TypedDatum input = this.componentContext.readInput(inputName);
        if (input.getDataType().equals((Object)DataType.DirectoryReference) || input.getDataType().equals((Object)DataType.FileReference)) {
            this.processFileOrDirectory(inputName, input);
        } else if (this.inputNameToOutputLocationWriter.get(inputName) != null) {
            HashMap<String, TypedDatum> inputMap = new HashMap<String, TypedDatum>();
            for (String name : this.componentContext.getInputsWithDatum()) {
                inputMap.put(name, this.componentContext.readInput(name));
            }
            this.inputNameToOutputLocationWriter.get(inputName).writeOutput(inputMap, df.format(dt), this.componentContext.getExecutionCount());
        } else {
            this.componentLog.componentWarn(StringUtils.format((String)"Received value for input '%s' that is not associated with any target for simple data types", (Object[])new Object[]{inputName}));
        }
        if (this.writesToRelativePath) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                this.componentLog.componentInfo("Failed to refresh the workspace automatically. Files or directories written to the workspace might not be visible at the moment. Please try to refresh the respective folder(s) manually via its context menu.");
            }
        }
    }

    private void processFileOrDirectory(String inputName, TypedDatum input) throws ComponentException {
        String path = String.valueOf(this.componentContext.getInputMetaDataValue(inputName, "folderForSaving")) + File.separator + this.componentContext.getInputMetaDataValue(inputName, "filename");
        path = path.substring("[root]".length() + 1);
        String origFilename = null;
        if (input.getDataType().equals((Object)DataType.DirectoryReference)) {
            origFilename = ((DirectoryReferenceTD)input).getDirectoryName();
        } else if (input.getDataType().equals((Object)DataType.FileReference)) {
            origFilename = ((FileReferenceTD)input).getFileName();
        }
        path = this.replacePlaceholder(path, inputName, origFilename);
        File fileToWrite = new File(String.valueOf(this.root) + File.separator + path);
        if (!fileToWrite.exists()) {
            this.writeFile(input, fileToWrite.getAbsolutePath(), inputName);
        } else {
            File possibleFile = this.autoRename(fileToWrite);
            this.writeFile(input, possibleFile.getAbsolutePath(), inputName);
        }
        if (input.getDataType().equals((Object)DataType.DirectoryReference)) {
            this.componentLog.componentInfo(StringUtils.format((String)"Wrote directory '%s' of input '%s' to: %s", (Object[])new Object[]{((DirectoryReferenceTD)input).getDirectoryName(), inputName, fileToWrite.getAbsolutePath()}));
        } else if (input.getDataType().equals((Object)DataType.FileReference)) {
            this.componentLog.componentInfo(StringUtils.format((String)"Wrote file '%s' of input '%s' to: %s", (Object[])new Object[]{((FileReferenceTD)input).getFileName(), inputName, fileToWrite.getAbsolutePath()}));
        }
    }

    protected File autoRename(File fileToWrite) {
        String folderpath = fileToWrite.getParent();
        String fileName = fileToWrite.getName();
        String extension = "";
        if (fileName.contains(DOT)) {
            extension = fileName.substring(fileName.lastIndexOf(DOT));
            fileName = fileName.substring(0, fileName.lastIndexOf(DOT));
        }
        int i = 1;
        File possibleFile = new File(folderpath, String.valueOf(fileName) + " (" + i + ")" + extension);
        while (possibleFile.exists()) {
            possibleFile = new File(folderpath, String.valueOf(fileName) + " (" + ++i + ")" + extension);
        }
        this.componentLog.componentInfo(StringUtils.format((String)"File '%s' already exists, renamed to: %s", (Object[])new Object[]{fileToWrite.getAbsolutePath(), possibleFile.getAbsolutePath()}));
        return possibleFile;
    }

    public String replacePlaceholder(String pathinput, String currentInputName, String filename) {
        String output = pathinput;
        output = output.replaceAll(this.escapePlaceholder("[Workflow name]"), this.componentContext.getWorkflowInstanceName().replaceAll(":", "-"));
        output = output.replaceAll(this.escapePlaceholder("[Input name]"), currentInputName);
        output = output.replaceAll(this.escapePlaceholder("[Timestamp at workflow start]"), this.wfStartTimeStamp);
        output = output.replaceAll(this.escapePlaceholder("[Component name]"), this.componentContext.getInstanceName());
        output = output.replaceAll(this.escapePlaceholder("[Component type]"), this.componentContext.getComponentName());
        output = output.replaceAll(this.escapePlaceholder("[Execution count]"), Integer.toString(this.componentContext.getExecutionCount()));
        if (filename != null) {
            output = output.replaceAll(this.escapePlaceholder("[Original filename]"), filename);
        }
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        output = output.replaceAll(this.escapePlaceholder("[Timestamp]"), df.format(dt));
        return output;
    }

    private String escapePlaceholder(String placeholder) {
        return placeholder.replace("[", "\\[").replace("]", "\\]");
    }

    private void writeFile(TypedDatum input, String path, String inputName) throws ComponentException {
        File file = new File(path);
        String filename = file.getName();
        if (!(file = new File(file.getAbsolutePath().replace(String.valueOf(File.separator) + filename, ""))).isDirectory()) {
            file.mkdirs();
        }
        switch (input.getDataType()) {
            case FileReference: {
                List<String> forbiddenFilenames = Arrays.asList(OutputWriterComponentConstants.PROBLEMATICFILENAMES_WIN);
                if (forbiddenFilenames.contains(filename) || filename.contains(FRONTSLASH) || filename.contains(BACKSLASHES)) {
                    throw new ComponentException(StringUtils.format((String)"Failed to write file of input '%s' because '%s' is a forbidden filename", (Object[])new Object[]{inputName, filename}));
                }
                File incFileOrDir = new File(path);
                try {
                    this.dataManagementService.copyReferenceToLocalFile(((FileReferenceTD)input).getFileReference(), incFileOrDir, (ResolvableNodeId)this.componentContext.getDefaultStorageNodeId());
                    break;
                }
                catch (IOException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to write file of input '%s' to %s", (Object[])new Object[]{inputName, incFileOrDir.getAbsolutePath()}), (Throwable)e);
                }
            }
            case DirectoryReference: {
                File tempDir;
                File incFileOrDir = new File(path);
                try {
                    tempDir = this.tempFileService.createManagedTempDir();
                }
                catch (IOException e) {
                    throw new ComponentException("Failed to create temporary directory that is required by Output Writer", (Throwable)e);
                }
                try {
                    try {
                        this.dataManagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)input, tempDir);
                        FileUtils.moveDirectory((File)new File(tempDir, ((DirectoryReferenceTD)input).getDirectoryName()), (File)incFileOrDir);
                    }
                    catch (IOException e) {
                        throw new ComponentException(StringUtils.format((String)"Failed to write directory of input '%s' to %s", (Object[])new Object[]{inputName, incFileOrDir.getAbsolutePath()}), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.tempFileService.disposeManagedTempDirOrFile(tempDir);
                    }
                    catch (IOException e) {
                        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Failed to delete temporary directory", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    this.tempFileService.disposeManagedTempDirOrFile(tempDir);
                }
                catch (IOException e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Failed to delete temporary directory", (Throwable)e);
                }
                break;
            }
        }
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        for (OutputLocationWriter out : this.inputNameToOutputLocationWriter.values()) {
            out.close();
        }
    }
}

