/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.login.internal;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.gui.login.internal.Activator;
import de.rcenvironment.core.gui.login.internal.LoginDialog;
import de.rcenvironment.core.gui.login.internal.Messages;
import de.rcenvironment.core.login.LoginConfiguration;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialogController {
    private static final String PROPERTIES_PREFIX = "de.rcenvironment.rce.gui.login";
    private static final Log LOGGER = LogFactory.getLog(LoginDialogController.class);
    private LoginDialog loginDialog;
    private AuthenticationService authenticationService;
    private LoginConfiguration loginConfiguration;
    private String certificatePath;
    private String keyPath;
    private String usernameLDAP = "";
    private String tabTitle = Messages.certificateTabName;

    protected LoginDialogController(LoginDialog loginDialog, AuthenticationService authenticationService, LoginConfiguration loginConfiguration) {
        this.loginDialog = loginDialog;
        this.authenticationService = authenticationService;
        this.loginConfiguration = loginConfiguration;
    }

    protected void setUpDialogForCertificate(boolean relogin) {
        this.loadSettings();
        this.addListenerToKeyPathButton();
        if (!relogin || this.loginDialog.getUser().getType() != User.Type.certificate) {
            this.addListenerToCertificatePathButton();
            this.tryToLoadDefaultCertificate();
        } else {
            this.loadCertificateFromFile();
        }
        this.tryToLoadDefaultKey();
    }

    protected void setUpDialogForLDAP(boolean relogin) {
        this.loadSettings();
        this.loadUsernameLDAP();
    }

    protected void saveSettings() {
        IDialogSettings dialogSettings = Activator.getInstance().getDialogSettings();
        dialogSettings.put("de.rcenvironment.rce.gui.logincertificateFile", this.certificatePath);
        dialogSettings.put("de.rcenvironment.rce.gui.loginkeyFile", this.keyPath);
        dialogSettings.put("de.rcenvironment.rce.gui.loginusernameLDAP", this.loginDialog.getUsernameLDAP());
        dialogSettings.put("de.rcenvironment.rce.gui.logintabTitle", this.tabTitle);
        dialogSettings.put("de.rcenvironment.rce.gui.loginanonymousLogin", this.loginDialog.getAnonymousLogin());
    }

    protected void loadSettings() {
        IDialogSettings dialogSettings = Activator.getInstance().getDialogSettings();
        String settingsCertificatePath = dialogSettings.get("de.rcenvironment.rce.gui.logincertificateFile");
        this.certificatePath = settingsCertificatePath != null ? settingsCertificatePath : this.loginConfiguration.getCertificateFile();
        String settingsKeyPath = dialogSettings.get("de.rcenvironment.rce.gui.loginkeyFile");
        this.keyPath = settingsKeyPath != null ? settingsKeyPath : this.loginConfiguration.getKeyFile();
        String settingsUsernameLdap = dialogSettings.get("de.rcenvironment.rce.gui.loginusernameLDAP");
        this.usernameLDAP = settingsUsernameLdap != null ? settingsUsernameLdap : this.loginConfiguration.getLdapUsername();
        String settingsTabTitle = dialogSettings.get("de.rcenvironment.rce.gui.logintabTitle");
        if (settingsTabTitle != null) {
            this.tabTitle = settingsTabTitle;
        }
    }

    private void addListenerToCertificatePathButton() {
        Button certificateDirectoryButton = this.loginDialog.getCertificateFileButton();
        certificateDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(LoginDialogController.this.loginDialog.getShell(), 4096);
                fileDialog.setText(Messages.chooseCert);
                fileDialog.setFilterPath(new File(LoginDialogController.this.certificatePath).getParent());
                Text myCertificateFileText = LoginDialogController.this.loginDialog.getCertificateFileText();
                String newCertificatePath = fileDialog.open();
                if (newCertificatePath != null) {
                    try {
                        LoginDialogController.this.loginDialog.setCertificate(LoginDialogController.this.authenticationService.loadCertificate(newCertificatePath));
                        myCertificateFileText.setBackground(LoginDialogController.this.loginDialog.getShell().getBackground());
                        myCertificateFileText.setText(new File(newCertificatePath).getName());
                        LoginDialogController.this.certificatePath = newCertificatePath;
                    }
                    catch (AuthenticationException authenticationException) {
                        LoginDialogController.this.loginDialog.setCertificate(null);
                        myCertificateFileText.setBackground(LoginDialogController.this.loginDialog.getShell().getDisplay().getSystemColor(3));
                        myCertificateFileText.setText("");
                        MessageDialog.openError((Shell)LoginDialogController.this.loginDialog.getShell(), (String)Messages.loginDialog, (String)Messages.certRevoked);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void loadCertificateFromFile() {
        try {
            this.loginDialog.setCertificate(this.authenticationService.loadCertificate(this.certificatePath));
        }
        catch (AuthenticationException authenticationException) {
            this.loginDialog.setCertificate(null);
        }
    }

    private void addListenerToKeyPathButton() {
        Button keyFileButton = this.loginDialog.getkeyFileButton();
        keyFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(LoginDialogController.this.loginDialog.getShell(), 4096);
                fileDialog.setFilterPath(LoginDialogController.this.keyPath);
                fileDialog.setText(Messages.chooseKey);
                Text myKeyFileText = LoginDialogController.this.loginDialog.getKeyFileText();
                String newKeyPath = fileDialog.open();
                if (newKeyPath != null) {
                    try {
                        LoginDialogController.this.loginDialog.setKey(LoginDialogController.this.authenticationService.loadKey(newKeyPath));
                        myKeyFileText.setBackground(LoginDialogController.this.loginDialog.getShell().getBackground());
                        myKeyFileText.setText(new File(newKeyPath).getName());
                        LoginDialogController.this.keyPath = newKeyPath;
                    }
                    catch (AuthenticationException authenticationException) {
                        LoginDialogController.this.loginDialog.setKey(null);
                        myKeyFileText.setBackground(LoginDialogController.this.loginDialog.getShell().getDisplay().getSystemColor(3));
                        myKeyFileText.setText("");
                        MessageDialog.openError((Shell)LoginDialogController.this.loginDialog.getShell(), (String)Messages.loginDialog, (String)Messages.keyRevoked);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void tryToLoadDefaultCertificate() {
        Text myCertificateFileText = this.loginDialog.getCertificateFileText();
        myCertificateFileText.setText("");
        myCertificateFileText.setBackground(this.loginDialog.getShell().getDisplay().getSystemColor(3));
        this.loginDialog.setCertificate(null);
        if (new File(this.certificatePath).exists()) {
            try {
                this.loginDialog.setCertificate(this.authenticationService.loadCertificate(this.certificatePath));
                myCertificateFileText.setText(new File(this.certificatePath).getName());
                myCertificateFileText.setBackground(this.loginDialog.getShell().getBackground());
            }
            catch (AuthenticationException e) {
                LOGGER.error((Object)("Given certificate could not be loaded: " + this.certificatePath), (Throwable)e);
            }
        }
    }

    private void tryToLoadDefaultKey() {
        Text myKeyFileText = this.loginDialog.getKeyFileText();
        myKeyFileText.setText("");
        myKeyFileText.setBackground(this.loginDialog.getShell().getDisplay().getSystemColor(3));
        this.loginDialog.setKey(null);
        if (new File(this.keyPath).exists()) {
            try {
                this.loginDialog.setKey(this.authenticationService.loadKey(this.keyPath));
                myKeyFileText.setText(new File(this.keyPath).getName());
                myKeyFileText.setBackground(this.loginDialog.getShell().getBackground());
            }
            catch (AuthenticationException e) {
                LOGGER.error((Object)("Given private key could not be loaded: " + this.keyPath), (Throwable)e);
            }
        }
    }

    private void loadUsernameLDAP() {
        this.loginDialog.setUsernameLDAP(this.usernameLDAP);
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setTabTitle(String title) {
        this.tabTitle = title;
    }
}

