/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.internal.NOOPSystemIntegrationAdapter;
import de.rcenvironment.core.monitoring.system.internal.SIGARSystemIntegrationAdapter;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SystemIntegrationEntryPoint {
    private static final SystemIntegrationEntryPoint INSTANCE = new SystemIntegrationEntryPoint();
    private final SystemIntegrationAdapter adapter;

    private SystemIntegrationEntryPoint() {
        Log log = LogFactory.getLog(this.getClass());
        if (SIGARSystemIntegrationAdapter.shouldAttemptToInitialize()) {
            SIGARSystemIntegrationAdapter preliminaryAdapter;
            try {
                preliminaryAdapter = new SIGARSystemIntegrationAdapter();
                log.debug((Object)"Initialized the SIGAR library for system integration and monitoring");
            }
            catch (OperatingSystemException operatingSystemException) {
                log.error((Object)"Failed to initialize the SIGAR library; deactivating system integration and monitoring");
                this.adapter = new NOOPSystemIntegrationAdapter();
                return;
            }
            this.adapter = preliminaryAdapter;
        } else {
            log.info((Object)"Deactivating system integration and monitoring as there is no appropriate system library for the current platform");
            this.adapter = new NOOPSystemIntegrationAdapter();
        }
    }

    public static SystemIntegrationAdapter getAdapter() {
        return SystemIntegrationEntryPoint.INSTANCE.adapter;
    }
}

