/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ToolIntegrationContextRegistryImpl
implements ToolIntegrationContextRegistry {
    private static ToolIntegrationService integrationService;
    private static List<ToolIntegrationContext> integrationInformationToProcess;
    private final Map<String, ToolIntegrationContext> informationMap = new HashMap<String, ToolIntegrationContext>();

    static {
        integrationInformationToProcess = new LinkedList<ToolIntegrationContext>();
    }

    @Override
    public synchronized void addToolIntegrationContext(ToolIntegrationContext context) {
        if (!this.informationMap.containsKey(context.getContextId())) {
            this.informationMap.put(context.getContextId(), context);
            if (integrationService == null) {
                integrationInformationToProcess.add(context);
            } else {
                this.createIntegrationThread(context);
            }
        }
    }

    private synchronized void createIntegrationThread(final ToolIntegrationContext context) {
        if (!CommandLineArguments.isDoNotStartComponentsRequested()) {
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Read integrated tool folder at startup")
                public void run() {
                    integrationService.readAndIntegratePersistentTools(context);
                }
            });
        }
    }

    @Override
    public void removeToolIntegrationContext(String contextID) {
        if (this.informationMap.containsKey(contextID)) {
            this.informationMap.remove(contextID);
        }
    }

    @Override
    public void removeToolIntegrationContext(ToolIntegrationContext context) {
        this.informationMap.remove(context);
    }

    @Override
    public Collection<ToolIntegrationContext> getAllIntegrationContexts() {
        return this.informationMap.values();
    }

    @Override
    public ToolIntegrationContext getToolIntegrationContext(String informationID) {
        return this.informationMap.get(informationID);
    }

    @Override
    public boolean hasId(String informationID) {
        boolean result = false;
        for (ToolIntegrationContext tic : this.informationMap.values()) {
            if (!informationID.contains(tic.getPrefixForComponentId())) continue;
            result = true;
        }
        return result;
    }

    protected void bindToolIntegrationService(ToolIntegrationService intService) {
        integrationService = intService;
        for (ToolIntegrationContext i : integrationInformationToProcess) {
            this.createIntegrationThread(i);
        }
    }
}

