/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.workflow.editor.handlers.AbstractWorkflowNodeEditHandler;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class WorkflowNodeCopyHandler
extends AbstractWorkflowNodeEditHandler {
    private WorkflowDescriptionPersistenceHandler descriptionHandler = new WorkflowDescriptionPersistenceHandler();

    @Override
    void edit() {
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        List selection = this.viewer.getSelectedEditParts();
        ArrayList<WorkflowNodePart> nodes = new ArrayList<WorkflowNodePart>();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ArrayList<WorkflowLabelPart> labels = new ArrayList<WorkflowLabelPart>();
        for (Object selectedObject : selection) {
            if (selectedObject instanceof WorkflowNodePart) {
                WorkflowNodePart workflowNodePart = (WorkflowNodePart)selectedObject;
                nodes.add(workflowNodePart);
                WorkflowNode workflowNode = (WorkflowNode)workflowNodePart.getModel();
                for (Object comparisonObject : selection) {
                    if (!(comparisonObject instanceof WorkflowNodePart)) continue;
                    WorkflowNodePart comparisonWorkflowNodePart = (WorkflowNodePart)comparisonObject;
                    WorkflowNode comparisonWorkflowNode = (WorkflowNode)comparisonWorkflowNodePart.getModel();
                    for (Connection connection : model.getConnections()) {
                        if (!connection.getSourceNode().getIdentifier().equals(workflowNode.getIdentifier()) || !connection.getTargetNode().getIdentifier().equals(comparisonWorkflowNode.getIdentifier())) continue;
                        connections.add(connection);
                    }
                }
                continue;
            }
            if (!(selectedObject instanceof WorkflowLabelPart)) continue;
            WorkflowLabelPart workflowLabelPart = (WorkflowLabelPart)selectedObject;
            labels.add(workflowLabelPart);
        }
        Collections.sort(labels, new WorkflowLabelpartComparator());
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonFactory f = new JsonFactory();
            JsonGenerator generator = null;
            generator = f.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            generator.writeStartObject();
            if (!nodes.isEmpty()) {
                this.writeComponent(generator, nodes);
            }
            if (!connections.isEmpty()) {
                this.writeConnection(generator, connections);
            }
            if (!labels.isEmpty()) {
                this.writeLabel(generator, labels);
            }
            if (!connections.isEmpty()) {
                this.writeBendpoints(generator, connections);
            }
            generator.writeEndObject();
            generator.close();
            ClipboardHelper.setContent((String)outputStream.toString());
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when writing components to JSON: " + e.getMessage()));
        }
    }

    private void writeComponent(JsonGenerator generator, List<WorkflowNodePart> nodes) throws JsonGenerationException, IOException {
        generator.writeArrayFieldStart("nodes");
        for (WorkflowNodePart workflowNodePart : nodes) {
            WorkflowNode workflowNode = (WorkflowNode)workflowNodePart.getModel();
            this.descriptionHandler.writeWorkflowNode(generator, workflowNode);
        }
        generator.writeEndArray();
    }

    private void writeConnection(JsonGenerator generator, List<Connection> connections) throws JsonGenerationException, IOException {
        generator.writeArrayFieldStart("connections");
        for (Connection connection : connections) {
            this.descriptionHandler.writeConnection(generator, connection);
        }
        generator.writeEndArray();
    }

    private void writeBendpoints(JsonGenerator generator, List<Connection> connections) throws JsonGenerationException, IOException {
        generator.writeArrayFieldStart("bendpoints");
        Map uniqueConnectionBendpointMapping = this.descriptionHandler.calculateUniqueBendpointList(connections);
        this.descriptionHandler.writeBendpoints(generator, uniqueConnectionBendpointMapping);
        generator.writeEndArray();
    }

    private void writeLabel(JsonGenerator generator, List<WorkflowLabelPart> labels) throws JsonGenerationException, IOException {
        generator.writeArrayFieldStart("labels");
        for (WorkflowLabelPart workflowLabelPart : labels) {
            WorkflowLabel workflowLabel = (WorkflowLabel)workflowLabelPart.getModel();
            this.descriptionHandler.writeLabel(generator, workflowLabel);
        }
        generator.writeEndArray();
    }

    private class WorkflowLabelpartComparator
    implements Comparator<WorkflowLabelPart> {
        private WorkflowLabelpartComparator() {
        }

        @Override
        public int compare(WorkflowLabelPart part1, WorkflowLabelPart part2) {
            int y2;
            int y1 = this.getYPosition(part1);
            if (y1 == (y2 = this.getYPosition(part2))) {
                return 0;
            }
            if (y1 < y2) {
                return -1;
            }
            return 1;
        }

        private int getYPosition(WorkflowLabelPart part) {
            int y = 0;
            Object model = part.getModel();
            if (model instanceof WorkflowLabel) {
                WorkflowLabel label = (WorkflowLabel)model;
                y = label.getY();
            }
            return y;
        }
    }
}

