/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.connections;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.connections.ConnectionDialog;
import de.rcenvironment.core.gui.workflow.editor.connections.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class ConnectionDialogController {
    private ConnectionDialog dialog;
    private WorkflowDescription description;
    private WorkflowNode sourceWorkflowNode;
    private WorkflowNode targetWorkflowNode;
    private boolean wasDoubleClicked;

    public ConnectionDialogController(WorkflowDescription description, WorkflowNode source, WorkflowNode target, boolean wasDoubleClicked) {
        this.description = description;
        this.sourceWorkflowNode = source;
        this.targetWorkflowNode = target;
        this.wasDoubleClicked = wasDoubleClicked;
        this.dialog = new ConnectionDialog(Display.getCurrent().getActiveShell());
        this.dialog.create();
        this.dialog.getShell().setText(Messages.connectionEditor);
        this.initialize();
        if (!wasDoubleClicked) {
            boolean autoConnected = this.checkForAutoConnection();
            this.dialog.getAutoConnectInfoLabel().setVisible(autoConnected);
            if (autoConnected) {
                this.dialog.getConnectionDialogComposite().getTargetTreeViewer().refresh();
                this.dialog.getConnectionDialogComposite().getSourceTreeViewer().refresh();
            }
        } else {
            this.dialog.getAutoConnectInfoLabel().setVisible(false);
        }
    }

    public int open() {
        return this.dialog.open();
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.description;
    }

    private void initialize() {
        this.dialog.getConnectionDialogComposite().initialize(this.getWorkflowDescription(), this.sourceWorkflowNode, this.targetWorkflowNode);
        this.dialog.getConnectionDialogComposite().setWasDoubleClicked(this.wasDoubleClicked);
        this.dialog.getConnectionDialogComposite().applySourceFilter();
        this.dialog.getConnectionDialogComposite().applyTargetFilter();
        this.dialog.getConnectionDialogComposite().getSourceTreeViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        this.dialog.getConnectionDialogComposite().getTargetTreeViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private boolean checkForAutoConnection() {
        boolean autoConnected = false;
        if (this.sourceWorkflowNode != null && this.targetWorkflowNode != null) {
            if (this.sourceWorkflowNode.getIdentifier().equals(this.targetWorkflowNode.getIdentifier())) {
                return false;
            }
            if (this.sourceWorkflowNode.getOutputDescriptionsManager().getEndpointDescriptions().size() == 1 && this.targetWorkflowNode.getInputDescriptionsManager().getEndpointDescriptions().size() == 1) {
                EndpointDescription sourceOutput = (EndpointDescription)this.sourceWorkflowNode.getOutputDescriptionsManager().getEndpointDescriptions().toArray()[0];
                EndpointDescription targetInput = (EndpointDescription)this.targetWorkflowNode.getInputDescriptionsManager().getEndpointDescriptions().toArray()[0];
                if (sourceOutput.getDataType().equals((Object)targetInput.getDataType())) {
                    for (Connection connection : this.description.getConnections()) {
                        if (!connection.getInput().getIdentifier().equals(targetInput.getIdentifier())) continue;
                        return false;
                    }
                    List<Location> bendpoints = ConnectionUtils.findAlreadyExistentBendpointsFromSourceToTarget(this.sourceWorkflowNode, this.targetWorkflowNode, this.description);
                    Connection newConnection = new Connection(this.sourceWorkflowNode, sourceOutput, this.targetWorkflowNode, targetInput, bendpoints);
                    if (!this.description.getConnections().contains(newConnection)) {
                        this.description.addConnection(newConnection);
                        return true;
                    }
                }
            } else if (this.sourceWorkflowNode.getOutputDescriptionsManager().getEndpointDescriptions().size() > 0 && this.targetWorkflowNode.getInputDescriptionsManager().getEndpointDescriptions().size() > 0) {
                for (EndpointDescription sourceOutput : this.sourceWorkflowNode.getOutputDescriptionsManager().getEndpointDescriptions()) {
                    for (EndpointDescription targetInput : this.targetWorkflowNode.getInputDescriptionsManager().getEndpointDescriptions()) {
                        ArrayList<Connection> connectionsToBeAdded = new ArrayList<Connection>();
                        if (sourceOutput.getDataType().equals((Object)targetInput.getDataType()) && sourceOutput.getName().equals(targetInput.getName())) {
                            boolean alreadyExists = false;
                            for (Connection connection : this.description.getConnections()) {
                                if (!connection.getInput().getIdentifier().equals(targetInput.getIdentifier())) continue;
                                alreadyExists = true;
                                break;
                            }
                            List<Location> bendpoints = ConnectionUtils.findAlreadyExistentBendpointsFromSourceToTarget(this.sourceWorkflowNode, this.targetWorkflowNode, this.description);
                            Connection newConnection = new Connection(this.sourceWorkflowNode, sourceOutput, this.targetWorkflowNode, targetInput, bendpoints);
                            if (!this.description.getConnections().contains(newConnection) && !alreadyExists) {
                                connectionsToBeAdded.add(newConnection);
                                autoConnected = true;
                            }
                        }
                        this.description.addConnections(connectionsToBeAdded);
                    }
                }
            }
        }
        return autoConnected;
    }
}

