/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListener;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListenerAdapter;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistributedComponentKnowledgeServiceImpl
implements DistributedComponentKnowledgeService,
AdditionalServicesProvider {
    private static final String SINGLE_INSTALLATION_PROPERTY_PREFIX = "componentInstallation/";
    private NodePropertiesService nodePropertiesService;
    private final AsyncOrderedCallbackManager<DistributedComponentKnowledgeListener> componentKnowledgeCallbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private volatile DistributedComponentKnowledge currentSnapshot;
    private final InternalModel internalModel;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    public DistributedComponentKnowledgeServiceImpl() {
        this.internalModel = new InternalModel();
        this.currentSnapshot = new DistributedComponentKnowledgeSnapshot(this.internalModel);
        this.addDistributedComponentKnowledgeListener(new DistributedComponentKnowledgeListener(){

            @Override
            public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
                if (DistributedComponentKnowledgeServiceImpl.this.verboseLogging) {
                    DistributedComponentKnowledgeServiceImpl.this.log.debug((Object)("Component knowledge updated: " + newState));
                }
            }
        });
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> listenerDeclarations = new ArrayList<AdditionalServiceDeclaration>();
        listenerDeclarations.add(new AdditionalServiceDeclaration(NodePropertiesChangeListener.class, (Object)new NodePropertiesChangeListenerAdapter(){

            public void onReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties) {
                DistributedComponentKnowledgeServiceImpl.this.updateOnReachableNodePropertiesChanged(addedProperties, updatedProperties, removedProperties);
            }
        }));
        return listenerDeclarations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocalComponentInstallations(Collection<ComponentInstallation> allInstallations, Collection<ComponentInstallation> installationsToPublish) {
        HashMap<String, String> delta = new HashMap<String, String>();
        TreeSet<String> uniqueIds = new TreeSet<String>();
        InternalModel internalModel = this.internalModel;
        synchronized (internalModel) {
            this.internalModel.immutableLocalState = Collections.unmodifiableList(new ArrayList<ComponentInstallation>(allInstallations));
            DistributedComponentKnowledgeSnapshot newSnapshot = new DistributedComponentKnowledgeSnapshot(this.internalModel);
            this.setNewSnapshot(newSnapshot);
            for (ComponentInstallation installation : installationsToPublish) {
                String uniqueId = installation.getInstallationId();
                uniqueIds.add(SINGLE_INSTALLATION_PROPERTY_PREFIX + uniqueId);
                String serialized = this.serializeComponentInstallationData(installation);
                String propertyId = SINGLE_INSTALLATION_PROPERTY_PREFIX + uniqueId;
                if (serialized.equals(this.internalModel.dynamicPublishedState.get(propertyId))) continue;
                this.log.debug((Object)("Publishing component descriptor " + uniqueId));
                delta.put(propertyId, serialized);
            }
            for (String oldId : this.internalModel.dynamicPublishedState.keySet()) {
                if (uniqueIds.contains(oldId) || this.internalModel.dynamicPublishedState.get(oldId) == null) continue;
                this.log.debug((Object)("Unpublishing component id " + oldId));
                delta.put(oldId, null);
            }
            this.internalModel.dynamicPublishedState.putAll(delta);
            if (!delta.isEmpty()) {
                this.nodePropertiesService.addOrUpdateLocalNodeProperties(delta);
            }
        }
    }

    @Override
    public DistributedComponentKnowledge getCurrentComponentKnowledge() {
        return this.currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties) {
        DistributedComponentKnowledgeSnapshot newSnapshot = null;
        boolean modified = false;
        InternalModel internalModel = this.internalModel;
        synchronized (internalModel) {
            boolean success;
            for (NodeProperty nodeProperty : addedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Parsing new component installation property: " + nodeProperty));
                }
                if (!(success = this.processAddedOrUpdatedProperty(nodeProperty, false))) continue;
                modified = true;
            }
            for (NodeProperty nodeProperty : updatedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Parsing updated component installation property: " + nodeProperty));
                }
                if (!(success = this.processAddedOrUpdatedProperty(nodeProperty, true))) continue;
                modified = true;
            }
            for (NodeProperty nodeProperty : removedProperties) {
                if (!this.isComponentInstallationProperty(nodeProperty)) continue;
                if (this.verboseLogging) {
                    this.log.debug((Object)("Removing disconnected component installation property: " + nodeProperty));
                }
                if (!(success = this.processRemovedProperty(nodeProperty))) continue;
                modified = true;
            }
            if (modified) {
                newSnapshot = new DistributedComponentKnowledgeSnapshot(this.internalModel);
                this.setNewSnapshot(newSnapshot);
            }
        }
    }

    protected void addDistributedComponentKnowledgeListener(DistributedComponentKnowledgeListener listener) {
        final DistributedComponentKnowledge knowledgeOnRegistrationTime = this.currentSnapshot;
        this.componentKnowledgeCallbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<DistributedComponentKnowledgeListener>(){

            public void performCallback(DistributedComponentKnowledgeListener listener) {
                listener.onDistributedComponentKnowledgeChanged(knowledgeOnRegistrationTime);
            }
        });
    }

    protected void removeDistributedComponentKnowledgeListener(DistributedComponentKnowledgeListener listener) {
        this.componentKnowledgeCallbackManager.removeListener((Object)listener);
    }

    protected void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    private boolean processAddedOrUpdatedProperty(NodeProperty property, boolean isUpdate) {
        String componentDescriptionId;
        InstanceNodeSessionId sourceNodeId = property.getInstanceNodeSessionId();
        String propertyKey = property.getKey().substring(SINGLE_INSTALLATION_PROPERTY_PREFIX.length());
        String value = property.getValue();
        ComponentInstallation componentInstallation = this.deserializeComponentInstallationData(value);
        if (componentInstallation == null) {
            this.log.warn((Object)("Ignoring invalid component installation entry published by " + sourceNodeId));
            return false;
        }
        LogicalNodeId declaredNodeIdObject = componentInstallation.fetchNodeIdAsObject();
        if (!declaredNodeIdObject.isSameInstanceNodeAs((ResolvableNodeId)sourceNodeId)) {
            this.log.error((Object)("Ignoring invalid component installation entry: published by node " + sourceNodeId + ", but allegedly installed on node " + componentInstallation.getNodeId()));
            return false;
        }
        if (componentInstallation.getComponentRevision() == null) {
            this.log.error((Object)"Ignoring invalid component installation entry: 'null' component revision");
            return false;
        }
        if (componentInstallation.getComponentRevision().getComponentInterface() == null) {
            this.log.error((Object)"Ignoring invalid component installation entry: 'null' component interface");
            return false;
        }
        if (componentInstallation.getComponentRevision().getComponentInterface().getIdentifier() == null) {
            this.log.error((Object)"Ignoring invalid component installation entry: 'null' component interface id");
            return false;
        }
        try {
            componentDescriptionId = componentInstallation.getComponentRevision().getComponentInterface().getIdentifier();
        }
        catch (NullPointerException e) {
            this.log.warn((Object)"Parsed component installation data caused a NPE; ignoring", (Throwable)e);
            return false;
        }
        this.log.debug((Object)("Successfully parsed component installation published by " + sourceNodeId + ": " + componentDescriptionId));
        HashMap<String, ComponentInstallation> nodeState = (HashMap<String, ComponentInstallation>)this.internalModel.dynamicReceivedState.get(sourceNodeId);
        if (nodeState == null) {
            nodeState = new HashMap<String, ComponentInstallation>();
            this.internalModel.dynamicReceivedState.put(sourceNodeId, nodeState);
        }
        ComponentInstallation previousEntry = nodeState.put(propertyKey, componentInstallation);
        if (isUpdate) {
            if (previousEntry == null) {
                this.log.warn((Object)("Unexpected state: received a property update, but there was no previously registered component for key '" + propertyKey + "'; maybe the previous property could not be parsed?"));
            }
        } else if (previousEntry != null) {
            this.log.warn((Object)("Unexpected state: received a new property, but there was a previously registered component already; key=" + propertyKey));
        }
        return true;
    }

    private boolean processRemovedProperty(NodeProperty property) {
        InstanceNodeSessionId nodeId = property.getInstanceNodeSessionId();
        String propertyKey = property.getKey().substring(SINGLE_INSTALLATION_PROPERTY_PREFIX.length());
        Map nodeState = (Map)this.internalModel.dynamicReceivedState.get(nodeId);
        if (nodeState == null) {
            return false;
        }
        ComponentInstallation previousEntry = (ComponentInstallation)nodeState.remove(propertyKey);
        if (previousEntry == null) {
            return false;
        }
        this.log.debug((Object)("Successfully removed a component installation previously published by " + nodeId + " (key: " + propertyKey + ")"));
        return true;
    }

    private boolean isComponentInstallationProperty(NodeProperty property) {
        return property.getKey().startsWith(SINGLE_INSTALLATION_PROPERTY_PREFIX);
    }

    private void setNewSnapshot(final DistributedComponentKnowledge newSnapshot) {
        this.currentSnapshot = newSnapshot;
        this.componentKnowledgeCallbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<DistributedComponentKnowledgeListener>(){

            public void performCallback(DistributedComponentKnowledgeListener listener) {
                listener.onDistributedComponentKnowledgeChanged(newSnapshot);
            }
        });
    }

    private String serializeComponentInstallationData(ComponentInstallation ci) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            return mapper.writeValueAsString((Object)ci);
        }
        catch (IOException e) {
            this.log.error((Object)"Error serializing component descriptor", (Throwable)e);
            return null;
        }
    }

    private ComponentInstallation deserializeComponentInstallationData(String jsonData) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            return (ComponentInstallation)mapper.readValue(jsonData, ComponentInstallationImpl.class);
        }
        catch (IOException e) {
            this.log.error((Object)("Error deserializing component descriptor from JSON data: " + jsonData), (Throwable)e);
            return null;
        }
    }

    private static final class DistributedComponentKnowledgeSnapshot
    implements DistributedComponentKnowledge {
        private final List<ComponentInstallation> localStateAsList;
        private final List<ComponentInstallation> distributedStateAsList;
        private final Map<String, Collection<ComponentInstallation>> distributedStateAsMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DistributedComponentKnowledgeSnapshot(InternalModel internalModel) {
            InternalModel internalModel2 = internalModel;
            synchronized (internalModel2) {
                this.localStateAsList = internalModel.immutableLocalState;
                ArrayList tempGlobalList = new ArrayList();
                HashMap tempMap = new HashMap();
                Set entrySet = internalModel.dynamicReceivedState.entrySet();
                for (Map.Entry entry : entrySet) {
                    InstanceNodeSessionId nodeId = (InstanceNodeSessionId)entry.getKey();
                    Collection componentsOfNode = ((Map)entry.getValue()).values();
                    tempGlobalList.addAll(componentsOfNode);
                    ArrayList componentsToAdd = new ArrayList(componentsOfNode);
                    if (tempMap.get(nodeId.getInstanceNodeIdString()) != null) {
                        componentsToAdd.addAll((Collection)tempMap.get(nodeId.getInstanceNodeIdString()));
                    }
                    tempMap.put(nodeId.getInstanceNodeIdString(), Collections.unmodifiableCollection(componentsToAdd));
                }
                this.distributedStateAsList = Collections.unmodifiableList(tempGlobalList);
                this.distributedStateAsMap = Collections.unmodifiableMap(tempMap);
            }
        }

        @Override
        public Collection<ComponentInstallation> getPublishedInstallationsOnNode(ResolvableNodeId nodeId) {
            return this.distributedStateAsMap.get(nodeId.getInstanceNodeIdString());
        }

        @Override
        public Collection<ComponentInstallation> getAllPublishedInstallations() {
            return this.distributedStateAsList;
        }

        @Override
        public Collection<ComponentInstallation> getLocalInstallations() {
            return this.localStateAsList;
        }

        @Override
        public Collection<ComponentInstallation> getAllInstallations() {
            HashSet<ComponentInstallation> allInstallations = new HashSet<ComponentInstallation>(this.distributedStateAsList.size() + this.localStateAsList.size());
            allInstallations.addAll(this.distributedStateAsList);
            allInstallations.addAll(this.localStateAsList);
            return allInstallations;
        }

        public String toString() {
            return "Local: " + this.localStateAsList + ", Distributed: " + this.distributedStateAsMap;
        }
    }

    private static final class InternalModel {
        private List<ComponentInstallation> immutableLocalState = Collections.unmodifiableList(new ArrayList());
        private Map<InstanceNodeSessionId, Map<String, ComponentInstallation>> dynamicReceivedState = new HashMap<InstanceNodeSessionId, Map<String, ComponentInstallation>>();
        private Map<String, String> dynamicPublishedState = new HashMap<String, String>();

        private InternalModel() {
        }
    }
}

