/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.rbac;

import de.rcenvironment.core.authorization.rbac.Permission;
import de.rcenvironment.core.authorization.rbac.RBACObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Role
extends RBACObject {
    private static final long serialVersionUID = -4911570862906136144L;
    private final Set<Permission> myPermissions;

    public Role(String id, Set<Permission> permissions) {
        this(id, "", permissions);
    }

    public Role(String id, String description, Set<Permission> permissions) {
        super(id, description);
        this.myPermissions = permissions == null ? new HashSet<Permission>() : permissions;
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.myPermissions);
    }

    public boolean hasPermission(Permission permission) {
        return this.myPermissions.contains(permission);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Role && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        String representation = String.valueOf(super.toString()) + " - " + this.myPermissions.toString();
        return representation;
    }
}

