/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.connection.impl.ConnectionSetupServiceImpl;
import de.rcenvironment.core.communication.connection.internal.MessageChannelServiceImpl;
import de.rcenvironment.core.communication.internal.CommunicationServiceImpl;
import de.rcenvironment.core.communication.internal.LiveNetworkIdResolutionServiceImpl;
import de.rcenvironment.core.communication.internal.PlatformServiceImpl;
import de.rcenvironment.core.communication.management.CommunicationManagementService;
import de.rcenvironment.core.communication.management.RemoteBenchmarkService;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.communication.management.internal.BenchmarkServiceImpl;
import de.rcenvironment.core.communication.management.internal.CommunicationManagementServiceImpl;
import de.rcenvironment.core.communication.management.internal.WorkflowHostServiceImpl;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.internal.NodePropertiesServiceImpl;
import de.rcenvironment.core.communication.nodeproperties.spi.RawNodePropertiesChangeListener;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.routing.internal.NetworkRoutingServiceImpl;
import de.rcenvironment.core.communication.routing.internal.v2.DistributedLinkStateManager;
import de.rcenvironment.core.communication.routing.internal.v2.LinkStateKnowledgeChangeListener;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.api.RemoteServiceCallSenderService;
import de.rcenvironment.core.communication.rpc.internal.CallbackProxyServiceImpl;
import de.rcenvironment.core.communication.rpc.internal.RemoteServiceCallSenderServiceImpl;
import de.rcenvironment.core.communication.rpc.internal.ServiceCallHandlerServiceImpl;
import de.rcenvironment.core.communication.rpc.internal.ServiceProxyFactoryImpl;
import de.rcenvironment.core.communication.rpc.spi.LocalServiceResolver;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.communication.rpc.spi.ServiceProxyFactory;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.testutils.CallbackServiceDefaultStub;
import de.rcenvironment.core.communication.testutils.VirtualCommunicationBundle;
import de.rcenvironment.core.communication.testutils.VirtualServiceRegistry;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.common.service.MockAdditionalServicesRegistrationService;
import org.apache.commons.logging.LogFactory;

public final class VirtualCommunicationBundleFactory {
    private VirtualCommunicationBundleFactory() {
    }

    public static VirtualCommunicationBundle createFromNodeConfigurationService(NodeConfigurationService nodeConfigurationService) {
        return new VirtualCommunicationBundleImpl(nodeConfigurationService);
    }

    private static final class VirtualCommunicationBundleImpl
    implements VirtualCommunicationBundle {
        private MessageChannelServiceImpl messageChannelService;
        private NetworkRoutingServiceImpl routingService;
        private NodePropertiesServiceImpl nodePropertiesService;
        private MockAdditionalServicesRegistrationService listenerRegistrationService;
        private final VirtualServiceRegistry serviceRegistry = new VirtualServiceRegistry();
        private DistributedLinkStateManager distributedLinkStateManager;
        private boolean autoStartNetworkOnActivation = true;
        private CommunicationManagementServiceImpl communicationManagementService;

        VirtualCommunicationBundleImpl(NodeConfigurationService nodeConfigurationService) {
            this.listenerRegistrationService = new MockAdditionalServicesRegistrationService();
            this.serviceRegistry.registerProvidedService(nodeConfigurationService, NodeConfigurationService.class);
            this.serviceRegistry.registerProvidedService(nodeConfigurationService.getNodeIdentifierService(), NodeIdentifierService.class);
            this.messageChannelService = new MessageChannelServiceImpl();
            this.serviceRegistry.registerManagedService((Object)this.messageChannelService, MessageChannelService.class);
            ConnectionSetupServiceImpl connectionSetupService = new ConnectionSetupServiceImpl();
            this.serviceRegistry.registerManagedService((Object)connectionSetupService, false, ConnectionSetupService.class);
            this.listenerRegistrationService.registerAdditionalServicesProvider((AdditionalServicesProvider)connectionSetupService);
            this.nodePropertiesService = new NodePropertiesServiceImpl();
            this.serviceRegistry.registerManagedService((Object)this.nodePropertiesService, NodePropertiesService.class);
            this.routingService = new NetworkRoutingServiceImpl();
            this.serviceRegistry.registerManagedService((Object)this.routingService, NetworkRoutingService.class, MessageRoutingService.class);
            this.listenerRegistrationService.registerAdditionalServicesProvider((AdditionalServicesProvider)this.routingService);
            this.communicationManagementService = new CommunicationManagementServiceImpl();
            this.serviceRegistry.registerManagedService((Object)this.communicationManagementService, CommunicationManagementService.class);
            this.serviceRegistry.registerManagedService((Object)new PlatformServiceImpl(), PlatformService.class);
            this.serviceRegistry.registerManagedService((Object)new LiveNetworkIdResolutionServiceImpl(), false, LiveNetworkIdResolutionService.class);
            this.serviceRegistry.registerManagedService((Object)new RemoteServiceCallSenderServiceImpl(), false, RemoteServiceCallSenderService.class);
            this.serviceRegistry.registerProvidedService(new CallbackServiceDefaultStub(), CallbackService.class);
            this.serviceRegistry.registerProvidedService(new CallbackProxyServiceImpl(), CallbackProxyService.class);
            this.serviceRegistry.registerManagedService((Object)new ServiceProxyFactoryImpl(), false, ServiceProxyFactory.class);
            this.serviceRegistry.registerManagedService((Object)new WorkflowHostServiceImpl(), WorkflowHostService.class);
            CommunicationServiceImpl communicationService = new CommunicationServiceImpl();
            this.serviceRegistry.registerManagedService((Object)communicationService, CommunicationService.class);
            this.listenerRegistrationService.registerAdditionalServicesProvider((AdditionalServicesProvider)communicationService);
            this.distributedLinkStateManager = new DistributedLinkStateManager();
            this.serviceRegistry.registerManagedService((Object)this.distributedLinkStateManager, true, DistributedLinkStateManager.class);
            this.listenerRegistrationService.registerAdditionalServicesProvider((AdditionalServicesProvider)this.distributedLinkStateManager);
            this.serviceRegistry.registerProvidedService(new LocalServiceResolverStub(), LocalServiceResolver.class);
            this.serviceRegistry.registerManagedService((Object)new ServiceCallHandlerServiceImpl(), false, RemoteServiceCallHandlerService.class);
            this.serviceRegistry.registerProvidedService(new BenchmarkServiceImpl(), RemoteBenchmarkService.class);
        }

        @Override
        public void registerNetworkTransportProvider(NetworkTransportProvider newProvider) {
            this.messageChannelService.addNetworkTransportProvider(newProvider);
        }

        @Override
        public void activate() {
            this.communicationManagementService.setAutoStartNetworkOnActivation(this.autoStartNetworkOnActivation);
            this.serviceRegistry.bindAndActivateServices();
            for (Object listener : this.listenerRegistrationService.getListeners(NetworkTopologyChangeListener.class)) {
                this.routingService.addNetworkTopologyChangeListener((NetworkTopologyChangeListener)listener);
            }
            for (Object listener : this.listenerRegistrationService.getListeners(RawNodePropertiesChangeListener.class)) {
                this.nodePropertiesService.addRawNodePropertiesChangeListener((RawNodePropertiesChangeListener)listener);
            }
            for (Object listener : this.listenerRegistrationService.getListeners(MessageChannelLifecycleListener.class)) {
                this.messageChannelService.addChannelLifecycleListener((MessageChannelLifecycleListener)listener);
            }
            for (Object listener : this.listenerRegistrationService.getListeners(LinkStateKnowledgeChangeListener.class)) {
                this.distributedLinkStateManager.addLinkStateKnowledgeChangeListener((LinkStateKnowledgeChangeListener)listener);
            }
        }

        @Override
        public void setAutoStartNetworkOnActivation(boolean autoStartNetworkOnActivation) {
            this.autoStartNetworkOnActivation = autoStartNetworkOnActivation;
        }

        @Override
        public <T> T getService(Class<T> clazz) {
            T implementation = this.serviceRegistry.getService(clazz);
            if (implementation == null) {
                throw new NullPointerException("No activated service provides the interface " + clazz.getName());
            }
            return implementation;
        }

        @Override
        public <T> void injectService(Class<T> clazz, T implementation) {
            this.serviceRegistry.registerProvidedService(implementation, clazz);
        }

        private final class LocalServiceResolverStub
        implements LocalServiceResolver {
            private LocalServiceResolverStub() {
            }

            @Override
            public Object getLocalService(String serviceName) {
                Object impl;
                block3: {
                    try {
                        impl = VirtualCommunicationBundleImpl.this.serviceRegistry.getService(Class.forName(serviceName));
                        if (impl != null) break block3;
                        LogFactory.getLog(this.getClass()).error((Object)("No such service available: " + serviceName));
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        LogFactory.getLog(this.getClass()).error((Object)("Failed to resolve service class " + serviceName), (Throwable)e);
                        return null;
                    }
                }
                return impl;
            }
        }
    }
}

