/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.gui.properties;

import de.rcenvironment.components.xml.loader.gui.properties.Messages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlLoaderComponentSection
extends ValidatingWorkflowNodePropertySection {
    private static final int MINIMUM_HEIGHT_OF_FILE_CONTENT_TEXT = 300;
    private Button fileChooser;
    private Text fileContentText;
    private WorkflowNodePropertySection.LayoutComposite content;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        this.content = new WorkflowNodePropertySection.LayoutComposite(parent);
        this.content.setLayout((Layout)new FillLayout());
        this.initFileChoosingSection(toolkit, (Composite)this.content);
    }

    private void initFileChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        Section section = toolkit.createSection(container, 256);
        section.setText(Messages.fileChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        this.fileChooser = toolkit.createButton(client, Messages.fileLinkButtonLabel, 8);
        toolkit.createCLabel(client, Messages.actuallyLoadedLabel);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.fileContentText = toolkit.createText(client, "", 768);
        this.fileContentText.setEditable(false);
        this.fileContentText.setLayoutData((Object)gridData);
        section.setClient((Control)client);
    }

    private void fileChoosing() {
        IFile file = PropertyTabGuiHelper.selectFileFromProjects((Shell)this.content.getShell(), (String)Messages.loadTitle, (String)Messages.loadMessage);
        if (file != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)file.getContents(), (Writer)writer);
                String theString = writer.toString();
                this.setProperty("xmlContent", theString);
            }
            catch (IOException | CoreException e) {
                this.logger.error((Object)"Cannot read content from file.", e);
            }
            this.refreshSection();
        }
    }

    protected void refreshBeforeValidation() {
        this.setXMLContent();
    }

    private void setXMLContent() {
        if (this.getProperty("xmlContent") != null) {
            this.fileContentText.setText(this.getProperty("xmlContent"));
            return;
        }
        this.fileContentText.setText("");
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new FileController();
    }

    private final class FileController
    extends WorkflowNodePropertySection.DefaultController {
        private FileController() {
            super((WorkflowNodePropertySection)XmlLoaderComponentSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            super.widgetSelected(event, source);
            if (source == XmlLoaderComponentSection.this.fileChooser) {
                XmlLoaderComponentSection.this.fileChoosing();
            }
        }
    }
}

