/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreException;
import org.globus.gsi.provider.SigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicy;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceStoreException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSigningPolicyStore
implements SigningPolicyStore {
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private Map<URI, ResourceSigningPolicy> signingPolicyFileMap = new HashMap<URI, ResourceSigningPolicy>();
    private Map<String, SigningPolicy> policyMap = new HashMap<String, SigningPolicy>();
    private ResourceSigningPolicyStoreParameters parameters;
    private Log logger = LogFactory.getLog(ResourceSigningPolicyStore.class.getCanonicalName());

    public ResourceSigningPolicyStore(SigningPolicyStoreParameters param) throws InvalidAlgorithmParameterException {
        if (param == null) {
            throw new IllegalArgumentException();
        }
        if (!(param instanceof ResourceSigningPolicyStoreParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.parameters = (ResourceSigningPolicyStoreParameters)param;
    }

    @Override
    public SigningPolicy getSigningPolicy(X500Principal caPrincipal) throws SigningPolicyStoreException {
        if (caPrincipal == null) {
            return null;
        }
        this.loadPolicies();
        return this.policyMap.get(caPrincipal.getName());
    }

    private void loadPolicies() throws SigningPolicyStoreException {
        Resource[] resources;
        String locations = this.parameters.getTrustRootLocations();
        try {
            resources = this.resolver.getResources(locations);
        }
        catch (IOException e) {
            throw new SigningPolicyStoreException(e);
        }
        HashMap<String, SigningPolicy> newPolicyMap = new HashMap<String, SigningPolicy>();
        HashMap<URI, ResourceSigningPolicy> newPolicyFileMap = new HashMap<URI, ResourceSigningPolicy>();
        for (Resource resource : resources) {
            if (!resource.isReadable()) {
                this.logger.debug("Cannot read: " + resource.getFilename());
                continue;
            }
            try {
                this.loadSigningPolicy(resource, newPolicyMap, newPolicyFileMap);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load signing policy: " + resource.getFilename(), e);
            }
        }
        this.policyMap = newPolicyMap;
        this.signingPolicyFileMap = newPolicyFileMap;
    }

    private void loadSigningPolicy(Resource policyResource, Map<String, SigningPolicy> policyMapToLoad, Map<URI, ResourceSigningPolicy> currentPolicyFileMap) throws SigningPolicyStoreException {
        URI uri;
        if (!policyResource.isReadable()) {
            throw new SigningPolicyStoreException("Cannot read file");
        }
        try {
            uri = policyResource.getURI();
        }
        catch (IOException e) {
            throw new SigningPolicyStoreException(e);
        }
        ResourceSigningPolicy filePolicy = this.signingPolicyFileMap.get(uri);
        if (filePolicy == null) {
            try {
                filePolicy = new ResourceSigningPolicy(policyResource);
            }
            catch (ResourceStoreException e) {
                throw new SigningPolicyStoreException(e);
            }
        }
        Collection<SigningPolicy> policies = filePolicy.getSigningPolicies();
        currentPolicyFileMap.put(uri, filePolicy);
        if (policies != null) {
            for (SigningPolicy policy : policies) {
                policyMapToLoad.put(policy.getCASubjectDN().getName(), policy);
            }
        }
    }
}

