/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.io.FileUtils;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.stores.CredentialWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.SecurityObjectWrapper;
import org.globus.gsi.stores.Storable;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertKeyCredential
implements SecurityObjectWrapper<X509Credential>,
Storable,
CredentialWrapper {
    protected Resource certFile;
    protected Resource keyFile;
    private long certLastModified = -1L;
    private long keyLastModified = -1L;
    private X509Credential credential;
    private boolean changed;

    public CertKeyCredential(Resource certResource, Resource keyResource) throws ResourceStoreException {
        this.init(certResource, keyResource);
    }

    public CertKeyCredential(Resource certResource, Resource keyResource, X509Credential credential) throws ResourceStoreException {
        this.certFile = certResource;
        try {
            if (!certResource.exists()) {
                FileUtils.touch(certResource.getFile());
                this.certLastModified = certResource.lastModified();
            }
            this.keyFile = keyResource;
            if (!keyResource.exists()) {
                FileUtils.touch(keyResource.getFile());
                this.keyLastModified = keyResource.lastModified();
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        this.credential = credential;
    }

    protected void init(Resource initCertResource, Resource initKeyResource) throws ResourceStoreException {
        if (initCertResource == null || initKeyResource == null) {
            throw new IllegalArgumentException();
        }
        this.certFile = initCertResource;
        this.keyFile = initKeyResource;
        this.credential = this.createObject(this.certFile, this.keyFile);
        try {
            this.certLastModified = this.certFile.lastModified();
            this.keyLastModified = this.keyFile.lastModified();
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
    }

    protected void init(Resource initCertFile, Resource keyResource, X509Credential initCredential) throws ResourceStoreException {
        if (initCredential == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.credential = initCredential;
        this.certFile = initCertFile;
        this.keyFile = keyResource;
    }

    @Override
    public void refresh() throws ResourceStoreException {
        long kLatestLastModified;
        long cLatestLastModified;
        this.changed = false;
        try {
            cLatestLastModified = this.certFile.lastModified();
            kLatestLastModified = this.keyFile.lastModified();
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
        if (this.certLastModified < cLatestLastModified || this.keyLastModified < kLatestLastModified) {
            this.credential = this.createObject(this.certFile, this.keyFile);
            this.certLastModified = cLatestLastModified;
            this.keyLastModified = kLatestLastModified;
            this.changed = true;
        }
    }

    public Resource getCertificateFile() {
        return this.certFile;
    }

    public Resource getKeyFile() {
        return this.keyFile;
    }

    protected X509Credential createObject(Resource certSource, Resource keySource) throws ResourceStoreException {
        try {
            InputStream certIns = certSource.getInputStream();
            InputStream keyIns = keySource.getInputStream();
            return new X509Credential(certIns, keyIns);
        }
        catch (FileNotFoundException e) {
            throw new ResourceStoreException(e);
        }
        catch (CredentialException e) {
            throw new ResourceStoreException(e);
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
    }

    @Override
    public X509Credential getSecurityObject() throws ResourceStoreException {
        this.refresh();
        return this.credential;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public X509Credential getCredential() throws ResourceStoreException {
        return this.getSecurityObject();
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            this.credential.writeToFile(this.certFile.getFile(), this.keyFile.getFile());
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public String getAlias() {
        return null;
    }
}

